/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server.containers.inventory;

import com.legacy.aether.server.containers.util.AccessoryType;
import com.legacy.aether.server.items.accessories.ItemAccessory;
import com.legacy.aether.server.player.PlayerAether;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class InventoryAccessories
implements IInventory {
    public EntityPlayer player;
    public ItemStack[] stacks = new ItemStack[8];
    public static final String[] EMPTY_SLOT_NAMES = new String[]{"pendant", "cape", "shield", "misc", "ring", "ring", "gloves", "misc"};
    public AccessoryType[] slotTypes = new AccessoryType[]{AccessoryType.PENDANT, AccessoryType.CAPE, AccessoryType.SHIELD, AccessoryType.MISC, AccessoryType.RING, AccessoryType.RING, AccessoryType.GLOVE, AccessoryType.MISC};

    public InventoryAccessories(PlayerAether playerAether) {
        this.player = playerAether.thePlayer;
    }

    public void dropAllItems() {
        for (int slot = 0; slot < this.stacks.length; ++slot) {
            if (this.stacks[slot] == null) continue;
            this.player.func_146097_a(this.stacks[slot], true, true);
            this.stacks[slot] = null;
        }
    }

    public void damageItemStackIfWearing(ItemStack itemStack) {
        ItemStack currentAccessory = this.getStackFromItem(itemStack.func_77973_b());
        if (currentAccessory != null && !this.player.field_71075_bZ.field_75098_d) {
            currentAccessory.func_77972_a(1, (EntityLivingBase)this.player);
            if (currentAccessory.func_77952_i() >= currentAccessory.func_77958_k()) {
                this.breakItem(currentAccessory.func_77973_b());
            }
        }
    }

    public int breakItem(Item item) {
        int count = 0;
        for (int i = 0; i < this.stacks.length; ++i) {
            ItemStack itemstack = this.stacks[i];
            if (itemstack == null || itemstack != this.getStackFromItem(item) || item == null && itemstack.func_77973_b() != item) continue;
            if (itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74767_n("Unbreakable")) {
                return count;
            }
            count += itemstack.field_77994_a;
            this.stacks[i] = null;
        }
        return count;
    }

    public int func_70302_i_() {
        return this.stacks.length;
    }

    public boolean setInventoryAccessory(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemAccessory) {
            ItemAccessory accessoryItem = (ItemAccessory)stack.func_77973_b();
            AccessoryType type = accessoryItem.getType();
            int stackIndex = 0;
            for (AccessoryType accessoryType : this.slotTypes) {
                if (type == accessoryType && this.stacks[stackIndex] == null) {
                    this.stacks[stackIndex] = stack;
                    this.func_70296_d();
                    return true;
                }
                ++stackIndex;
            }
        }
        return false;
    }

    public void func_70299_a(int slotID, ItemStack stack) {
        if (slotID < this.stacks.length) {
            this.stacks[slotID] = stack;
            this.func_70296_d();
        }
    }

    public ItemStack func_70301_a(int slotID) {
        return this.stacks[slotID];
    }

    public ItemStack getStackFromItem(Item item) {
        for (ItemStack stack : this.stacks) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemAccessory) || stack.func_77973_b() != item) continue;
            return stack;
        }
        return null;
    }

    public ItemStack func_70298_a(int slotID, int decreaseSize) {
        ItemStack[] accessories = this.stacks;
        if (accessories[slotID] != null) {
            if (accessories[slotID].field_77994_a <= decreaseSize) {
                ItemStack itemstack = accessories[slotID];
                accessories[slotID] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = accessories[slotID].func_77979_a(decreaseSize);
            if (accessories[slotID].field_77994_a == 0) {
                accessories[slotID] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotID) {
        ItemStack[] accessories = this.stacks;
        if (accessories[slotID] != null) {
            ItemStack itemstack = accessories[slotID];
            accessories[slotID] = null;
            return itemstack;
        }
        return null;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public String func_70005_c_() {
        return "accessories";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !player.field_70128_L && player.func_70068_e((Entity)this.player) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slotID, ItemStack stack) {
        return true;
    }

    public void func_70296_d() {
        PlayerAether.get(this.player).updateAccessories();
    }

    public void copyAccessories(InventoryAccessories accessories) {
        for (int size = 0; size < this.stacks.length; ++size) {
            this.stacks[size] = ItemStack.func_77944_b((ItemStack)accessories.stacks[size]);
        }
    }

    public NBTTagList writeToNBT(NBTTagList tagList) {
        for (int size = 0; size < this.stacks.length; ++size) {
            ItemStack stack = this.stacks[size];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("accessories", (byte)size);
            stack.func_77955_b(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        return tagList;
    }

    public void readFromNBT(NBTTagList tagList) {
        this.stacks = new ItemStack[8];
        for (int size = 0; size < tagList.func_74745_c(); ++size) {
            NBTTagCompound tag = tagList.func_150305_b(size);
            int slot = tag.func_74771_c("accessories") & 0xFF;
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (stack == null || slot < 0 || slot >= this.stacks.length) continue;
            this.func_70299_a(slot, stack);
        }
    }

    public void writeData(ByteBuf dataOutput) {
        dataOutput.writeInt(this.stacks.length);
        for (ItemStack stack : this.stacks) {
            PacketBuffer pb = new PacketBuffer(dataOutput);
            try {
                pb.func_150788_a(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void readData(ByteBuf dataInput) {
        int amount = dataInput.readInt();
        ItemStack[] stackArray = new ItemStack[amount];
        for (int i = 0; i < amount; ++i) {
            PacketBuffer pb = new PacketBuffer(dataInput);
            try {
                stackArray[i] = pb.func_150791_c();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.stacks = stackArray;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174887_a_(int id) {
        return id;
    }

    public int func_174890_g() {
        int count = 0;
        for (int slot = 0; slot < this.stacks.length; ++slot) {
            if (this.stacks[slot] == null) continue;
            ++count;
        }
        return count;
    }

    public void func_174888_l() {
        for (int slot = 0; slot < this.stacks.length; ++slot) {
            ItemStack itemstack = this.stacks[slot];
            if (itemstack == null) continue;
            this.stacks[slot] = null;
        }
        this.func_70296_d();
    }
}

