/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.common.config.Configuration;

public class AetherConfig {
    private static boolean aether_menu;
    private static boolean christmas_content;
    private static int aether_biome_id;
    private static int aether_dimension_id;
    private static boolean disable_trivia;
    private static boolean skyrootBucketOnly;

    public static void init(File location) {
        File newFile = new File(location + "/aether" + "/Aether_Legacy.cfg");
        try {
            newFile.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Configuration config = new Configuration(newFile);
        config.load();
        aether_menu = config.get("Aether Menu Options", "Use Aether Menu", false).getBoolean(false);
        christmas_content = config.get("Aether World Generation", "Christmas Content", false).getBoolean(false);
        aether_dimension_id = config.get("World Identification", "Aether Dimension ID", 4).getInt(4);
        aether_biome_id = config.get("World Identification", "Aether Biome ID", 127).getInt(127);
        skyrootBucketOnly = config.get("Misc", "Activate portal with only Skyroot bucket", false).getBoolean(false);
        disable_trivia = config.get("Trivia", "Disable random trivia", false).getBoolean(false);
        config.save();
    }

    public static int getAetherDimensionID() {
        return aether_dimension_id;
    }

    public static int getAetherBiomeID() {
        return aether_biome_id;
    }

    public static boolean triviaDisabled() {
        return disable_trivia;
    }

    public static boolean shouldUseAetherMenu() {
        return aether_menu;
    }

    public static boolean shouldLoadHolidayContent() {
        return christmas_content;
    }

    public static boolean activateOnlyWithSkyroot() {
        return skyrootBucketOnly;
    }
}

