/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.server;

import com.legacy.aether.server.AetherConfig;
import com.legacy.aether.server.AetherEventHandler;
import com.legacy.aether.server.ServerProxy;
import com.legacy.aether.server.blocks.BlocksAether;
import com.legacy.aether.server.entities.AetherEntities;
import com.legacy.aether.server.items.ItemsAether;
import com.legacy.aether.server.networking.AetherNetworkingManager;
import com.legacy.aether.server.player.capability.PlayerAetherManager;
import com.legacy.aether.server.registry.achievements.AchievementsAether;
import com.legacy.aether.server.registry.creative_tabs.AetherCreativeTabs;
import com.legacy.aether.server.registry.recipes.AetherRecipes;
import com.legacy.aether.server.registry.sounds.SoundsAether;
import com.legacy.aether.server.tile_entities.AetherTileEntities;
import com.legacy.aether.server.world.AetherWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(name="Aether Legacy", modid="aether_legacy", version="v1.4", acceptedMinecraftVersions="1.9.4")
public class Aether {
    public static final String modid = "aether_legacy";
    @Mod.Instance(value="aether_legacy")
    public static Aether instance;
    @SidedProxy(modId="aether_legacy", clientSide="com.legacy.aether.client.ClientProxy", serverSide="com.legacy.aether.server.ServerProxy")
    public static ServerProxy proxy;

    @Mod.EventHandler
    public void preInitialization(FMLPreInitializationEvent event) {
        AetherConfig.init(event.getModConfigurationDirectory());
        AetherNetworkingManager.preInitialization();
        proxy.preInitialization();
    }

    @Mod.EventHandler
    public void initialization(FMLInitializationEvent event) {
        PlayerAetherManager.initialization();
        SoundsAether.initialization();
        AetherEntities.initialization();
        BlocksAether.initialization();
        ItemsAether.initialization();
        AetherRecipes.initialization();
        AchievementsAether.initialization();
        AetherTileEntities.initialization();
        AetherCreativeTabs.initialization();
        AetherWorld.initialization();
        proxy.initialization();
        ServerProxy.registerEvent(new AetherEventHandler());
    }

    public static ResourceLocation locate(String location) {
        return new ResourceLocation(modid, location);
    }

    public static String modAddress() {
        return "aether_legacy:";
    }

    public static String doubleDropNotifier() {
        return "aether_legacy_double_drops";
    }
}

