/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.client.gui.menu;

import com.legacy.aether.client.gui.menu.GuiAetherMainMenu;
import com.legacy.aether.client.gui.menu.GuiAetherMainMenuFallback;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiAccessDenied;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AetherMenuHandler {
    private Minecraft mc = Minecraft.func_71410_x();
    private static boolean world_loaded;
    private static boolean menu_loaded;

    @SubscribeEvent
    public void onPlayerLoggingOut(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        GuiScreen gui = event.getGui();
        int id = event.getButton().field_146127_k;
        if ((gui instanceof GuiDisconnected || gui instanceof GuiAccessDenied) && (id == 0 || id == 1)) {
            this.unloadWorld();
            this.loadWorld();
        }
    }

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent event) {
        if (event.getGui() == null && !world_loaded) {
            world_loaded = true;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) throws Exception {
        TickEvent.Phase phase = event.phase;
        TickEvent.Type type = event.type;
        if (phase == TickEvent.Phase.END && type.equals((Object)TickEvent.Type.CLIENT)) {
            this.updateMenu();
        }
    }

    private void updateMenu() throws Exception {
        GuiScreen screen = this.mc.field_71462_r;
        if (screen != null && screen.getClass() == GuiMainMenu.class) {
            this.unloadWorld();
            if (this.mc.func_71359_d().func_75799_b().size() <= 0) {
                this.mc.func_147108_a((GuiScreen)new GuiAetherMainMenuFallback());
            } else {
                this.loadWorld();
            }
        }
        if (world_loaded && !(screen instanceof GuiAetherMainMenu) && !menu_loaded) {
            this.mc.func_147108_a((GuiScreen)new GuiAetherMainMenu(false));
            menu_loaded = true;
        }
    }

    public void loadWorld() {
        if (this.mc.field_71441_e != null) {
            this.mc.field_71441_e.func_72882_A();
        }
        FMLClientHandler.instance().tryLoadExistingWorld(null, this.getWorldSummary(0));
    }

    public void unloadWorld() {
        world_loaded = false;
        menu_loaded = false;
    }

    protected WorldSummary getWorldSummary(int fileNumber) {
        WorldSummary s = null;
        List list = null;
        try {
            list = this.mc.func_71359_d().func_75799_b();
            Collections.sort(list);
            s = (WorldSummary)list.get(fileNumber);
        }
        catch (AnvilConverterException e) {
            e.printStackTrace();
        }
        return s;
    }
}

