/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.client.gui;

import com.legacy.aether.client.overlay.AetherOverlay;
import com.legacy.aether.server.player.PlayerAether;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuiAetherInGame
extends Gui {
    private Minecraft mc;

    public GuiAetherInGame(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        PlayerAether player;
        if (this.mc.field_71439_g != null && (player = PlayerAether.get((EntityPlayer)this.mc.field_71439_g)).isWearingPhoenixSet() && event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent event) {
        float portalTime;
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        PlayerAether player = PlayerAether.get((EntityPlayer)this.mc.field_71439_g);
        if (player.poisonInstance() != null) {
            AetherOverlay.renderCure(this.mc);
            AetherOverlay.renderPoison(this.mc);
        }
        if (player.thePlayer != null) {
            AetherOverlay.renderIronBubble(this.mc);
            AetherOverlay.renderCooldown(this.mc);
            AetherOverlay.renderJumps(this.mc);
            AetherOverlay.renderBossHP(this.mc);
        }
        if ((portalTime = player.portalAnimTime * 1.2f + (player.prevPortalAnimTime - player.portalAnimTime)) > 0.0f && portalTime > 0.0f) {
            AetherOverlay.renderAetherPortal(portalTime, new ScaledResolution(this.mc));
        }
    }
}

