/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.client;

import com.legacy.aether.client.FirstPersonRenderer;
import com.legacy.aether.client.gui.AetherLoadingScreen;
import com.legacy.aether.client.gui.inventory.GuiAccessories;
import com.legacy.aether.server.AetherConfig;
import com.legacy.aether.server.containers.inventory.InventoryAccessories;
import com.legacy.aether.server.items.ItemsAether;
import com.legacy.aether.server.networking.AetherNetworkingManager;
import com.legacy.aether.server.networking.packets.PacketOpenContainer;
import com.legacy.aether.server.player.PlayerAether;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AetherClientEvents {
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) throws Exception {
        Minecraft mc = Minecraft.func_71410_x();
        TickEvent.Phase phase = event.phase;
        TickEvent.Type type = event.type;
        if (phase == TickEvent.Phase.END && type.equals((Object)TickEvent.Type.CLIENT) && !AetherConfig.triviaDisabled() && !(mc.field_71461_s instanceof AetherLoadingScreen)) {
            mc.field_71461_s = new AetherLoadingScreen(mc);
        }
    }

    @SubscribeEvent
    public void onInventoryKeyPressed(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null && mc.field_71441_e != null && mc.field_71439_g != null && !mc.field_71439_g.field_71075_bZ.field_75098_d && mc.field_71474_y.field_151445_Q.func_151468_f()) {
            if (!mc.field_71439_g.func_189102_a(AchievementList.field_187982_f)) {
                mc.func_147114_u().func_147297_a((Packet)new CPacketClientStatus(CPacketClientStatus.State.OPEN_INVENTORY_ACHIEVEMENT));
            }
            AetherNetworkingManager.sendToServer(new PacketOpenContainer(1));
        }
    }

    @SubscribeEvent
    public void onBowPulled(FOVUpdateEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player != null && player.func_184607_cu() == null) {
            return;
        }
        Item item = player.func_184607_cu().func_77973_b();
        if (item == ItemsAether.phoenix_bow) {
            int i = player.func_184612_cw();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            float original = event.getFov();
            event.setNewfov(original *= 1.0f - f1 * 0.15f);
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        FirstPersonRenderer render = new FirstPersonRenderer(mc, event.getPartialTicks());
        if (render.shouldRender()) {
            mc.field_71460_t.func_180436_i();
            render.render();
            mc.field_71460_t.func_175072_h();
        }
    }

    @SubscribeEvent
    public void onInvisibilityPlayerUpdate(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        PlayerAether playerAether = PlayerAether.get(player);
        if (playerAether != null && playerAether.wearingAccessory(ItemsAether.invisibility_cape)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTextureStichedEvent(TextureStitchEvent event) {
        for (int i = 0; i < InventoryAccessories.EMPTY_SLOT_NAMES.length; ++i) {
            event.getMap().func_174942_a(new ResourceLocation("aether_legacy", "items/slots/" + InventoryAccessories.EMPTY_SLOT_NAMES[i]));
        }
    }

    @SubscribeEvent
    public void onStopPotionEffect(GuiScreenEvent.PotionShiftEvent event) {
        if (event.getGui() instanceof GuiAccessories) {
            event.setCanceled(true);
        }
    }
}

