/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponSpawnEntity;
import com.vicmatskiv.weaponlib.WorldHelper;
import com.vicmatskiv.weaponlib.compatibility.Compatibility;
import com.vicmatskiv.weaponlib.compatibility.CompatibleMathHelper;
import com.vicmatskiv.weaponlib.compatibility.CompatibleParticle;
import com.vicmatskiv.weaponlib.compatibility.CompatibleRayTraceResult;
import com.vicmatskiv.weaponlib.compatibility.CompatibleRenderingRegistry;
import com.vicmatskiv.weaponlib.compatibility.CompatibleSound;
import com.vicmatskiv.weaponlib.compatibility.CompatibleVec3;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class Compatibility1_10_2
implements Compatibility {
    private static CompatibleMathHelper mathHelper = new CompatibleMathHelper();

    @Override
    public World world(Entity entity) {
        return entity.field_70170_p;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityPlayer clientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void spawnEntity(EntityPlayer player, Entity entity) {
        player.field_70170_p.func_72838_d(entity);
    }

    @Override
    public void moveParticle(CompatibleParticle particle, double motionX, double motionY, double motionZ) {
        particle.func_187110_a(motionX, motionY, motionZ);
    }

    @Override
    public int getStackSize(ItemStack consumedStack) {
        return 0;
    }

    @Override
    public ItemStack consumeInventoryItem(Item item, Predicate<ItemStack> condition, EntityPlayer player, int maxSize) {
        return null;
    }

    @Override
    public NBTTagCompound getTagCompound(ItemStack itemStack) {
        return itemStack.func_77978_p();
    }

    @Override
    public ItemStack getItemStack(ItemTossEvent event) {
        return event.getEntityItem().func_92059_d();
    }

    @Override
    public EntityPlayer getPlayer(ItemTossEvent event) {
        return event.getPlayer();
    }

    @Override
    public ItemStack getHeldItemMainHand(EntityLivingBase player) {
        return player.func_184614_ca();
    }

    @Override
    public boolean consumeInventoryItem(EntityPlayer player, Item item) {
        return WorldHelper.consumeInventoryItem(player.field_71071_by, item);
    }

    @Override
    public void ensureTagCompound(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    @Override
    public void playSound(EntityPlayer player, CompatibleSound sound, float volume, float pitch) {
        if (sound != null) {
            player.func_184185_a(sound.getSound(), volume, pitch);
        }
    }

    @Override
    public IAttribute getMovementSpeedAttribute() {
        return SharedMonsterAttributes.field_111263_d;
    }

    @Override
    public void setTagCompound(ItemStack itemStack, NBTTagCompound tagCompound) {
        itemStack.func_77982_d(tagCompound);
    }

    @Override
    public WeaponSpawnEntity getSpawnEntity(Weapon weapon, World world, EntityPlayer player, float speed, float gravityVelocity, float inaccuracy, float damage, float explosionRadius, Material ... damageableBlockMaterials) {
        return new WeaponSpawnEntity(weapon, player.field_70170_p, (EntityLivingBase)player, speed, gravityVelocity, inaccuracy, damage, explosionRadius, new Material[0]);
    }

    @Override
    public boolean isClientSide() {
        return FMLCommonHandler.instance().getSide() == Side.CLIENT;
    }

    @Override
    public CompatibleMathHelper getMathHelper() {
        return mathHelper;
    }

    @Override
    public void playSoundToNearExcept(EntityPlayer player, CompatibleSound sound, float volume, float pitch) {
        player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound.getSound(), player.func_184176_by(), volume, pitch);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getClientPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ScaledResolution getResolution(RenderGameOverlayEvent.Pre event) {
        return event.getResolution();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderGameOverlayEvent.ElementType getEventType(RenderGameOverlayEvent.Pre event) {
        return event.getType();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getHelmet() {
        Iterator equipmentIterator = Minecraft.func_71410_x().field_71439_g.func_184209_aF().iterator();
        return equipmentIterator.hasNext() ? (ItemStack)equipmentIterator.next() : null;
    }

    @Override
    public CompatibleVec3 getLookVec(EntityPlayer player) {
        return new CompatibleVec3(player.func_70040_Z());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerKeyBinding(KeyBinding key) {
        ClientRegistry.registerKeyBinding((KeyBinding)key);
    }

    @Override
    public void registerWithEventBus(Object object) {
        MinecraftForge.EVENT_BUS.register(object);
    }

    @Override
    public void registerWithFmlEventBus(Object object) {
        MinecraftForge.EVENT_BUS.register(object);
    }

    @Override
    public void registerSound(CompatibleSound sound) {
        GameRegistry.register((IForgeRegistryEntry)sound.getSound(), (ResourceLocation)sound.getResourceLocation());
    }

    @Override
    public void registerItem(Item item, String name) {
        GameRegistry.registerItem((Item)item, (String)name);
    }

    @Override
    public void registerItem(String modId, Item item, String name) {
        if (item.getRegistryName() == null) {
            String registryName = item.func_77658_a();
            int indexOfPrefix = registryName.indexOf("." + modId);
            if (indexOfPrefix > 0) {
                registryName = registryName.substring(indexOfPrefix + modId.length() + 2);
            }
            item.setRegistryName(modId, registryName);
        }
        GameRegistry.register((IForgeRegistryEntry)item);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void runInMainClientThread(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }

    @Override
    public void registerModEntity(Class<WeaponSpawnEntity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    @Override
    public void registerRenderingRegistry(CompatibleRenderingRegistry rendererRegistry) {
        MinecraftForge.EVENT_BUS.register((Object)rendererRegistry);
    }

    @Override
    public <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        return (T)ObfuscationReflectionHelper.getPrivateValue(classToAccess, instance, (String[])fieldNames);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getButton(MouseEvent event) {
        return event.getButton();
    }

    @Override
    public EntityPlayer getEntity(FOVUpdateEvent event) {
        return event.getEntity();
    }

    @Override
    public EntityLivingBase getEntity(RenderLivingEvent.Pre event) {
        return event.getEntity();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setNewFov(FOVUpdateEvent event, float fov) {
        event.setNewfov(fov);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderPlayer getRenderer(RenderLivingEvent.Pre event) {
        return (RenderPlayer)event.getRenderer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(GuiOpenEvent event) {
        return event.getGui();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setAimed(RenderPlayer rp, boolean aimed) {
        if (aimed) {
            rp.func_177087_b().field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
            rp.func_177087_b().field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
        } else {
            rp.func_177087_b().field_187075_l = ModelBiped.ArmPose.EMPTY;
            rp.func_177087_b().field_187076_m = ModelBiped.ArmPose.ITEM;
        }
    }

    @Override
    public CompatibleRayTraceResult getObjectMouseOver() {
        return new CompatibleRayTraceResult(Minecraft.func_71410_x().field_71476_x);
    }

    @Override
    public Block getBlockAtPosition(World world, CompatibleRayTraceResult position) {
        Block block = world.func_180495_p(new BlockPos(position.getBlockPosX(), position.getBlockPosY(), position.getBlockPosZ())).func_177230_c();
        return block;
    }

    @Override
    public void destroyBlock(World world, CompatibleRayTraceResult position) {
        world.func_175655_b(new BlockPos(position.getBlockPosX(), position.getBlockPosY(), position.getBlockPosZ()), true);
    }

    @Override
    public boolean consumeInventoryItem(InventoryPlayer inventoryPlayer, Item item) {
        boolean result = false;
        for (int i = 0; i < inventoryPlayer.func_70302_i_(); ++i) {
            ItemStack stack = inventoryPlayer.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item) continue;
            if (--stack.field_77994_a <= 0) {
                inventoryPlayer.func_70299_a(i, null);
            }
            result = true;
            break;
        }
        return result;
    }

    @Override
    public ItemStack itemStackForItem(Item item, Predicate<ItemStack> condition, EntityPlayer player) {
        ItemStack result = null;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || !condition.test(stack)) continue;
            result = stack;
            break;
        }
        return result;
    }

    @Override
    public boolean isGlassBlock(Block block) {
        return block == Blocks.field_150359_w || block == Blocks.field_150410_aZ || block == Blocks.field_150399_cn || block == Blocks.field_150397_co;
    }

    @Override
    public float getEffectOffsetX() {
        return 0.0f;
    }

    @Override
    public float getEffectOffsetY() {
        return -1.6f;
    }

    @Override
    public float getEffectScaleFactor() {
        return 1.0f;
    }

    @Override
    public int getCurrentInventoryItemIndex(EntityPlayer player) {
        return player.field_71071_by.field_70461_c;
    }

    @Override
    public boolean addItemToPlayerInventory(EntityPlayer player, Item item, int slot) {
        boolean result = false;
        if (slot == -1) {
            player.field_71071_by.func_70441_a(new ItemStack(item));
        } else if (player.field_71071_by.field_70462_a[slot] == null) {
            player.field_71071_by.field_70462_a[slot] = new ItemStack(item);
        }
        return result;
    }

    @Override
    public ItemStack getInventoryItemStack(EntityPlayer player, int inventoryItemIndex) {
        return player.field_71071_by.func_70301_a(inventoryItemIndex);
    }

    @Override
    public int getInventorySlot(EntityPlayer player, ItemStack itemStack) {
        int slot = -1;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] != itemStack) continue;
            slot = i;
            break;
        }
        return slot;
    }

    @Override
    public boolean consumeInventoryItemFromSlot(EntityPlayer player, int slot) {
        if (player.field_71071_by.field_70462_a[slot] == null) {
            return false;
        }
        if (--player.field_71071_by.field_70462_a[slot].field_77994_a <= 0) {
            player.field_71071_by.field_70462_a[slot] = null;
        }
        return true;
    }

    @Override
    public void addShapedRecipe(ItemStack itemStack, Object ... materials) {
        GameRegistry.addShapedRecipe((ItemStack)itemStack, (Object[])materials);
    }

    @Override
    public void addShapedOreRecipe(ItemStack itemStack, Object ... materials) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, materials));
    }

    @Override
    public void disableLightMap() {
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
    }

    @Override
    public void enableLightMap() {
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    @Override
    public void registerBlock(String modId, Block block, String name) {
        if (block.getRegistryName() == null) {
            if (block.func_149739_a().length() < modId.length() + 2 + 5) {
                throw new IllegalArgumentException("Unlocalize block name too short " + block.func_149739_a());
            }
            String unlocalizedName = block.func_149739_a();
            String registryName = unlocalizedName.substring(5 + modId.length() + 1);
            block.setRegistryName(modId, registryName);
        }
        GameRegistry.register((IForgeRegistryEntry)block);
        ItemBlock itemBlock = new ItemBlock(block);
        GameRegistry.register((IForgeRegistryEntry)itemBlock.setRegistryName(block.getRegistryName()));
    }

    @Override
    public void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)generator, (int)modGenerationWeight);
    }

    @Override
    public ItemArmor.ArmorMaterial addArmorMaterial(String name, String textureName, int durability, int[] reductionAmounts, int enchantability, CompatibleSound soundOnEquip, float toughness) {
        return EnumHelper.addArmorMaterial((String)name, (String)textureName, (int)durability, (int[])reductionAmounts, (int)enchantability, (SoundEvent)(soundOnEquip != null ? soundOnEquip.getSound() : null), (float)toughness);
    }

    @Override
    public boolean inventoryHasFreeSlots(EntityPlayer player) {
        boolean result = false;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] != null) continue;
            result = true;
            break;
        }
        return result;
    }
}

