/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.animation;

import java.nio.FloatBuffer;
import java.util.Random;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

final class Randomizer {
    private Random random = new Random();
    private Matrix4f beforeMatrix;
    private Matrix4f afterMatrix;
    private Matrix4f currentMatrix = this.getMatrixForPositioning(() -> {});
    private long startTime;
    private float rate = 0.25f;
    private float amplitude = 0.04f;
    private float xbias = 0.0f;
    private float ybias = 0.0f;
    private float zbias = 0.0f;

    public Randomizer() {
        this.next();
    }

    private boolean reconfigure(float rate, float amplitude) {
        if (rate == this.rate && amplitude == this.amplitude) {
            return false;
        }
        boolean reconfigured = false;
        if (rate != this.rate || amplitude != this.amplitude) {
            if (rate == 0.0f && amplitude == 0.0f) {
                this.beforeMatrix = this.currentMatrix = this.getMatrixForPositioning(() -> {});
                this.afterMatrix = this.currentMatrix;
            } else {
                reconfigured = true;
            }
        }
        this.rate = rate;
        this.amplitude = amplitude;
        if (reconfigured) {
            this.next();
        }
        return reconfigured;
    }

    private void next() {
        this.beforeMatrix = this.currentMatrix;
        this.afterMatrix = this.createRandomMatrix();
        this.startTime = System.currentTimeMillis();
    }

    private Matrix4f createRandomMatrix() {
        Runnable c = () -> {
            float xRandomOffset = this.amplitude * ((this.random.nextFloat() - 0.5f) * 2.0f + this.xbias);
            float yRandomOffset = this.amplitude * ((this.random.nextFloat() - 0.5f) * 2.0f + this.ybias);
            float zRandomOffset = this.amplitude * ((this.random.nextFloat() - 0.5f) * 2.0f + this.zbias) / 2.0f;
            GL11.glTranslatef((float)xRandomOffset, (float)yRandomOffset, (float)zRandomOffset);
        };
        return this.getMatrixForPositioning(c);
    }

    private Matrix4f getMatrixForPositioning(Runnable position) {
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        position.run();
        GL11.glGetFloat((int)2982, (FloatBuffer)buf);
        buf.rewind();
        Matrix4f matrix = new Matrix4f();
        matrix.load(buf);
        GL11.glPopMatrix();
        return matrix;
    }

    public void update(float rate, float amplitude) {
        this.reconfigure(rate, amplitude);
        if (rate == 0.0f || amplitude == 0.0f) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        float progress = (float)(currentTime - this.startTime) * rate / 1000.0f;
        if (progress >= 1.0f) {
            this.next();
            progress = 0.0f;
        }
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)buf);
        buf.rewind();
        Matrix4f currentTransformMatrix = new Matrix4f();
        currentTransformMatrix.load(buf);
        Matrix4f m1 = this.scale(this.beforeMatrix, 1.0f - progress);
        Matrix4f m2 = this.scale(this.afterMatrix, progress);
        this.currentMatrix = Matrix4f.add((Matrix4f)m1, (Matrix4f)m2, null);
        Matrix4f composite = Matrix4f.mul((Matrix4f)currentTransformMatrix, (Matrix4f)this.currentMatrix, null);
        FloatBuffer buf2 = BufferUtils.createFloatBuffer((int)16);
        composite.store(buf2);
        buf2.rewind();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadMatrix((FloatBuffer)buf2);
    }

    private Matrix4f scale(Matrix4f m, float factor) {
        Matrix4f result = new Matrix4f();
        result.m00 = m.m00 * factor;
        result.m01 = m.m01 * factor;
        result.m02 = m.m02 * factor;
        result.m03 = m.m03 * factor;
        result.m10 = m.m10 * factor;
        result.m11 = m.m11 * factor;
        result.m12 = m.m12 * factor;
        result.m13 = m.m13 * factor;
        result.m20 = m.m20 * factor;
        result.m21 = m.m21 * factor;
        result.m22 = m.m22 * factor;
        result.m23 = m.m23 * factor;
        result.m30 = m.m30 * factor;
        result.m31 = m.m31 * factor;
        result.m32 = m.m32 * factor;
        result.m33 = m.m33 * factor;
        return result;
    }
}

