/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleRayTraceResult;
import com.vicmatskiv.weaponlib.compatibility.CompatibleWeaponSpawnEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class WeaponSpawnEntity
extends CompatibleWeaponSpawnEntity {
    static final float DEFAULT_INACCURACY = 1.0f;
    private float explosionRadius = 0.1f;
    private float damage = 6.0f;
    private float speed;
    private float gravityVelocity;
    private float inaccuracy;
    private Weapon weapon;

    public WeaponSpawnEntity(World world) {
        super(world);
    }

    public WeaponSpawnEntity(World par1World, EntityLivingBase arg1EntityLivingBase) {
        super(par1World, arg1EntityLivingBase);
    }

    public WeaponSpawnEntity(Weapon weapon, World world, EntityLivingBase player, float speed, float gravityVelocity, float inaccuracy, float damage, float explosionRadius, Material ... damageableBlockMaterials) {
        super(world, player);
        this.weapon = weapon;
        this.damage = damage;
        this.speed = speed;
        this.explosionRadius = explosionRadius;
        this.inaccuracy = inaccuracy;
        this.gravityVelocity = gravityVelocity;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
        this.field_70165_t -= (double)(CompatibilityProvider.compatibility.getMathHelper().cos(this.field_70177_z / 180.0f * (float)Math.PI) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(CompatibilityProvider.compatibility.getMathHelper().sin(this.field_70177_z / 180.0f * (float)Math.PI) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.4f;
        this.field_70159_w = -CompatibilityProvider.compatibility.getMathHelper().sin(this.field_70177_z / 180.0f * (float)Math.PI) * CompatibilityProvider.compatibility.getMathHelper().cos(this.field_70125_A / 180.0f * (float)Math.PI) * f;
        this.field_70179_y = CompatibilityProvider.compatibility.getMathHelper().cos(this.field_70177_z / 180.0f * (float)Math.PI) * CompatibilityProvider.compatibility.getMathHelper().cos(this.field_70125_A / 180.0f * (float)Math.PI) * f;
        float pitchOffset = 0.0f;
        this.field_70181_x = -CompatibilityProvider.compatibility.getMathHelper().sin((this.field_70125_A + pitchOffset) / 180.0f * (float)Math.PI) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed, inaccuracy);
    }

    protected float func_70185_h() {
        return this.gravityVelocity;
    }

    @Override
    protected float getVelocity() {
        return this.speed;
    }

    @Override
    protected float getInaccuracy() {
        return 1.0f;
    }

    @Override
    protected void onImpact(CompatibleRayTraceResult position) {
        if (!CompatibilityProvider.compatibility.world((Entity)this).field_72995_K) {
            if (position.getEntityHit() != null) {
                if (this.explosionRadius > 0.0f) {
                    CompatibilityProvider.compatibility.world((Entity)this).func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionRadius, true);
                }
                position.getEntityHit().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.damage);
                position.getEntityHit().field_70172_ad = 0;
                position.getEntityHit().field_70126_B = (float)((double)position.getEntityHit().field_70126_B - 0.3);
            } else if (this.explosionRadius > 0.0f) {
                CompatibilityProvider.compatibility.world((Entity)this).func_72876_a((Entity)this, (double)position.getBlockPosX(), (double)position.getBlockPosY(), (double)position.getBlockPosZ(), this.explosionRadius, true);
            } else if (position.getTypeOfHit() == CompatibleRayTraceResult.Type.BLOCK) {
                this.weapon.onSpawnEntityBlockImpact(CompatibilityProvider.compatibility.world((Entity)this), null, this, position);
            }
            this.func_70106_y();
        }
    }

    @Override
    public void setCompatibleThrowableHeading(double motionX, double motionY, double motionZ, float velocity, float inaccuracy) {
        float f2 = CompatibilityProvider.compatibility.getMathHelper().sqrt_double(motionX * motionX + motionY * motionY + motionZ * motionZ);
        motionX /= (double)f2;
        motionY /= (double)f2;
        motionZ /= (double)f2;
        motionX += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        motionY += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        motionZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = motionX *= (double)velocity;
        this.field_70181_x = motionY *= (double)velocity;
        this.field_70179_y = motionZ *= (double)velocity;
        float f3 = CompatibilityProvider.compatibility.getMathHelper().sqrt_double(motionX * motionX + motionZ * motionZ);
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motionY, f3) * 180.0 / Math.PI);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(Item.func_150891_b((Item)this.weapon));
        buffer.writeFloat(this.speed);
        buffer.writeFloat(this.gravityVelocity);
        buffer.writeFloat(this.inaccuracy);
        buffer.writeFloat(this.damage);
        buffer.writeFloat(this.explosionRadius);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.weapon = (Weapon)Item.func_150899_d((int)buffer.readInt());
        this.speed = buffer.readFloat();
        this.gravityVelocity = buffer.readFloat();
        this.inaccuracy = buffer.readFloat();
        this.damage = buffer.readFloat();
        this.explosionRadius = buffer.readFloat();
    }

    Weapon getWeapon() {
        return this.weapon;
    }

    boolean isDamageableEntity(Entity entity) {
        return false;
    }
}

