/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.KeyBindings;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.Modifiable;
import com.vicmatskiv.weaponlib.PlayerWeaponInstance;
import com.vicmatskiv.weaponlib.Reloadable;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponAttachmentAspect;
import com.vicmatskiv.weaponlib.WeaponState;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleChannel;
import com.vicmatskiv.weaponlib.compatibility.CompatibleMessageContext;
import com.vicmatskiv.weaponlib.compatibility.CompatibleWeaponKeyInputHandler;
import java.util.function.Function;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WeaponKeyInputHandler
extends CompatibleWeaponKeyInputHandler {
    private CompatibleChannel channel;
    private Function<CompatibleMessageContext, EntityPlayer> entityPlayerSupplier;
    private ModContext modContext;

    public WeaponKeyInputHandler(ModContext modContext, Function<CompatibleMessageContext, EntityPlayer> entityPlayerSupplier, WeaponAttachmentAspect attachmentAspect, CompatibleChannel channel) {
        this.modContext = modContext;
        this.entityPlayerSupplier = entityPlayerSupplier;
        this.channel = channel;
    }

    @Override
    public void onCompatibleKeyInput() {
        PlayerWeaponInstance instance;
        EntityPlayer player = this.entityPlayerSupplier.apply(null);
        ItemStack itemStack = CompatibilityProvider.compatibility.getHeldItemMainHand((EntityLivingBase)player);
        if (KeyBindings.reloadKey.func_151468_f()) {
            Item item;
            if (itemStack != null && (item = itemStack.func_77973_b()) instanceof Reloadable) {
                ((Reloadable)item).reloadMainHeldItemForPlayer(player);
            }
        } else if (KeyBindings.laserSwitchKey.func_151468_f()) {
            PlayerWeaponInstance instance2 = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance(player, PlayerWeaponInstance.class);
            if (instance2 != null && instance2.getState() == WeaponState.READY || instance2.getState() == WeaponState.MODIFYING) {
                instance2.setLaserOn(!instance2.isLaserOn());
            }
        } else if (KeyBindings.attachmentKey.func_151468_f()) {
            Item item;
            if (itemStack != null && itemStack.func_77973_b() instanceof Weapon && (item = itemStack.func_77973_b()) instanceof Modifiable) {
                ((Modifiable)item).toggleClientAttachmentSelectionMode(player);
            }
        } else if (KeyBindings.upArrowKey.func_151468_f()) {
            PlayerWeaponInstance instance3 = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance(player, PlayerWeaponInstance.class);
            if (instance3 != null && instance3.getState() == WeaponState.MODIFYING) {
                this.modContext.getAttachmentAspect().changeAttachment(AttachmentCategory.SCOPE, instance3);
            }
        } else if (KeyBindings.rightArrowKey.func_151468_f()) {
            PlayerWeaponInstance instance4 = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance(player, PlayerWeaponInstance.class);
            if (instance4 != null && instance4.getState() == WeaponState.MODIFYING) {
                this.modContext.getAttachmentAspect().changeAttachment(AttachmentCategory.SKIN, instance4);
            }
        } else if (KeyBindings.downArrowKey.func_151468_f()) {
            PlayerWeaponInstance instance5 = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance(player, PlayerWeaponInstance.class);
            if (instance5 != null && instance5.getState() == WeaponState.MODIFYING) {
                this.modContext.getAttachmentAspect().changeAttachment(AttachmentCategory.GRIP, instance5);
            }
        } else if (KeyBindings.leftArrowKey.func_151468_f()) {
            PlayerWeaponInstance instance6 = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance(player, PlayerWeaponInstance.class);
            if (instance6 != null && instance6.getState() == WeaponState.MODIFYING) {
                this.modContext.getAttachmentAspect().changeAttachment(AttachmentCategory.SILENCER, instance6);
            }
        } else if (KeyBindings.fireModeKey.func_151468_f()) {
            PlayerWeaponInstance instance7 = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance(player, PlayerWeaponInstance.class);
            if (instance7 != null && instance7.getState() == WeaponState.READY) {
                instance7.getWeapon().changeFireMode(instance7);
            }
        } else if (KeyBindings.addKey.func_151468_f()) {
            PlayerWeaponInstance instance8 = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance(player, PlayerWeaponInstance.class);
            if (instance8 != null && instance8.getState() == WeaponState.READY) {
                instance8.getWeapon().incrementZoom(instance8);
            }
        } else if (KeyBindings.subtractKey.func_151468_f() && (instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance(player, PlayerWeaponInstance.class)) != null && instance.getState() == WeaponState.READY) {
            instance.getWeapon().decrementZoom(instance);
        }
    }
}

