/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.CommonModContext;
import com.vicmatskiv.weaponlib.EffectManager;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.PlayerWeaponInstance;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.TryFireMessage;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponSpawnEntity;
import com.vicmatskiv.weaponlib.WeaponState;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.state.Aspect;
import com.vicmatskiv.weaponlib.state.PermitManager;
import com.vicmatskiv.weaponlib.state.StateManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WeaponFireAspect
implements Aspect<WeaponState, PlayerWeaponInstance> {
    private static final float FLASH_X_OFFSET_ZOOMED = 0.0f;
    private static final long ALERT_TIMEOUT = 500L;
    private static Predicate<PlayerWeaponInstance> readyToShootAccordingToFireRate = instance -> (float)(System.currentTimeMillis() - instance.getLastFireTimestamp()) >= 50.0f / instance.getWeapon().builder.fireRate;
    private static Predicate<PlayerWeaponInstance> readyToShootAccordingToFireMode = instance -> instance.getSeriesShotCount() < instance.getMaxShots();
    private static Predicate<PlayerWeaponInstance> hasAmmo = instance -> instance.getAmmo() > 0;
    private static Predicate<PlayerWeaponInstance> ejectSpentRoundRequired = instance -> instance.getWeapon().ejectSpentRoundRequired();
    private static Predicate<PlayerWeaponInstance> ejectSpentRoundTimeoutExpired = instance -> System.currentTimeMillis() >= instance.getWeapon().builder.pumpTimeoutMilliseconds + instance.getStateUpdateTimestamp();
    private static Predicate<PlayerWeaponInstance> alertTimeoutExpired = instance -> System.currentTimeMillis() >= 500L + instance.getStateUpdateTimestamp();
    private static Predicate<PlayerWeaponInstance> sprinting = instance -> instance.getPlayer().func_70051_ag();
    private static final Set<WeaponState> allowedFireOrEjectFromStates = new HashSet<WeaponState>(Arrays.asList(WeaponState.READY, WeaponState.PAUSED, WeaponState.EJECT_REQUIRED));
    private static final Set<WeaponState> allowedUpdateFromStates = new HashSet<WeaponState>(Arrays.asList(WeaponState.EJECTING, WeaponState.PAUSED, WeaponState.FIRING, WeaponState.RECOILED, WeaponState.PAUSED, WeaponState.ALERT));
    private ModContext modContext;
    private StateManager<WeaponState, ? super PlayerWeaponInstance> stateManager;

    public WeaponFireAspect(CommonModContext modContext) {
        this.modContext = modContext;
    }

    @Override
    public void setPermitManager(PermitManager permitManager) {
    }

    @Override
    public void setStateManager(StateManager<WeaponState, ? super PlayerWeaponInstance> stateManager) {
        this.stateManager = stateManager;
        stateManager.in(this).change(WeaponState.READY).to(WeaponState.ALERT).when(hasAmmo.negate()).withAction(this::cannotFire).manual().in(this).change(WeaponState.ALERT).to(WeaponState.READY).when(alertTimeoutExpired).automatic().in(this).change(WeaponState.READY).to(WeaponState.FIRING).when(hasAmmo.and(sprinting.negate()).and(readyToShootAccordingToFireRate)).withAction(this::fire).manual().in(this).change(WeaponState.FIRING).to(WeaponState.RECOILED).automatic().in(this).change(WeaponState.RECOILED).to(WeaponState.PAUSED).automatic().in(this).change(WeaponState.PAUSED).to(WeaponState.EJECT_REQUIRED).when(ejectSpentRoundRequired).manual().in(this).change(WeaponState.EJECT_REQUIRED).to(WeaponState.EJECTING).withAction(this::ejectSpentRound).manual().in(this).change(WeaponState.EJECTING).to(WeaponState.READY).when(ejectSpentRoundTimeoutExpired).automatic().in(this).change(WeaponState.PAUSED).to(WeaponState.FIRING).when(hasAmmo.and(sprinting.negate()).and(readyToShootAccordingToFireMode).and(readyToShootAccordingToFireRate)).withAction(this::fire).manual().in(this).change(WeaponState.PAUSED).to(WeaponState.READY).when(ejectSpentRoundRequired.negate()).withAction(PlayerWeaponInstance::resetCurrentSeries).manual();
    }

    void onFireButtonClick(EntityPlayer player) {
        PlayerWeaponInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance(player, PlayerWeaponInstance.class);
        if (weaponInstance != null) {
            this.stateManager.changeStateFromAnyOf(this, weaponInstance, allowedFireOrEjectFromStates, new WeaponState[]{WeaponState.FIRING, WeaponState.EJECTING, WeaponState.ALERT});
        }
    }

    void onFireButtonRelease(EntityPlayer player) {
        PlayerWeaponInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance(player, PlayerWeaponInstance.class);
        if (weaponInstance != null) {
            this.stateManager.changeState(this, weaponInstance, new WeaponState[]{WeaponState.EJECT_REQUIRED, WeaponState.READY});
        }
    }

    void onUpdate(EntityPlayer player) {
        PlayerWeaponInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance(player, PlayerWeaponInstance.class);
        if (weaponInstance != null) {
            this.stateManager.changeStateFromAnyOf(this, weaponInstance, allowedUpdateFromStates, new WeaponState[0]);
        }
    }

    private void cannotFire(PlayerWeaponInstance weaponInstance) {
        if (weaponInstance.getAmmo() == 0) {
            String message = weaponInstance.getWeapon().getAmmoCapacity() == 0 && this.modContext.getAttachmentAspect().getActiveAttachment(weaponInstance, AttachmentCategory.MAGAZINE) == null ? "No magazine" : "No ammo";
            this.modContext.getStatusMessageCenter().addAlertMessage(message, 3, 250L, 200L);
            CompatibilityProvider.compatibility.playSound(weaponInstance.getPlayer(), this.modContext.getNoAmmoSound(), 1.0f, 1.0f);
        }
    }

    private void fire(PlayerWeaponInstance weaponInstance) {
        EntityPlayer player = weaponInstance.getPlayer();
        Weapon weapon = (Weapon)weaponInstance.getItem();
        Random random = player.func_70681_au();
        this.modContext.getChannel().getChannel().sendToServer((IMessage)new TryFireMessage(true));
        CompatibilityProvider.compatibility.playSound(player, this.modContext.getAttachmentAspect().isSilencerOn(weaponInstance) ? weapon.getSilencedShootSound() : weapon.getShootSound(), 1.0f, 1.0f);
        player.field_70125_A -= weaponInstance.getRecoil();
        float rotationYawFactor = -1.0f + random.nextFloat() * 2.0f;
        player.field_70177_z += weaponInstance.getRecoil() * rotationYawFactor;
        if (weapon.builder.flashIntensity > 0.0f) {
            EffectManager.getInstance().spawnFlashParticle(player, weapon.builder.flashIntensity, weapon.builder.flashScale.get().floatValue(), weaponInstance.isAimed() ? 0.0f : CompatibilityProvider.compatibility.getEffectOffsetX() + weapon.builder.flashOffsetX.get().floatValue(), CompatibilityProvider.compatibility.getEffectOffsetY() + weapon.builder.flashOffsetY.get().floatValue());
        }
        EffectManager.getInstance().spawnSmokeParticle(player, CompatibilityProvider.compatibility.getEffectOffsetX() + weapon.builder.smokeOffsetX.get().floatValue(), CompatibilityProvider.compatibility.getEffectOffsetY() + weapon.builder.smokeOffsetY.get().floatValue());
        weaponInstance.setSeriesShotCount(weaponInstance.getSeriesShotCount() + 1);
        weaponInstance.setLastFireTimestamp(System.currentTimeMillis());
        weaponInstance.setAmmo(weaponInstance.getAmmo() - 1);
    }

    private void ejectSpentRound(PlayerWeaponInstance weaponInstance) {
        EntityPlayer player = weaponInstance.getPlayer();
        CompatibilityProvider.compatibility.playSound(player, weaponInstance.getWeapon().getEjectSpentRoundSound(), 1.0f, 1.0f);
    }

    void serverFire(EntityPlayer player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof Weapon)) {
            return;
        }
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        for (int i = 0; i < weapon.builder.pellets; ++i) {
            WeaponSpawnEntity spawnEntity = weapon.builder.spawnEntityWith.apply(weapon, player);
            CompatibilityProvider.compatibility.spawnEntity(player, (Entity)spawnEntity);
        }
        PlayerWeaponInstance playerWeaponInstance = Tags.getInstance(itemStack, PlayerWeaponInstance.class);
        CompatibilityProvider.compatibility.playSoundToNearExcept(player, playerWeaponInstance != null && this.modContext.getAttachmentAspect().isSilencerOn(playerWeaponInstance) ? weapon.getSilencedShootSound() : weapon.getShootSound(), 1.0f, 1.0f);
    }
}

