/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.PlayerItemInstance;
import com.vicmatskiv.weaponlib.PlayerWeaponInstance;
import com.vicmatskiv.weaponlib.RenderingPhase;
import com.vicmatskiv.weaponlib.SafeGlobals;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponState;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleWeaponEventHandler;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderLivingEvent;

public class WeaponEventHandler
extends CompatibleWeaponEventHandler {
    private SafeGlobals safeGlobals;
    private ModContext modContext;

    public WeaponEventHandler(ModContext modContext, SafeGlobals safeGlobals) {
        this.modContext = modContext;
        this.safeGlobals = safeGlobals;
    }

    @Override
    public void onCompatibleGuiOpenEvent(GuiOpenEvent event) {
        this.safeGlobals.guiOpen.set(CompatibilityProvider.compatibility.getGui(event) != null);
    }

    @Override
    public void compatibleZoom(FOVUpdateEvent event) {
        PlayerWeaponInstance instance = this.modContext.getMainHeldWeapon();
        if (instance != null) {
            float fov = instance.isAttachmentZoomEnabled() ? (this.safeGlobals.renderingPhase.get() == RenderingPhase.RENDER_VIEWFINDER ? instance.getZoom() : 1.0f) : (instance.isAimed() ? instance.getZoom() : 1.0f);
            CompatibilityProvider.compatibility.setNewFov(event, fov);
        }
    }

    @Override
    public void onCompatibleMouse(MouseEvent event) {
        PlayerWeaponInstance mainHandHeldWeaponInstance;
        if ((CompatibilityProvider.compatibility.getButton(event) == 0 || CompatibilityProvider.compatibility.getButton(event) == 1) && (mainHandHeldWeaponInstance = this.modContext.getMainHeldWeapon()) != null) {
            event.setCanceled(true);
        }
    }

    @Override
    public void onCompatibleHandleRenderLivingEvent(RenderLivingEvent.Pre event) {
        if (event.isCanceled() || !(CompatibilityProvider.compatibility.getEntity(event) instanceof EntityPlayer)) {
            return;
        }
        ItemStack itemStack = CompatibilityProvider.compatibility.getHeldItemMainHand(CompatibilityProvider.compatibility.getEntity(event));
        if (itemStack != null && itemStack.func_77973_b() instanceof Weapon) {
            PlayerItemInstance<?> instance;
            RenderPlayer rp = CompatibilityProvider.compatibility.getRenderer(event);
            if (itemStack != null && (instance = this.modContext.getPlayerItemInstanceRegistry().getItemInstance((EntityPlayer)CompatibilityProvider.compatibility.getEntity(event), itemStack)) instanceof PlayerWeaponInstance) {
                PlayerWeaponInstance weaponInstance = (PlayerWeaponInstance)instance;
                CompatibilityProvider.compatibility.setAimed(rp, weaponInstance.isAimed() || weaponInstance.getState() == WeaponState.FIRING || weaponInstance.getState() == WeaponState.RECOILED || weaponInstance.getState() == WeaponState.PAUSED);
            }
        }
    }
}

