/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.CustomRenderer;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.PlayerWeaponInstance;
import com.vicmatskiv.weaponlib.RenderContext;
import com.vicmatskiv.weaponlib.RenderableState;
import com.vicmatskiv.weaponlib.ViewfinderModel;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleTransformType;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ViewfinderRenderer
implements CustomRenderer {
    private ViewfinderModel model = new ViewfinderModel();
    private BiConsumer<EntityPlayer, ItemStack> positioning;
    private ModContext modContext;

    public ViewfinderRenderer(ModContext modContext, BiConsumer<EntityPlayer, ItemStack> positioning) {
        this.modContext = modContext;
        this.positioning = positioning;
    }

    @Override
    public void render(RenderContext renderContext) {
        if (renderContext.getCompatibleTransformType() != CompatibleTransformType.FIRST_PERSON_RIGHT_HAND && renderContext.getCompatibleTransformType() != CompatibleTransformType.FIRST_PERSON_LEFT_HAND) {
            return;
        }
        float brightness = 0.0f;
        PlayerWeaponInstance instance = this.modContext.getMainHeldWeapon();
        boolean aimed = instance != null && instance.isAimed();
        float progress = Math.min(1.0f, renderContext.getTransitionProgress());
        if (ViewfinderRenderer.isAimingState(renderContext.getFromState()) && ViewfinderRenderer.isAimingState(renderContext.getToState())) {
            brightness = 1.0f;
        } else if (progress > 0.0f && aimed) {
            brightness = progress;
        } else if (ViewfinderRenderer.isAimingState(renderContext.getFromState()) && progress > 0.0f && !aimed) {
            brightness = Math.max(1.0f - progress, 0.0f);
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8193);
        this.positioning.accept(renderContext.getPlayer(), renderContext.getWeapon());
        GL11.glBindTexture((int)3553, (int)renderContext.getClientModContext().getFramebuffer().field_147617_g);
        CompatibilityProvider.compatibility.disableLightMap();
        GL11.glEnable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        this.model.func_78088_a((Entity)renderContext.getPlayer(), renderContext.getLimbSwing(), renderContext.getFlimbSwingAmount(), renderContext.getAgeInTicks(), renderContext.getNetHeadYaw(), renderContext.getHeadPitch(), renderContext.getScale());
        CompatibilityProvider.compatibility.enableLightMap();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private static boolean isAimingState(RenderableState renderableState) {
        return renderableState == RenderableState.ZOOMING || renderableState == RenderableState.ZOOMING_RECOILED || renderableState == RenderableState.ZOOMING_SHOOTING;
    }
}

