/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.CustomRenderer;
import com.vicmatskiv.weaponlib.PlayerItemInstance;
import com.vicmatskiv.weaponlib.PlayerWeaponInstance;
import com.vicmatskiv.weaponlib.RenderContext;
import com.vicmatskiv.weaponlib.compatibility.CompatibleTessellator;
import com.vicmatskiv.weaponlib.compatibility.CompatibleTransformType;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class LaserBeamRenderer
implements CustomRenderer {
    private float xOffset = 0.5f;
    private float yOffset = -1.3f;
    private float zOffset = -1.7f;
    private BiConsumer<EntityPlayer, ItemStack> positioning;

    public LaserBeamRenderer(BiConsumer<EntityPlayer, ItemStack> positioning) {
        this.positioning = positioning;
    }

    @Override
    public void render(RenderContext renderContext) {
        PlayerItemInstance<?> instance = renderContext.getPlayerItemInstance();
        CompatibleTransformType type = renderContext.getCompatibleTransformType();
        if (instance instanceof PlayerWeaponInstance && ((PlayerWeaponInstance)instance).isLaserOn() && (type == CompatibleTransformType.THIRD_PERSON_LEFT_HAND || type == CompatibleTransformType.THIRD_PERSON_RIGHT_HAND || type == CompatibleTransformType.FIRST_PERSON_LEFT_HAND || type == CompatibleTransformType.FIRST_PERSON_RIGHT_HAND || type == CompatibleTransformType.GROUND)) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            GL11.glLineWidth((float)1.5f);
            GL11.glDepthMask((boolean)false);
            if (this.positioning != null) {
                this.positioning.accept(renderContext.getPlayer(), renderContext.getWeapon());
            }
            CompatibleTessellator tessellator = CompatibleTessellator.getInstance();
            tessellator.startDrawingLines();
            long time = System.currentTimeMillis();
            Random random = new Random(time - time % 300L);
            float start = this.zOffset;
            float length = 100.0f;
            float end = 0.0f;
            for (int i = 0; i < 100 && start < length && end < length; ++i) {
                tessellator.addVertex(this.xOffset, this.yOffset, start);
                tessellator.endVertex();
                int ii = 0xF000F0;
                int j = ii >> 16 & 0xFFFF;
                int k = ii & 0xFFFF;
                tessellator.setLightMap(j, k);
                end = start - (1.0f + random.nextFloat() * 2.0f);
                if (end > length) {
                    end = length;
                }
                tessellator.addVertex(this.xOffset, this.yOffset, end);
                tessellator.endVertex();
                start = end + random.nextFloat() * 0.5f;
            }
            tessellator.draw();
            GL11.glDepthMask((boolean)true);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }
}

