/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentBuilder;
import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.ItemAttachment;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.model.FlatModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import org.lwjgl.opengl.GL11;

public class ItemSkin
extends ItemAttachment<Weapon> {
    private List<String> textureVariants;

    public ItemSkin(String modId, AttachmentCategory category, ModelBase model, String textureName, String crosshair, ItemAttachment.ApplyHandler<Weapon> apply, ItemAttachment.ApplyHandler<Weapon> remove) {
        super(modId, category, model, textureName, crosshair, apply, remove);
    }

    public String getTextureName() {
        return this.textureName;
    }

    public int getTextureVariantIndex(String name) {
        return this.textureVariants.indexOf(name);
    }

    public String getTextureVariant(int textureIndex) {
        return textureIndex >= 0 && textureIndex < this.textureVariants.size() ? this.textureVariants.get(textureIndex) : null;
    }

    public static final class Builder
    extends AttachmentBuilder<Weapon> {
        private List<String> textureVariants = new ArrayList<String>();

        public Builder withTextureVariant(String ... textureVariantNames) {
            for (String s : textureVariantNames) {
                this.textureVariants.add(Builder.stripFileExtension(s, ".png"));
            }
            return this;
        }

        @Override
        protected ItemAttachment<Weapon> createAttachment(ModContext modContext) {
            ItemSkin skin = new ItemSkin(this.modId, AttachmentCategory.SKIN, this.model, this.textureName, null, null, null);
            skin.textureVariants = this.textureVariants;
            return skin;
        }

        @Override
        public <V extends ItemAttachment<Weapon>> V build(ModContext modContext, Class<V> target) {
            this.model = new FlatModel();
            if (this.textureVariants.isEmpty()) {
                this.textureVariants.add(this.textureName);
            } else if (this.textureName == null) {
                this.textureName = this.textureVariants.get(0);
            }
            if (this.inventoryPositioning == null) {
                this.withInventoryPositioning(itemStack -> {
                    GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-0.6f, (float)-0.6f, (float)0.0f);
                    GL11.glScaled((double)15.0, (double)15.0, (double)15.0);
                });
            }
            return super.build(modContext, target);
        }
    }
}

