/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.CustomArmor;
import com.vicmatskiv.weaponlib.ItemMagazine;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.PlayerWeaponInstance;
import com.vicmatskiv.weaponlib.StatusMessageCenter;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponAttachmentAspect;
import com.vicmatskiv.weaponlib.WeaponState;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleGui;
import com.vicmatskiv.weaponlib.compatibility.CompatibleTessellator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class CustomGui
extends CompatibleGui {
    private Minecraft mc;
    private WeaponAttachmentAspect attachmentAspect;
    private ModContext modContext;
    private static final int BUFF_ICON_SIZE = 256;

    public CustomGui(Minecraft mc, ModContext modContext, WeaponAttachmentAspect attachmentAspect) {
        this.mc = mc;
        this.modContext = modContext;
        this.attachmentAspect = attachmentAspect;
    }

    @Override
    public void onCompatibleRenderHud(RenderGameOverlayEvent.Pre event) {
        String hudTexture;
        ItemStack helmet;
        if (CompatibilityProvider.compatibility.getEventType(event) == RenderGameOverlayEvent.ElementType.HELMET && (helmet = CompatibilityProvider.compatibility.getHelmet()) != null && this.mc.field_71474_y.field_74320_O == 0 && helmet.func_77973_b() instanceof CustomArmor && (hudTexture = ((CustomArmor)helmet.func_77973_b()).getHudTexture()) != null) {
            ScaledResolution scaledResolution = CompatibilityProvider.compatibility.getResolution(event);
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            GL11.glPushAttrib((int)8192);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            this.mc.field_71446_o.func_110577_a(new ResourceLocation(hudTexture));
            CustomGui.drawTexturedQuadFit(0.0, 0.0, width, height, 0.0);
            GL11.glPopAttrib();
            event.setCanceled(true);
        }
    }

    @Override
    public void onCompatibleRenderCrosshair(RenderGameOverlayEvent.Pre event) {
        if (CompatibilityProvider.compatibility.getEventType(event) != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        ItemStack itemStack = CompatibilityProvider.compatibility.getHeldItemMainHand((EntityLivingBase)CompatibilityProvider.compatibility.clientPlayer());
        if (itemStack == null) {
            return;
        }
        PlayerWeaponInstance weaponInstance = this.modContext.getMainHeldWeapon();
        if (weaponInstance != null) {
            String crosshair;
            Weapon weaponItem = (Weapon)itemStack.func_77973_b();
            String string = crosshair = weaponItem != null ? weaponItem.getCrosshair(weaponInstance) : null;
            if (crosshair != null) {
                ScaledResolution scaledResolution = CompatibilityProvider.compatibility.getResolution(event);
                int width = scaledResolution.func_78326_a();
                int height = scaledResolution.func_78328_b();
                int xPos = width / 2 - 128;
                int yPos = height / 2 - 128;
                FontRenderer fontRender = CompatibilityProvider.compatibility.getFontRenderer();
                this.mc.field_71460_t.func_78478_c();
                int color = 0xFFFFFF;
                this.mc.field_71446_o.func_110577_a(new ResourceLocation(crosshair));
                GL11.glPushAttrib((int)8192);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)3042);
                if (this.isInModifyingState(weaponInstance)) {
                    fontRender.func_175063_a("Press [up] to add optic", (float)(width / 2 - 40), 60.0f, color);
                    fontRender.func_175063_a("Press [left] to add barrel rig", 10.0f, (float)(height / 2 - 10), color);
                    fontRender.func_175063_a("Press [right] to change camo", (float)(width / 2 + 60), (float)(height / 2 - 20), color);
                    fontRender.func_175063_a("Press [down] to add under-barrel rig", 10.0f, (float)(height - 40), color);
                } else {
                    String messageText;
                    StatusMessageCenter.Message message = this.modContext.getStatusMessageCenter().nextMessage();
                    if (message != null) {
                        messageText = message.getMessage();
                        if (message.isAlert()) {
                            color = 0xFFFF00;
                        }
                    } else {
                        messageText = this.getDefaultWeaponMessage(weaponInstance);
                    }
                    int x = width - 80;
                    int y = 10;
                    int stringWidth = fontRender.func_78256_a(messageText);
                    if (stringWidth > 80) {
                        x = width - stringWidth - 5;
                    }
                    fontRender.func_175063_a(messageText, (float)x, (float)y, color);
                }
                GL11.glPopAttrib();
                event.setCanceled(true);
            }
        } else if (itemStack.func_77973_b() instanceof ItemMagazine) {
            String messageText;
            ScaledResolution scaledResolution = CompatibilityProvider.compatibility.getResolution(event);
            int width = scaledResolution.func_78326_a();
            FontRenderer fontRender = CompatibilityProvider.compatibility.getFontRenderer();
            this.mc.field_71460_t.func_78478_c();
            int color = 0xFFFFFF;
            StatusMessageCenter.Message message = this.modContext.getStatusMessageCenter().nextMessage();
            if (message != null) {
                messageText = message.getMessage();
                if (message.isAlert()) {
                    color = 0xFF0000;
                }
            } else {
                messageText = this.getDefaultMagazineMessage(itemStack);
            }
            int x = width - 80;
            int y = 10;
            int stringWidth = fontRender.func_78256_a(messageText);
            if (stringWidth > 80) {
                x = width - stringWidth - 5;
            }
            fontRender.func_175063_a(messageText, (float)x, (float)y, color);
            event.setCanceled(true);
        }
    }

    private String getDefaultMagazineMessage(ItemStack itemStack) {
        ItemMagazine magazine = (ItemMagazine)itemStack.func_77973_b();
        String text = "Ammo: " + Tags.getAmmo(itemStack) + "/" + magazine.getAmmo();
        return text;
    }

    private String getDefaultWeaponMessage(PlayerWeaponInstance weaponInstance) {
        ItemMagazine magazine = (ItemMagazine)WeaponAttachmentAspect.getActiveAttachment(AttachmentCategory.MAGAZINE, weaponInstance);
        int totalCapacity = magazine != null ? magazine.getAmmo() : weaponInstance.getWeapon().getAmmoCapacity();
        String text = weaponInstance.getWeapon().getAmmoCapacity() == 0 && totalCapacity == 0 ? "No magazine" : "Ammo: " + weaponInstance.getWeapon().getCurrentAmmo(CompatibilityProvider.compatibility.clientPlayer()) + "/" + totalCapacity;
        return text;
    }

    private boolean isInModifyingState(PlayerWeaponInstance weaponInstance) {
        return weaponInstance.getState() == WeaponState.MODIFYING || weaponInstance.getState() == WeaponState.MODIFYING_REQUESTED || weaponInstance.getState() == WeaponState.NEXT_ATTACHMENT || weaponInstance.getState() == WeaponState.NEXT_ATTACHMENT_REQUESTED;
    }

    private static void drawTexturedQuadFit(double x, double y, double width, double height, double zLevel) {
        CompatibleTessellator tessellator = CompatibleTessellator.getInstance();
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0.0, y + height, zLevel, 0.0, 1.0);
        tessellator.addVertexWithUV(x + width, y + height, zLevel, 1.0, 1.0);
        tessellator.addVertexWithUV(x + width, y + 0.0, zLevel, 1.0, 0.0);
        tessellator.addVertexWithUV(x + 0.0, y + 0.0, zLevel, 0.0, 0.0);
        tessellator.draw();
    }
}

