/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.MagazineReloadAspect;
import com.vicmatskiv.weaponlib.MagazineState;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.PlayerItemInstance;
import com.vicmatskiv.weaponlib.PlayerItemInstanceRegistry;
import com.vicmatskiv.weaponlib.PlayerMagazineInstance;
import com.vicmatskiv.weaponlib.PlayerWeaponInstance;
import com.vicmatskiv.weaponlib.ServerEventHandler;
import com.vicmatskiv.weaponlib.StatusMessageCenter;
import com.vicmatskiv.weaponlib.SyncManager;
import com.vicmatskiv.weaponlib.TryFireMessage;
import com.vicmatskiv.weaponlib.TryFireMessageHandler;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponAttachmentAspect;
import com.vicmatskiv.weaponlib.WeaponFireAspect;
import com.vicmatskiv.weaponlib.WeaponKeyInputHandler;
import com.vicmatskiv.weaponlib.WeaponReloadAspect;
import com.vicmatskiv.weaponlib.WeaponRenderer;
import com.vicmatskiv.weaponlib.WeaponState;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleChannel;
import com.vicmatskiv.weaponlib.compatibility.CompatibleMessageContext;
import com.vicmatskiv.weaponlib.compatibility.CompatibleSide;
import com.vicmatskiv.weaponlib.compatibility.CompatibleSound;
import com.vicmatskiv.weaponlib.crafting.RecipeGenerator;
import com.vicmatskiv.weaponlib.network.NetworkPermitManager;
import com.vicmatskiv.weaponlib.network.PermitMessage;
import com.vicmatskiv.weaponlib.network.TypeRegistry;
import com.vicmatskiv.weaponlib.state.Permit;
import com.vicmatskiv.weaponlib.state.StateManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class CommonModContext
implements ModContext {
    private String modId;
    protected CompatibleChannel channel;
    protected WeaponReloadAspect weaponReloadAspect;
    protected WeaponAttachmentAspect weaponAttachmentAspect;
    protected WeaponFireAspect weaponFireAspect;
    protected SyncManager<?> syncManager;
    protected MagazineReloadAspect magazineReloadAspect;
    protected NetworkPermitManager permitManager;
    protected PlayerItemInstanceRegistry playerItemInstanceRegistry;
    private Map<ResourceLocation, CompatibleSound> registeredSounds = new HashMap<ResourceLocation, CompatibleSound>();
    private RecipeGenerator recipeGenerator;
    private CompatibleSound changeZoomSound;
    private CompatibleSound changeFireModeSound;
    private CompatibleSound noAmmoSound;

    @Override
    public void init(Object mod, String modId, CompatibleChannel channel) {
        this.channel = channel;
        this.modId = modId;
        this.weaponReloadAspect = new WeaponReloadAspect(this);
        this.magazineReloadAspect = new MagazineReloadAspect(this);
        this.weaponFireAspect = new WeaponFireAspect(this);
        this.weaponAttachmentAspect = new WeaponAttachmentAspect(this);
        this.permitManager = new NetworkPermitManager(this);
        this.syncManager = new SyncManager(this.permitManager);
        this.playerItemInstanceRegistry = new PlayerItemInstanceRegistry(this.syncManager);
        StateManager weaponStateManager = new StateManager((s1, s2) -> s1 == s2);
        this.weaponReloadAspect.setPermitManager(this.permitManager);
        this.weaponReloadAspect.setStateManager(weaponStateManager);
        this.weaponFireAspect.setPermitManager(this.permitManager);
        this.weaponFireAspect.setStateManager(weaponStateManager);
        this.weaponAttachmentAspect.setPermitManager(this.permitManager);
        this.weaponAttachmentAspect.setStateManager(weaponStateManager);
        StateManager magazineStateManager = new StateManager((s1, s2) -> s1 == s2);
        this.magazineReloadAspect.setPermitManager(this.permitManager);
        this.magazineReloadAspect.setStateManager(magazineStateManager);
        this.recipeGenerator = new RecipeGenerator();
        channel.registerMessage(new TryFireMessageHandler(this.weaponFireAspect), TryFireMessage.class, 11, CompatibleSide.SERVER);
        channel.registerMessage(this.permitManager, PermitMessage.class, 14, CompatibleSide.SERVER);
        channel.registerMessage(this.permitManager, PermitMessage.class, 15, CompatibleSide.CLIENT);
        CompatibilityProvider.compatibility.registerWithEventBus(new ServerEventHandler(this));
        CompatibilityProvider.compatibility.registerWithFmlEventBus(new WeaponKeyInputHandler(this, ctx -> this.getPlayer((CompatibleMessageContext)ctx), this.weaponAttachmentAspect, channel));
    }

    @Override
    public CompatibleSound registerSound(String sound) {
        ResourceLocation soundResourceLocation = new ResourceLocation(this.modId, sound);
        return this.registerSound(soundResourceLocation);
    }

    protected CompatibleSound registerSound(ResourceLocation soundResourceLocation) {
        CompatibleSound result = this.registeredSounds.get(soundResourceLocation);
        if (result == null) {
            result = new CompatibleSound(soundResourceLocation);
            this.registeredSounds.put(soundResourceLocation, result);
            CompatibilityProvider.compatibility.registerSound(result);
        }
        return result;
    }

    @Override
    public void registerWeapon(String name, Weapon weapon, WeaponRenderer renderer) {
        CompatibilityProvider.compatibility.registerItem(weapon, name);
    }

    private EntityPlayer getServerPlayer(CompatibleMessageContext ctx) {
        return ctx != null ? ctx.getPlayer() : null;
    }

    protected EntityPlayer getPlayer(CompatibleMessageContext ctx) {
        return this.getServerPlayer(ctx);
    }

    @Override
    public CompatibleChannel getChannel() {
        return this.channel;
    }

    @Override
    public void runSyncTick(Runnable runnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void runInMainThread(Runnable runnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerRenderableItem(String name, Item item, Object renderer) {
        CompatibilityProvider.compatibility.registerItem(item, name);
    }

    @Override
    public PlayerItemInstanceRegistry getPlayerItemInstanceRegistry() {
        return this.playerItemInstanceRegistry;
    }

    @Override
    public WeaponReloadAspect getWeaponReloadAspect() {
        return this.weaponReloadAspect;
    }

    @Override
    public WeaponFireAspect getWeaponFireAspect() {
        return this.weaponFireAspect;
    }

    @Override
    public WeaponAttachmentAspect getAttachmentAspect() {
        return this.weaponAttachmentAspect;
    }

    @Override
    public MagazineReloadAspect getMagazineReloadAspect() {
        return this.magazineReloadAspect;
    }

    @Override
    public PlayerWeaponInstance getMainHeldWeapon() {
        throw new IllegalStateException();
    }

    @Override
    public StatusMessageCenter getStatusMessageCenter() {
        throw new IllegalStateException();
    }

    @Override
    public RecipeGenerator getRecipeGenerator() {
        return this.recipeGenerator;
    }

    @Override
    public void setChangeZoomSound(String sound) {
        this.changeZoomSound = this.registerSound(sound);
    }

    @Override
    public CompatibleSound getZoomSound() {
        return this.changeZoomSound;
    }

    @Override
    public CompatibleSound getChangeFireModeSound() {
        return this.changeFireModeSound;
    }

    @Override
    public void setChangeFireModeSound(String sound) {
        this.changeFireModeSound = this.registerSound(sound);
    }

    @Override
    public void setNoAmmoSound(String sound) {
        this.noAmmoSound = this.registerSound(sound);
    }

    @Override
    public CompatibleSound getNoAmmoSound() {
        return this.noAmmoSound;
    }

    static {
        TypeRegistry.getInstance().register(MagazineReloadAspect.LoadPermit.class);
        TypeRegistry.getInstance().register(MagazineState.class);
        TypeRegistry.getInstance().register(PlayerItemInstance.class);
        TypeRegistry.getInstance().register(PlayerWeaponInstance.class);
        TypeRegistry.getInstance().register(PlayerMagazineInstance.class);
        TypeRegistry.getInstance().register(PlayerWeaponInstance.class);
        TypeRegistry.getInstance().register(Permit.class);
        TypeRegistry.getInstance().register(WeaponAttachmentAspect.EnterAttachmentModePermit.class);
        TypeRegistry.getInstance().register(WeaponAttachmentAspect.ExitAttachmentModePermit.class);
        TypeRegistry.getInstance().register(WeaponAttachmentAspect.ChangeAttachmentPermit.class);
        TypeRegistry.getInstance().register(WeaponReloadAspect.UnloadPermit.class);
        TypeRegistry.getInstance().register(MagazineReloadAspect.LoadPermit.class);
        TypeRegistry.getInstance().register(PlayerWeaponInstance.class);
        TypeRegistry.getInstance().register(WeaponState.class);
    }
}

