/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ClientModContext;
import com.vicmatskiv.weaponlib.SafeGlobals;
import com.vicmatskiv.weaponlib.Updatable;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

class ClientWeaponTicker
extends Thread {
    boolean[] buttonsPressed = new boolean[2];
    long[] buttonsPressedTimestamps = new long[2];
    private AtomicBoolean running = new AtomicBoolean(true);
    private ClientModContext clientModContext;

    public ClientWeaponTicker(ClientModContext clientModContext) {
        this.clientModContext = clientModContext;
    }

    void shutdown() {
        this.running.set(false);
    }

    @Override
    public void run() {
        SafeGlobals safeGlobals = this.clientModContext.getSafeGlobals();
        int currentItemIndex = safeGlobals.currentItemIndex.get();
        while (this.running.get()) {
            try {
                Weapon currentWeapon = this.getCurrentWeapon();
                EntityPlayer player = CompatibilityProvider.compatibility.getClientPlayer();
                if (!Mouse.isCreated()) continue;
                if (Mouse.isButtonDown((int)1)) {
                    if (!this.buttonsPressed[1]) {
                        this.buttonsPressed[1] = true;
                        this.buttonsPressedTimestamps[1] = System.currentTimeMillis();
                        if (currentWeapon != null && !safeGlobals.guiOpen.get() && !this.isInteracting()) {
                            this.clientModContext.runSyncTick(() -> currentWeapon.toggleAiming());
                        }
                    }
                } else if (this.buttonsPressed[1]) {
                    this.buttonsPressed[1] = false;
                }
                if (Mouse.isButtonDown((int)0)) {
                    currentItemIndex = safeGlobals.currentItemIndex.get();
                    if (!this.buttonsPressed[0]) {
                        this.buttonsPressed[0] = true;
                    }
                    if (currentWeapon != null && !safeGlobals.guiOpen.get() && !this.isInteracting()) {
                        this.clientModContext.runSyncTick(() -> currentWeapon.tryFire(player));
                    }
                } else if (this.buttonsPressed[0] || currentItemIndex != safeGlobals.currentItemIndex.get()) {
                    this.buttonsPressed[0] = false;
                    currentItemIndex = safeGlobals.currentItemIndex.get();
                    if (currentWeapon != null) {
                        this.clientModContext.runSyncTick(() -> currentWeapon.tryStopFire(player));
                    }
                }
                this.update(player);
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private void update(EntityPlayer player) {
        this.clientModContext.runSyncTick(() -> {
            Item item = this.getHeldItemMainHand();
            if (item instanceof Updatable) {
                ((Updatable)item).update(player);
            }
        });
    }

    private boolean isInteracting() {
        return false;
    }

    private Weapon getCurrentWeapon() {
        Item item = this.getHeldItemMainHand();
        return item instanceof Weapon ? (Weapon)item : null;
    }

    private Item getHeldItemMainHand() {
        EntityPlayer player = CompatibilityProvider.compatibility.getClientPlayer();
        if (player == null) {
            return null;
        }
        ItemStack itemStack = CompatibilityProvider.compatibility.getHeldItemMainHand((EntityLivingBase)player);
        return itemStack != null ? itemStack.func_77973_b() : null;
    }
}

