/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ClientEventHandler;
import com.vicmatskiv.weaponlib.ClientWeaponTicker;
import com.vicmatskiv.weaponlib.CommonModContext;
import com.vicmatskiv.weaponlib.CustomGui;
import com.vicmatskiv.weaponlib.KeyBindings;
import com.vicmatskiv.weaponlib.PlayerItemInstanceRegistry;
import com.vicmatskiv.weaponlib.PlayerWeaponInstance;
import com.vicmatskiv.weaponlib.SafeGlobals;
import com.vicmatskiv.weaponlib.SpawnEntityRenderer;
import com.vicmatskiv.weaponlib.StatusMessageCenter;
import com.vicmatskiv.weaponlib.SyncManager;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponEventHandler;
import com.vicmatskiv.weaponlib.WeaponRenderer;
import com.vicmatskiv.weaponlib.WeaponResourcePack;
import com.vicmatskiv.weaponlib.WeaponSpawnEntity;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleChannel;
import com.vicmatskiv.weaponlib.compatibility.CompatibleMessageContext;
import com.vicmatskiv.weaponlib.compatibility.CompatibleRenderingRegistry;
import com.vicmatskiv.weaponlib.compatibility.CompatibleWorldRenderer;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;

public class ClientModContext
extends CommonModContext {
    private ClientEventHandler clientEventHandler;
    private Lock mainLoopLock = new ReentrantLock();
    private int modEntityID;
    private Queue<Runnable> runInClientThreadQueue = new LinkedBlockingQueue<Runnable>();
    private CompatibleRenderingRegistry rendererRegistry;
    private Framebuffer framebuffer;
    private CompatibleWorldRenderer entityRenderer;
    private SafeGlobals safeGlobals = new SafeGlobals();
    private StatusMessageCenter statusMessageCenter;

    @Override
    public void init(Object mod, String modId, CompatibleChannel channel) {
        super.init(mod, modId, channel);
        this.statusMessageCenter = new StatusMessageCenter();
        this.rendererRegistry = new CompatibleRenderingRegistry(modId);
        List defaultResourcePacks = (List)CompatibilityProvider.compatibility.getPrivateValue(Minecraft.class, Minecraft.func_71410_x(), "defaultResourcePacks", "field_110449_ao");
        defaultResourcePacks.add(new WeaponResourcePack());
        CompatibilityProvider.compatibility.registerWithEventBus((Object)new CustomGui(Minecraft.func_71410_x(), this, this.weaponAttachmentAspect));
        CompatibilityProvider.compatibility.registerWithEventBus(new WeaponEventHandler(this, this.safeGlobals));
        KeyBindings.init();
        ClientWeaponTicker clientWeaponTicker = new ClientWeaponTicker(this);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> clientWeaponTicker.shutdown()));
        clientWeaponTicker.start();
        this.clientEventHandler = new ClientEventHandler(this, this.mainLoopLock, this.safeGlobals, this.runInClientThreadQueue);
        CompatibilityProvider.compatibility.registerWithFmlEventBus(this.clientEventHandler);
        CompatibilityProvider.compatibility.registerRenderingRegistry(this.rendererRegistry);
        CompatibilityProvider.compatibility.registerModEntity(WeaponSpawnEntity.class, "Ammo" + this.modEntityID, this.modEntityID++, mod, 64, 10, true);
        this.rendererRegistry.registerEntityRenderingHandler(WeaponSpawnEntity.class, new SpawnEntityRenderer());
    }

    protected CompatibleWorldRenderer getSecondWorldRenderer() {
        if (this.entityRenderer == null) {
            this.entityRenderer = new CompatibleWorldRenderer(Minecraft.func_71410_x(), Minecraft.func_71410_x().func_110442_L());
        }
        return this.entityRenderer;
    }

    public SafeGlobals getSafeGlobals() {
        return this.safeGlobals;
    }

    public Framebuffer getFramebuffer() {
        if (this.framebuffer == null) {
            this.framebuffer = new Framebuffer(200, 200, true);
            this.framebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.framebuffer;
    }

    @Override
    public void registerWeapon(String name, Weapon weapon, WeaponRenderer renderer) {
        super.registerWeapon(name, weapon, renderer);
        this.rendererRegistry.register(weapon, weapon.getName(), weapon.getRenderer());
        renderer.setClientModContext(this);
    }

    @Override
    public void registerRenderableItem(String name, Item item, Object renderer) {
        super.registerRenderableItem(name, item, renderer);
        this.rendererRegistry.register(item, name, renderer);
    }

    @Override
    protected EntityPlayer getPlayer(CompatibleMessageContext ctx) {
        return CompatibilityProvider.compatibility.clientPlayer();
    }

    @Override
    public void runSyncTick(Runnable runnable) {
        this.mainLoopLock.lock();
        try {
            runnable.run();
        }
        finally {
            this.mainLoopLock.unlock();
        }
    }

    @Override
    public void runInMainThread(Runnable runnable) {
        this.runInClientThreadQueue.add(runnable);
    }

    @Override
    public PlayerItemInstanceRegistry getPlayerItemInstanceRegistry() {
        return this.playerItemInstanceRegistry;
    }

    protected SyncManager<?> getSyncManager() {
        return this.syncManager;
    }

    @Override
    public PlayerWeaponInstance getMainHeldWeapon() {
        return this.getPlayerItemInstanceRegistry().getMainHandItemInstance(CompatibilityProvider.compatibility.clientPlayer(), PlayerWeaponInstance.class);
    }

    @Override
    public StatusMessageCenter getStatusMessageCenter() {
        return this.statusMessageCenter;
    }
}

