/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ClientModContext;
import com.vicmatskiv.weaponlib.PlayerWeaponInstance;
import com.vicmatskiv.weaponlib.RenderingPhase;
import com.vicmatskiv.weaponlib.SafeGlobals;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleClientEventHandler;
import com.vicmatskiv.weaponlib.compatibility.CompatibleClientTickEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatibleRenderTickEvent;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientEventHandler
extends CompatibleClientEventHandler {
    private static final UUID SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER_UUID = UUID.fromString("8efa8469-0256-4f8e-bdd9-3e7b23970663");
    private static final AttributeModifier SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER = new AttributeModifier(SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER_UUID, "Slow Down While Zooming", -0.5, 2).func_111168_a(false);
    private static final Logger logger = LogManager.getLogger(ClientEventHandler.class);
    private Lock mainLoopLock = new ReentrantLock();
    private SafeGlobals safeGlobals;
    private Queue<Runnable> runInClientThreadQueue;
    private long renderEndNanoTime;
    private ClientModContext modContext;

    public ClientEventHandler(ClientModContext modContext, Lock mainLoopLock, SafeGlobals safeGlobals, Queue<Runnable> runInClientThreadQueue) {
        this.modContext = modContext;
        this.mainLoopLock = mainLoopLock;
        this.safeGlobals = safeGlobals;
        this.runInClientThreadQueue = runInClientThreadQueue;
        this.renderEndNanoTime = System.nanoTime();
    }

    @Override
    public void onCompatibleClientTick(CompatibleClientTickEvent event) {
        if (event.getPhase() == CompatibleClientTickEvent.Phase.START) {
            this.mainLoopLock.lock();
        } else if (event.getPhase() == CompatibleClientTickEvent.Phase.END) {
            this.update();
            this.modContext.getSyncManager().run();
            this.mainLoopLock.unlock();
            this.processRunInClientThreadQueue();
            this.safeGlobals.objectMouseOver.set(CompatibilityProvider.compatibility.getObjectMouseOver());
            if (CompatibilityProvider.compatibility.clientPlayer() != null) {
                this.safeGlobals.currentItemIndex.set(CompatibilityProvider.compatibility.clientPlayer().field_71071_by.field_70461_c);
            }
        }
    }

    private void update() {
        EntityPlayer player = CompatibilityProvider.compatibility.clientPlayer();
        this.modContext.getPlayerItemInstanceRegistry().update(player);
        PlayerWeaponInstance mainHandHeldWeaponInstance = this.modContext.getMainHeldWeapon();
        if (mainHandHeldWeaponInstance != null) {
            if (player.func_70051_ag()) {
                mainHandHeldWeaponInstance.setAimed(false);
            }
            if (mainHandHeldWeaponInstance.isAimed()) {
                this.slowPlayerDown(player);
            } else {
                this.restorePlayerSpeed(player);
            }
        } else if (player != null) {
            this.restorePlayerSpeed(player);
        }
    }

    private void restorePlayerSpeed(EntityPlayer entityPlayer) {
        if (entityPlayer.func_110148_a(CompatibilityProvider.compatibility.getMovementSpeedAttribute()).func_111127_a(SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER.func_111167_a()) != null) {
            entityPlayer.func_110148_a(CompatibilityProvider.compatibility.getMovementSpeedAttribute()).func_111124_b(SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER);
        }
    }

    private void slowPlayerDown(EntityPlayer entityPlayer) {
        if (entityPlayer.func_110148_a(CompatibilityProvider.compatibility.getMovementSpeedAttribute()).func_111127_a(SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER.func_111167_a()) == null) {
            entityPlayer.func_110148_a(CompatibilityProvider.compatibility.getMovementSpeedAttribute()).func_111121_a(SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER);
        }
    }

    private void processRunInClientThreadQueue() {
        Runnable r;
        while ((r = this.runInClientThreadQueue.poll()) != null) {
            r.run();
        }
    }

    @Override
    protected void onCompatibleRenerTickEvent(CompatibleRenderTickEvent event) {
        if (event.getPhase() == CompatibleRenderTickEvent.Phase.START && CompatibilityProvider.compatibility.clientPlayer() != null) {
            this.safeGlobals.renderingPhase.set(RenderingPhase.RENDER_VIEWFINDER);
            long p_78471_2_ = this.renderEndNanoTime + 16666666L;
            PlayerWeaponInstance instance = this.modContext.getMainHeldWeapon();
            if (instance != null && instance.isAimed()) {
                this.modContext.getFramebuffer().func_147610_a(true);
                this.modContext.getSecondWorldRenderer().func_78464_a();
                this.modContext.getSecondWorldRenderer().func_78471_a(event.getRenderTickTime(), p_78471_2_);
                Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
            }
            this.renderEndNanoTime = System.nanoTime();
            this.safeGlobals.renderingPhase.set(RenderingPhase.NORMAL);
        } else if (event.getPhase() == CompatibleRenderTickEvent.Phase.END) {
            this.safeGlobals.renderingPhase.set(null);
        }
    }
}

