/*
 * Decompiled with CFR 0.152.
 */
package net.soggymustache.zawam.world.generation;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.soggymustache.zawam.init.block.ZAWABlock;
import net.soggymustache.zawam.world.biome.decorator.WorldGenAlderTree;
import net.soggymustache.zawam.world.generation.WorldGenBamboo;
import net.soggymustache.zawam.world.generation.WorldGenZAWAFlower;
import net.soggymustache.zawam.world.generation.WorldGenZAWAFlower2;

public class ZAWAWorldGenerator
implements IWorldGenerator {
    private WorldGenerator gen_steel = new WorldGenMinable(ZAWABlock.steel_ore.func_176223_P(), 8);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        switch (world.field_73011_w.func_177502_q()) {
            case -1: {
                this.generateNether(world, random, blockX, blockZ);
                break;
            }
            case 0: {
                this.generateOverworld(world, random, blockX, blockZ);
                this.runGenerator(this.gen_steel, world, random, chunkX, chunkZ, 20, 0, 64);
                break;
            }
            case 1: {
                this.generateEnd(world, random, blockX, blockZ);
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    private void generateNether(World world, Random rand, int blockX, int blockZ) {
    }

    private void generateOverworld(World world, Random rand, int blockX, int blockZ) {
        WorldGenBamboo getBamboo = new WorldGenBamboo();
        BiomeGenBase biome = world.func_180494_b(new BlockPos(blockX, 64, blockZ));
        if (biome == BiomeGenBase.field_76772_c || biome == BiomeGenBase.field_76767_f) {
            int MIN = 6;
            int MAX = 10;
            int numBushes = MIN + rand.nextInt(MAX - MIN);
            for (int i = 0; i < numBushes; ++i) {
                int randX = blockX + rand.nextInt(16);
                int randZ = blockZ + rand.nextInt(16);
                getBamboo.func_180709_b(world, rand, new BlockPos(randX, 24, randZ));
            }
        }
        WorldGenZAWAFlower getFlower = new WorldGenZAWAFlower();
        if (biome == BiomeGenBase.field_76772_c || biome == BiomeGenBase.field_76767_f || biome == BiomeGenBase.field_76785_t) {
            int MIN = 9;
            int MAX = 14;
            int numBushes = MIN + rand.nextInt(MAX - MIN);
            for (int i = 0; i < numBushes; ++i) {
                int randX = blockX + rand.nextInt(16);
                int randZ = blockZ + rand.nextInt(16);
                getFlower.func_180709_b(world, rand, new BlockPos(randX, 24, randZ));
            }
        }
        WorldGenZAWAFlower2 getFlower2 = new WorldGenZAWAFlower2();
        if (biome == BiomeGenBase.field_76772_c || biome == BiomeGenBase.field_76767_f || biome == BiomeGenBase.field_76785_t) {
            int MIN = 9;
            int MAX = 14;
            int numBushes = MIN + rand.nextInt(MAX - MIN);
            for (int i = 0; i < numBushes; ++i) {
                int randX = blockX + rand.nextInt(16);
                int randZ = blockZ + rand.nextInt(16);
                getFlower2.func_180709_b(world, rand, new BlockPos(randX, 24, randZ));
            }
        }
        WorldGenAlderTree getAlder = new WorldGenAlderTree(true);
        if (biome == BiomeGenBase.field_76772_c || biome == BiomeGenBase.field_76767_f || biome == BiomeGenBase.field_76785_t) {
            int MIN = 2;
            int MAX = 10;
            int numBushes = MIN + rand.nextInt(MAX - MIN);
            for (int i = 0; i < numBushes; ++i) {
                int randX = blockX + rand.nextInt(16);
                int randZ = blockZ + rand.nextInt(16);
                getAlder.func_180709_b(world, rand, new BlockPos(randX, 24, randZ));
            }
        }
    }

    private void generateEnd(World world, Random rand, int blockX, int blockZ) {
    }

    public static int getGroundFromAbove(World world, int x, int z) {
        int y = 255;
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = blockAt == Blocks.field_150346_d || blockAt == Blocks.field_150349_c;
        }
        return y;
    }
}

