/*
 * Decompiled with CFR 0.152.
 */
package com.salvestrom.w2theJungle.worldGen.biome;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class MangoTreeExperiment
extends WorldGenAbstractTree {
    private static final IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public MangoTreeExperiment(boolean p_i45461_1_) {
        super(p_i45461_1_);
    }

    public boolean generate(World world, Random rng, int x, int y, int z) {
        int treeHeight = rng.nextInt(3) + rng.nextInt(2) + 9;
        boolean canSpawn = true;
        int hB = rng.nextInt(3) + 2 + 4;
        if (y >= 1 && y + treeHeight + 1 <= 256) {
            IBlockState state;
            int zMod;
            int xMod;
            for (int yMod = y; yMod <= y + 1 + treeHeight; ++yMod) {
                int b0 = 1;
                if (yMod == y) {
                    b0 = 0;
                }
                if (yMod >= y + 1 + treeHeight - 2) {
                    b0 = 2;
                }
                for (xMod = x - b0; xMod <= x + b0 && canSpawn; ++xMod) {
                    for (zMod = z - b0; zMod <= z + b0 && canSpawn; ++zMod) {
                        if (yMod >= 0 && yMod < 256) {
                            BlockPos pos = new BlockPos(xMod, yMod, zMod);
                            if (this.isReplaceable(world, pos)) continue;
                            canSpawn = false;
                            continue;
                        }
                        canSpawn = false;
                    }
                }
            }
            if (!canSpawn) {
                return false;
            }
            BlockPos pos = new BlockPos(x, y, z);
            Block block1 = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            boolean isSoil = block1.canSustainPlant(state = world.func_180495_p(pos), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && y < 256 - treeHeight - 1 && rng.nextInt(10) == 0 || block1 == Blocks.field_150355_j && y < 256 - treeHeight - 1) {
                int treeSlice;
                int heightCount;
                this.onPlantGrow(world, x, y - 1, z, x, y, z);
                this.onPlantGrow(world, x + 1, y - 1, z, x, y, z);
                this.onPlantGrow(world, x + 1, y - 1, z + 1, x, y, z);
                this.onPlantGrow(world, x, y - 1, z + 1, x, y, z);
                EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rng);
                xMod = y + hB + rng.nextInt(3) + 4;
                zMod = 2 - rng.nextInt(3);
                int newX = x;
                int newZ = z;
                int i2 = 0;
                for (heightCount = 0; heightCount < treeHeight; ++heightCount) {
                    treeSlice = y + hB + heightCount;
                    if (treeSlice >= xMod && zMod > 0 && rng.nextInt(2) == 0) {
                        newX += enumfacing.func_82601_c();
                        newZ += enumfacing.func_82599_e();
                        --zMod;
                    }
                    BlockPos pos2 = new BlockPos(newX, treeSlice, newZ);
                    IBlockState state2 = world.func_180495_p(pos);
                    Block block2 = state2.func_177230_c();
                    if (!block2.isAir(state2, (IBlockAccess)world, pos2) && !block2.isLeaves(state2, (IBlockAccess)world, pos2)) continue;
                    this.func_175903_a(world, pos2, JUNGLE_LOG);
                    this.func_175903_a(world, pos2.func_177974_f(), JUNGLE_LOG);
                    this.func_175903_a(world, pos2.func_177968_d(), JUNGLE_LOG);
                    this.func_175903_a(world, pos2.func_177974_f().func_177968_d(), JUNGLE_LOG);
                    i2 = treeSlice;
                }
                for (heightCount = -2; heightCount <= 0; ++heightCount) {
                    for (treeSlice = -3; treeSlice <= 0; ++treeSlice) {
                        if (heightCount != -2 || treeSlice != 0) {
                            int b1 = -1;
                            this.leafPlacement(world, newX + heightCount, i2 + b1, newZ + treeSlice);
                            this.leafPlacement(world, 1 + newX - heightCount, i2 + b1, newZ + treeSlice);
                            this.leafPlacement(world, newX + heightCount, i2 + b1, 1 + newZ - treeSlice);
                            this.leafPlacement(world, 1 + newX - heightCount, i2 + b1, 1 + newZ - treeSlice);
                        }
                        if (heightCount <= -2 && treeSlice <= -3 || heightCount == -2 && treeSlice == -3) continue;
                        int b2 = 1;
                        this.leafPlacement(world, newX + heightCount, i2 + b2, newZ + treeSlice);
                        this.leafPlacement(world, 1 + newX - heightCount, i2 + b2, newZ + treeSlice);
                        this.leafPlacement(world, newX + heightCount, i2 + b2, 1 + newZ - treeSlice);
                        this.leafPlacement(world, 1 + newX - heightCount, i2 + b2, 1 + newZ - treeSlice);
                    }
                }
                if (rng.nextBoolean()) {
                    this.leafPlacement(world, newX, i2 + 2, newZ);
                    this.leafPlacement(world, newX + 1, i2 + 2, newZ);
                    this.leafPlacement(world, newX + 1, i2 + 2, newZ + 1);
                    this.leafPlacement(world, newX, i2 + 2, newZ + 1);
                }
                int a = 3;
                int b = 4;
                int c = 5;
                for (heightCount = -a; heightCount <= b; ++heightCount) {
                    for (treeSlice = -b; treeSlice <= c; ++treeSlice) {
                        if (heightCount == -a && treeSlice == -b || heightCount == -a && treeSlice == c || heightCount == b && treeSlice == -b || heightCount == b && treeSlice == c || Math.abs(heightCount) >= b && Math.abs(treeSlice) >= c) continue;
                        this.leafPlacement(world, newX + heightCount, i2, newZ + treeSlice);
                    }
                }
                int enough = 0;
                while (enough <= 3) {
                    for (int treeLegX = -1; treeLegX <= 2; ++treeLegX) {
                        for (int treeLegZ = -1; treeLegZ <= 2; ++treeLegZ) {
                            if (enough > rng.nextInt(2) + 3 || treeLegX >= 0 && treeLegX <= 1 && treeLegZ >= 0 && treeLegZ <= 1 || rng.nextInt(5) != 0) continue;
                            int legLength = rng.nextInt(3) + 17;
                            int legOffset = y + hB + rng.nextInt(2);
                            zMod = 3 - rng.nextInt(2);
                            int offsetX = 0;
                            int offsetZ = 0;
                            for (int l2 = 0; l2 < legLength; ++l2) {
                                if (zMod >= 0 && rng.nextInt(2) == 0 && l2 > 2 + rng.nextInt(2)) {
                                    offsetX += enumfacing.func_82601_c();
                                    offsetZ += enumfacing.func_82601_c();
                                    --zMod;
                                }
                                this.func_175903_a(world, new BlockPos(x + treeLegX + offsetX, legOffset - l2, z + treeLegZ + offsetZ), JUNGLE_LOG);
                            }
                            ++enough;
                            for (int ytree = y + hB; ytree <= y + hB + treeHeight; ++ytree) {
                                int j1 = ytree - (y + hB + treeHeight);
                                int k1 = 2 - j1 / 2;
                                for (int xtree = x - k1; xtree <= x + k1; ++xtree) {
                                    for (int ztree = z - k1; ztree <= z + k1; ++ztree) {
                                        BlockPos pos3 = new BlockPos(xtree, ytree, ztree);
                                        IBlockState state3 = world.func_180495_p(pos3).func_177230_c().func_176223_P();
                                        if (!world.func_180495_p(pos3).func_177230_c().isLeaves(state3, (IBlockAccess)world, pos3)) continue;
                                        if (rng.nextInt(5) == 0 && world.func_180495_p(pos3.func_177976_e()).func_177230_c() == Blocks.field_150350_a) {
                                            this.generateVines(world, xtree - 1, ytree, ztree, BlockVine.field_176278_M);
                                        }
                                        if (rng.nextInt(5) == 0 && world.func_180495_p(pos3.func_177974_f()).func_177230_c() == Blocks.field_150350_a) {
                                            this.generateVines(world, xtree + 1, ytree, ztree, BlockVine.field_176280_O);
                                        }
                                        if (rng.nextInt(5) == 0 && world.func_180495_p(pos3.func_177978_c()).func_177230_c() == Blocks.field_150350_a) {
                                            this.generateVines(world, xtree, ytree, ztree - 1, BlockVine.field_176279_N);
                                        }
                                        if (rng.nextInt(5) != 0 || world.func_180495_p(pos3.func_177968_d()).func_177230_c() != Blocks.field_150350_a) continue;
                                        this.generateVines(world, xtree, ytree, ztree + 1, BlockVine.field_176273_b);
                                    }
                                }
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void leafPlacement(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            this.func_175903_a(world, pos, JUNGLE_LEAF);
        }
    }

    private void onPlantGrow(World world, int x, int y, int z, int sourceX, int sourceY, int sourceZ) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        state.func_177230_c().onPlantGrow(state, world, pos, new BlockPos(sourceX, sourceY, sourceZ));
    }

    private void generateVines(World world, int x, int y, int z, PropertyBool prop) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        this.func_175903_a(world, pos, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true)));
        int i1 = 4;
        while (true) {
            --y;
            if (state.func_177230_c() != Blocks.field_150350_a || i1 <= 0) {
                return;
            }
            this.func_175903_a(world, pos, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true)));
            --i1;
        }
    }

    public boolean func_180709_b(World world, Random rng, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return this.generate(world, rng, x, y, z);
    }
}

