/*
 * Decompiled with CFR 0.152.
 */
package com.salvestrom.w2theJungle.worldGen;

import com.salvestrom.w2theJungle.init.JungleBlocks;
import com.salvestrom.w2theJungle.worldGen.CavesLostWorld;
import com.salvestrom.w2theJungle.worldGen.RavineLostWorld;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LostChunkProvider
implements IChunkGenerator {
    private Random hellRNG;
    private NoiseGeneratorOctaves netherNoiseGen1;
    private NoiseGeneratorOctaves netherNoiseGen2;
    private NoiseGeneratorOctaves netherNoiseGen3;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    private World worldObj;
    private double[] noiseField;
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] depthBuffer = new double[256];
    private MapGenBase netherCaveGenerator = new CavesLostWorld();
    private MapGenBase ravineGenerator = new RavineLostWorld();
    double[] noiseData1pnr;
    double[] noiseData2ar;
    double[] noiseData3br;
    double[] noiseData4;
    double[] noiseData5dr;
    private static final IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final IBlockState OAK_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public LostChunkProvider(World par1World, long par2, boolean features) {
        this.worldObj = par1World;
        this.hellRNG = new Random(par2);
        this.netherNoiseGen1 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.netherNoiseGen2 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.netherNoiseGen3 = new NoiseGeneratorOctaves(this.hellRNG, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.hellRNG, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.hellRNG, 16);
        InitNoiseGensEvent.ContextHell noise = new InitNoiseGensEvent.ContextHell(this.netherNoiseGen1, this.netherNoiseGen2, this.netherNoiseGen3, this.slowsandGravelNoiseGen, this.netherrackExculsivityNoiseGen, this.scaleNoise, this.depthNoise);
        noise = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)par1World, (Random)this.hellRNG, (InitNoiseGensEvent.Context)noise);
        this.netherNoiseGen1 = noise.getLPerlin1();
        this.netherNoiseGen2 = noise.getLPerlin2();
        this.netherNoiseGen3 = noise.getPerlin();
        this.slowsandGravelNoiseGen = noise.getPerlin2();
        this.netherrackExculsivityNoiseGen = noise.getPerlin3();
        this.scaleNoise = noise.getScale();
        this.depthNoise = noise.getDepth();
        this.netherCaveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.netherCaveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
    }

    public void prepareHeights(int x, int z, ChunkPrimer primer) {
        int i = 4;
        int j = 32;
        int k = i + 1;
        int l = 17;
        int i1 = i + 1;
        this.noiseField = this.getHeights(this.noiseField, x * i, 0, z * i, k, l, i1);
        for (int j1 = 0; j1 < i; ++j1) {
            for (int k1 = 0; k1 < i; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    double d0 = 0.125;
                    double d1 = this.noiseField[((j1 + 0) * i1 + k1 + 0) * l + l1 + 0];
                    double d2 = this.noiseField[((j1 + 0) * i1 + k1 + 1) * l + l1 + 0];
                    double d3 = this.noiseField[((j1 + 1) * i1 + k1 + 0) * l + l1 + 0];
                    double d4 = this.noiseField[((j1 + 1) * i1 + k1 + 1) * l + l1 + 0];
                    double d5 = (this.noiseField[((j1 + 0) * i1 + k1 + 0) * l + l1 + 1] - d1) * d0;
                    double d6 = (this.noiseField[((j1 + 0) * i1 + k1 + 1) * l + l1 + 1] - d2) * d0;
                    double d7 = (this.noiseField[((j1 + 1) * i1 + k1 + 0) * l + l1 + 1] - d3) * d0;
                    double d8 = (this.noiseField[((j1 + 1) * i1 + k1 + 1) * l + l1 + 1] - d4) * d0;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int j2 = 0; j2 < 4; ++j2) {
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState block = null;
                                if (l1 * 8 + i2 < j) {
                                    block = Blocks.field_150355_j.func_176223_P();
                                }
                                if (d15 > 0.0) {
                                    block = Blocks.field_150348_b.func_176223_P();
                                }
                                int newx = j2 + j1 * 4;
                                int newy = i2 + l1 * 8;
                                int newz = k2 + k1 * 4;
                                primer.func_177855_a(newx, newy, newz, block);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void buildSurfaces(int x, int z, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.worldObj)) {
            return;
        }
        int seaLevel = 62;
        double d0 = 0.03125;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, x * 16, z * 16, 0, 16, 16, 1, d0, d0, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.func_76304_a(this.gravelNoise, x * 16, 109, z * 16, 16, 1, 16, d0, 1.0, d0);
        this.depthBuffer = this.netherrackExculsivityNoiseGen.func_76304_a(this.depthBuffer, x * 16, z * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        for (int xBlock = 0; xBlock < 16; ++xBlock) {
            for (int zBlock = 0; zBlock < 16; ++zBlock) {
                boolean flag = this.slowsandNoise[xBlock + zBlock * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[xBlock + zBlock * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                int i1 = (int)(this.depthBuffer[xBlock + zBlock * 16] / 3.0 + 3.0 + this.hellRNG.nextDouble() * 0.25);
                int j1 = -1;
                IBlockState topBlock = Blocks.field_150349_c.func_176223_P();
                IBlockState fillerBlock = Blocks.field_150346_d.func_176223_P();
                for (int yLayer = 127; yLayer >= 0; --yLayer) {
                    if (yLayer < 127 - this.hellRNG.nextInt(5) && yLayer > 0 + this.hellRNG.nextInt(5)) {
                        IBlockState block2 = primer.func_177856_a(xBlock, yLayer, zBlock);
                        if (block2 != null && block2.func_185904_a() != Material.field_151579_a) {
                            if (block2.func_177230_c() != Blocks.field_150348_b) continue;
                            if (j1 == -1) {
                                if (i1 <= 0) {
                                    topBlock = Blocks.field_150349_c.func_176223_P();
                                    fillerBlock = Blocks.field_150346_d.func_176223_P();
                                } else if (yLayer >= seaLevel - 4 && yLayer <= seaLevel + 1) {
                                    topBlock = Blocks.field_150349_c.func_176223_P();
                                    fillerBlock = Blocks.field_150346_d.func_176223_P();
                                    if (flag1) {
                                        topBlock = Blocks.field_150351_n.func_176223_P();
                                        fillerBlock = Blocks.field_150348_b.func_176223_P();
                                    }
                                    if (flag) {
                                        topBlock = Blocks.field_150391_bh.func_176223_P();
                                        fillerBlock = Blocks.field_150346_d.func_176223_P();
                                    }
                                }
                                if (yLayer < seaLevel && (topBlock == null || topBlock.func_185904_a() == Material.field_151579_a)) {
                                    topBlock = Blocks.field_150355_j.func_176223_P();
                                }
                                j1 = i1;
                                if (yLayer >= seaLevel - 1) {
                                    primer.func_177855_a(xBlock, yLayer, zBlock, topBlock);
                                    continue;
                                }
                                primer.func_177855_a(xBlock, yLayer, zBlock, fillerBlock);
                                continue;
                            }
                            if (j1 <= 0) continue;
                            --j1;
                            primer.func_177855_a(xBlock, yLayer, zBlock, fillerBlock);
                            continue;
                        }
                        j1 = -1;
                        continue;
                    }
                    primer.func_177855_a(xBlock, yLayer, zBlock, Blocks.field_150357_h.func_176223_P());
                }
            }
        }
    }

    public Chunk func_185932_a(int par1, int par2) {
        this.hellRNG.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.prepareHeights(par1, par2, chunkprimer);
        this.buildSurfaces(par1, par2, chunkprimer);
        this.netherCaveGenerator.func_186125_a(this.worldObj, par1, par2, chunkprimer);
        this.ravineGenerator.func_186125_a(this.worldObj, par1, par2, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, par1, par2);
        Biome[] abiome = this.worldObj.func_72959_q().func_76933_b((Biome[])null, par1 * 16, par2 * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (int k = 0; k < abyte.length; ++k) {
            abyte[k] = (byte)Biome.func_185362_a((Biome)abiome[k]);
        }
        chunk.func_76613_n();
        return chunk;
    }

    private double[] getHeights(double[] par1ArrayOfDouble, int modX, int modY, int modZ, int par5, int par6, int par7) {
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, par1ArrayOfDouble, modX, modY, modZ, par5, par6, par7);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.scaleNoise.func_76304_a(this.noiseData4, modX, modY, modZ, par5, 1, par7, 1.0, 0.0, 1.0);
        this.noiseData5dr = this.depthNoise.func_76304_a(this.noiseData5dr, modX, modY, modZ, par5, 1, par7, 100.0, 0.0, 100.0);
        this.noiseData1pnr = this.netherNoiseGen3.func_76304_a(this.noiseData1pnr, modX, modY, modZ, par5, par6, par7, d0 / 80.0, d1 / 60.0, d0 / 80.0);
        this.noiseData2ar = this.netherNoiseGen1.func_76304_a(this.noiseData2ar, modX, modY, modZ, par5, par6, par7, d0, d1, d0);
        this.noiseData3br = this.netherNoiseGen2.func_76304_a(this.noiseData3br, modX, modY, modZ, par5, par6, par7, d0, d1, d0);
        int i = 0;
        double[] adouble1 = new double[par6];
        for (int j = 0; j < par6; ++j) {
            adouble1[j] = Math.cos((double)j * Math.PI * 6.0 / (double)par6) * 2.0;
            double d2 = j;
            if (j > par6 / 2) {
                d2 = par6 - 1 - j;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = j;
            adouble1[n] = adouble1[n] - d2 * d2 * d2 * 10.0;
        }
        for (int l = 0; l < par5; ++l) {
            for (int i1 = 0; i1 < par7; ++i1) {
                double d3 = 0.0;
                for (int k = 0; k < par6; ++k) {
                    double d4 = 0.0;
                    double d5 = adouble1[k];
                    double d6 = this.noiseData2ar[i] / 512.0;
                    double d7 = this.noiseData3br[i] / 512.0;
                    double d8 = (this.noiseData1pnr[i] / 10.0 + 1.0) / 2.0;
                    d4 = d8 < 0.0 ? d6 : (d8 > 1.0 ? d7 : d6 + (d7 - d6) * d8);
                    d4 -= d5;
                    if (k > par6 - 4) {
                        double d9 = (float)(k - (par6 - 4)) / 3.0f;
                        d4 = d4 * (1.0 - d9) + -10.0 * d9;
                    }
                    if ((double)k < d3) {
                        double d10 = (d3 - (double)k) / 4.0;
                        d10 = MathHelper.func_151237_a((double)d10, (double)0.0, (double)1.0);
                        d4 = d4 * (1.0 - d10) + -10.0 * d10;
                    }
                    par1ArrayOfDouble[i] = d4;
                    ++i;
                }
            }
        }
        return par1ArrayOfDouble;
    }

    public void func_185931_b(int x, int z) {
        int j2;
        int i2;
        int j1;
        int yLayer;
        int i1;
        int k1;
        BlockFalling.field_149832_M = true;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.worldObj, this.hellRNG, x, z, false));
        int blockX = x * 16;
        int blockZ = z * 16;
        Biome biome = this.worldObj.func_180494_b(new BlockPos(blockX + 16, 1, blockZ + 16));
        boolean doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        for (k1 = 0; k1 <= 15; ++k1) {
            for (i1 = 0; doGen && i1 <= 15; ++i1) {
                for (yLayer = 111; doGen && yLayer <= 128; ++yLayer) {
                    if (!this.worldObj.func_175623_d(new BlockPos(blockX + k1, yLayer - 1, blockZ + i1))) continue;
                    this.worldObj.func_175656_a(new BlockPos(blockX + k1, yLayer, blockZ + i1), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        if (!(biome instanceof BiomeDesert) && this.hellRNG.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            k1 = blockX + this.hellRNG.nextInt(16) + 8;
            yLayer = this.hellRNG.nextInt(127);
            i1 = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.worldObj, this.hellRNG, new BlockPos(k1, yLayer, i1));
        }
        for (i1 = 0; doGen && i1 < 15; ++i1) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(100) + 20;
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenMegaJungle(false, 10, 15, JUNGLE_LOG, JUNGLE_LEAF).func_180709_b(this.worldObj, this.hellRNG, new BlockPos(j1, k1, yLayer));
        }
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        for (i1 = 0; doGen && i1 < 15; ++i1) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(100) + 20;
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenMegaJungle(false, 10, 20, JUNGLE_LOG, JUNGLE_LEAF).func_180709_b(this.worldObj, this.hellRNG, new BlockPos(j1, k1, yLayer));
        }
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA);
        for (i1 = 0; doGen && i1 < 12; ++i1) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(100) + 20;
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenMegaJungle(false, 10, 25, JUNGLE_LOG, JUNGLE_LEAF).func_180709_b(this.worldObj, this.hellRNG, new BlockPos(j1, k1, yLayer));
        }
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA);
        for (i1 = 0; doGen && i1 < 8; ++i1) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(70) + 50;
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenMegaJungle(false, 10, 30, JUNGLE_LOG, JUNGLE_LEAF).func_180709_b(this.worldObj, this.hellRNG, new BlockPos(j1, k1, yLayer));
        }
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA);
        for (i1 = 0; doGen && i1 < 20; ++i1) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(70) + 40;
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenShrub(JUNGLE_LOG, OAK_LEAF).func_180709_b(this.worldObj, this.hellRNG, new BlockPos(j1, k1, yLayer));
        }
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA);
        for (i1 = 0; doGen && i1 < 9; ++i1) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(70) + 50;
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenTallGrass(BlockTallGrass.EnumType.FERN).func_180709_b(this.worldObj, this.hellRNG, new BlockPos(j1, k1, yLayer));
        }
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA);
        for (i1 = 0; doGen && i1 < 9; ++i1) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(70) + 50;
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS).func_180709_b(this.worldObj, this.hellRNG, new BlockPos(j1, k1, yLayer));
        }
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA);
        for (i1 = 0; doGen && i1 < 2; ++i1) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(30) + 30;
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenTallGrass(BlockTallGrass.EnumType.DEAD_BUSH).func_180709_b(this.worldObj, this.hellRNG, new BlockPos(j1, k1, yLayer));
        }
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA);
        for (i1 = 0; doGen && i1 < 10; ++i1) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(20) + 30;
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenSwamp().func_180709_b(this.worldObj, this.hellRNG, new BlockPos(j1, k1, yLayer));
        }
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA);
        for (i1 = 0; doGen && i1 < 8; ++i1) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(120) + 4;
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
        }
        i1 = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1);
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.hellRNG, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.GLOWSTONE);
        for (j1 = 0; doGen && j1 < i1; ++j1) {
            k1 = blockX + this.hellRNG.nextInt(16) + 8;
            yLayer = this.hellRNG.nextInt(40) + 20;
            i2 = blockZ + this.hellRNG.nextInt(16) + 8;
        }
        for (j1 = 0; doGen && j1 < 10; ++j1) {
            k1 = blockX + this.hellRNG.nextInt(16) + 8;
            yLayer = this.hellRNG.nextInt(128);
            i2 = blockZ + this.hellRNG.nextInt(16) + 8;
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.worldObj, this.hellRNG, new BlockPos(blockX, 0, blockZ)));
        doGen = TerrainGen.decorate((World)this.worldObj, (Random)this.hellRNG, (BlockPos)new BlockPos(blockX, 0, blockZ), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM);
        if (doGen && this.hellRNG.nextInt(1) == 0) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(125);
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenBush(Blocks.field_150338_P).func_180709_b(this.worldObj, this.hellRNG, new BlockPos(j1, k1, yLayer));
        }
        if (doGen && this.hellRNG.nextInt(1) == 0) {
            j1 = blockX + this.hellRNG.nextInt(16) + 8;
            k1 = this.hellRNG.nextInt(128);
            yLayer = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenBush(Blocks.field_150337_Q).func_180709_b(this.worldObj, this.hellRNG, new BlockPos(j1, k1, yLayer));
        }
        WorldGenMinable worldgenminable = new WorldGenMinable(JungleBlocks.oreSapphire.func_176223_P(), 13);
        doGen = TerrainGen.generateOre((World)this.worldObj, (Random)this.hellRNG, (WorldGenerator)worldgenminable, (BlockPos)new BlockPos(blockX, 0, blockZ), (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND);
        for (k1 = 0; doGen && k1 < 16; ++k1) {
            yLayer = blockX + this.hellRNG.nextInt(16);
            i2 = this.hellRNG.nextInt(108) + 10;
            j2 = blockZ + this.hellRNG.nextInt(16);
            worldgenminable.func_180709_b(this.worldObj, this.hellRNG, new BlockPos(yLayer, i2, j2));
        }
        for (k1 = 0; k1 < 16; ++k1) {
            i1 = blockX + this.hellRNG.nextInt(16);
            i2 = this.hellRNG.nextInt(108) + 10;
            j2 = blockZ + this.hellRNG.nextInt(16);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.worldObj, this.hellRNG, new BlockPos(blockX, 0, blockZ)));
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post((IChunkGenerator)this, this.worldObj, this.hellRNG, x, z, false));
        BlockFalling.field_149832_M = false;
    }

    public List func_177458_a(EnumCreatureType par1EnumCreatureType, BlockPos pos) {
        if (par1EnumCreatureType == EnumCreatureType.MONSTER) {
            // empty if block
        }
        Biome biomegenbase = this.worldObj.func_180494_b(pos);
        return biomegenbase.func_76747_a(par1EnumCreatureType);
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position) {
        return null;
    }
}

