/*
 * Decompiled with CFR 0.152.
 */
package com.salvestrom.w2theJungle.mobs.entity;

import com.salvestrom.w2theJungle.init.JungleAchievements;
import com.salvestrom.w2theJungle.init.JungleBlocks;
import com.salvestrom.w2theJungle.items.bookScale;
import com.salvestrom.w2theJungle.mobs.entity.EntityLenny;
import com.salvestrom.w2theJungle.mobs.entity.EntityStoneGolem;
import com.salvestrom.w2theJungle.mobs.entity.ai.EntityAISecondaryAttack;
import com.salvestrom.w2theJungle.worldGen.JungleSaveWorld;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTheWall
extends EntityMob
implements IRangedAttackMob {
    public Class[] classlist = new Class[]{EntityPlayer.class, EntityZombie.class, EntitySkeleton.class, EntityWitch.class, EntityVillager.class, EntityIronGolem.class, EntityEnderman.class};
    private static final DataParameter<BlockPos> ATTACKER_POS = EntityDataManager.func_187226_a(EntityTheWall.class, (DataSerializer)DataSerializers.field_187200_j);
    protected static final DataParameter<Integer> ATTACK_STATUS = EntityDataManager.func_187226_a(EntityTheWall.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> WALL_SPAWN_TYPE = EntityDataManager.func_187226_a(EntityTheWall.class, (DataSerializer)DataSerializers.field_187191_a);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    public int smashTimer;
    protected int animationTimer;
    public int breakingtime;
    private int livingSoundTime;
    public int shiftAttackTimer;
    public int tremorTimer;
    public int hcheck;
    public int healthtimer;
    public int effectTimer;
    private EntityLivingBase attacker;
    public float dm = this.field_70170_p.func_175659_aa().func_151525_a();
    private int rangedTimer;
    public int attackStatus;

    public EntityTheWall(World par1World) {
        super(par1World);
        this.func_70105_a(2.5f, 4.5f);
        this.field_70728_aV = 75;
        this.field_70138_W = 1.0f;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
        this.field_70144_Y = 0.85f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISecondaryAttack(this, 0.4, 40, 40.0f, 5.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.273, true));
        for (int i = 0; i < this.classlist.length; ++i) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, this.classlist[i], 0, true, false, IMob.field_82192_a));
        }
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLenny.class, true, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.237));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.275, 30.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WALL_SPAWN_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(ATTACKER_POS, (Object)new BlockPos((Entity)this));
        this.field_70180_af.func_187214_a(ATTACK_STATUS, (Object)0);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        int x = JungleSaveWorld.get((World)this.field_70170_p).wallLocX;
        int y = JungleSaveWorld.get((World)this.field_70170_p).wallLocY;
        int z = JungleSaveWorld.get((World)this.field_70170_p).wallLocZ;
        if (this.getWallSpawnType() == 1) {
            this.func_175449_a(new BlockPos(x, y, z), 18);
        } else {
            this.func_175449_a(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), 18);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    public int func_70658_aO() {
        return !this.lowHealth() ? 7 : 5;
    }

    public boolean lowHealth() {
        return this.func_110143_aJ() < this.func_110138_aP() / 2.0f;
    }

    public boolean isMovementCeased() {
        return this.animationTimer > 0;
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.99);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
    }

    public boolean isAIEnabled() {
        return true;
    }

    public boolean func_70094_T() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70072_I() {
        this.field_70171_ac = false;
        return this.field_70171_ac;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.setAttackStatus();
        if (this.field_70173_aa % 20 == 0) {
            // empty if block
        }
        if (this.effectTimer > 0) {
            this.field_70702_br = 0.0f;
            this.field_70701_bs = 0.0f;
            if (this.getAttackStatus() == 3) {
                this.smashEffect();
                if (this.effectTimer % 8 == 0) {
                    int d = 8 - this.effectTimer / 8;
                    this.tremble(this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(4.0, 0.0, 4.0)), d);
                    this.func_184185_a(SoundEvents.field_187605_cG, 10.0f, -0.001f);
                }
            } else if (this.getAttackStatus() == 4) {
                this.pullIn(this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(10.0, 0.0, 10.0)));
            }
            --this.effectTimer;
        }
        if (this.smashTimer > 0) {
            --this.smashTimer;
        }
        if (this.rangedTimer > 0) {
            --this.rangedTimer;
        }
        if (this.tremorTimer > 0) {
            --this.tremorTimer;
        }
        if (this.animationTimer > 0) {
            --this.animationTimer;
        }
        if (this.shiftAttackTimer > 0) {
            --this.shiftAttackTimer;
        }
        if (this.livingSoundTime > 200 + this.field_70146_Z.nextInt(100)) {
            this.func_184185_a(SoundEvents.field_187594_A, 0.4f, 0.01f);
            this.livingSoundTime = 0;
        } else {
            ++this.livingSoundTime;
        }
        this.walkEffect(3);
        this.destroyBlocksInAABB(this.func_174813_aQ());
        this.calculateHealth();
        if (!this.field_70170_p.field_72995_K && this.healthtimer == 0 && ((double)this.func_110143_aJ() <= (double)this.func_110138_aP() * 0.25 && this.hcheck == 2 || (double)this.func_110143_aJ() <= (double)this.func_110138_aP() * 0.5 && this.hcheck == 1 || (double)this.func_110143_aJ() <= (double)this.func_110138_aP() * 0.75 && this.hcheck == 0)) {
            this.healthtimer = 100;
            ++this.hcheck;
            EntityStoneGolem aid = new EntityStoneGolem(this.field_70170_p);
            aid.func_70012_b(this.field_70165_t - 5.0 + (double)this.field_70146_Z.nextInt(10), this.field_70163_u + 1.0, this.field_70161_v - 5.0 + (double)this.field_70146_Z.nextInt(10), 0.0f, 0.0f);
            aid.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            this.field_70170_p.func_72838_d((Entity)aid);
            aid.func_70624_b(this.func_70638_az());
            this.func_184185_a(SoundEvents.field_187835_fT, 0.5f, 1.0f);
            aid.func_70656_aK();
        }
        if (this.healthtimer > 0) {
            --this.healthtimer;
        }
        if ((double)this.func_110143_aJ() >= (double)this.func_110138_aP() * 0.25 && this.hcheck == 3 || (double)this.func_110143_aJ() >= (double)this.func_110138_aP() * 0.5 && this.hcheck == 2 || (double)this.func_110143_aJ() >= (double)this.func_110138_aP() * 0.75 && this.hcheck == 1) {
            --this.hcheck;
            if (this.hcheck < 0) {
                this.hcheck = 0;
            }
        }
    }

    private void destroyBlocksInAABB(AxisAlignedBB abba) {
        int waymaker = (int)((float)this.breakingtime / 40.0f * 10.0f);
        int minX = MathHelper.func_76128_c((double)abba.field_72340_a);
        int minY = MathHelper.func_76128_c((double)abba.field_72338_b) - 1;
        int minZ = MathHelper.func_76128_c((double)abba.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)abba.field_72336_d);
        int maxY = MathHelper.func_76128_c((double)abba.field_72337_e);
        int maxZ = MathHelper.func_76128_c((double)abba.field_72334_f) + 1;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState iblock = this.field_70170_p.func_180495_p(pos);
                    Block block = iblock.func_177230_c();
                    if (block != Blocks.field_150362_t && block != Blocks.field_150321_G) continue;
                    this.field_70170_p.func_175715_c(this.func_145782_y(), pos, waymaker);
                    if (this.breakingtime > 40) {
                        this.breakingtime = 0;
                        this.func_184185_a(SoundEvents.field_187571_bR, 0.7f, 0.7f);
                        for (int i = 0; i < 20; ++i) {
                            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d3 = 10.0;
                            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)x + (double)(this.field_70146_Z.nextFloat() * 2.0f) - 1.0, (double)y + (double)(this.field_70146_Z.nextFloat() * 2.0f) - 1.0, (double)z + (double)(this.field_70146_Z.nextFloat() * 2.0f) - 1.0, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblock)});
                        }
                        this.field_70170_p.func_175698_g(pos);
                        continue;
                    }
                    ++this.breakingtime;
                }
            }
        }
    }

    public void walkEffect(int l) {
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.3000002779052E-8 && this.field_70146_Z.nextInt(l) == 0) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - this.func_70033_W()));
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            IBlockState iblock = this.field_70170_p.func_180495_p(new BlockPos(i, j, k));
            Block block = iblock.func_177230_c();
            if (iblock.func_185904_a() != Material.field_151579_a) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblock)});
            }
        }
    }

    public void func_70653_a(Entity p_70653_1_, float p_70653_2_, double p_70653_3_, double p_70653_5_) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        }
    }

    public void attackEntity(Entity ntt, float par2) {
        if (ntt.func_174813_aQ().field_72337_e > this.func_174813_aQ().field_72338_b && ntt.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
            this.func_70652_k(ntt);
        }
    }

    public boolean func_70652_k(Entity ntt) {
        boolean flag;
        float dmg;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0));
        if (this.shiftAttackTimer <= 0 && this.lowHealth()) {
            dmg = 3.0f;
            this.whirl(list);
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
            this.field_70180_af.func_187227_b(ATTACK_STATUS, (Object)5);
        } else if (this.tremorTimer <= 0 && list != null && this.animationTimer == 0) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70702_br = 0.0f;
            this.field_70701_bs = 0.0f;
            dmg = 2.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)33);
            this.field_70180_af.func_187227_b(ATTACK_STATUS, (Object)3);
        } else if (this.smashTimer <= 0) {
            dmg = 5.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)31);
            this.field_70180_af.func_187227_b(ATTACK_STATUS, (Object)2);
        } else {
            float dmg2 = 0.0f;
            return false;
        }
        float xtra = (float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f + (float)(this.field_70146_Z.nextGaussian() * 0.25);
        if (dmg > 0.0f) {
            dmg = xtra + dmg + (float)this.field_70146_Z.nextInt((int)dmg - 1);
        }
        if (flag = ntt.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), dmg * 0.9f)) {
            ntt.field_70172_ad = 0;
            ntt.func_70097_a(DamageSource.field_76377_j, dmg * 0.1f + 1.0f);
            if (this.getAttackStatus() == 5) {
                ntt.field_70181_x += 0.2000000059604645;
                ntt.field_70179_y += (double)0.4f;
                ntt.field_70159_w += (double)0.4f;
                this.animationTimer = 20;
                this.shiftAttackTimer = 240;
                this.resetAttackTimers();
            } else if (this.getAttackStatus() == 2) {
                int a = 60;
                this.resetAttackTimers();
                this.animationTimer = 20;
                this.shiftAttackTimer += a;
                this.tremorTimer += a;
                this.smashTimer = a;
                this.func_184185_a(SoundEvents.field_187596_cD, 2.0f, 0.025f);
            } else if (this.getAttackStatus() == 3) {
                this.tremorTimer = 240;
                this.effectTimer = 60;
                this.smashTimer = 60;
                this.shiftAttackTimer = this.shiftAttackTimer < 80 ? 80 : this.shiftAttackTimer;
            }
        }
        return flag;
    }

    public void func_82196_d(EntityLivingBase nttlb, float rangeMod) {
        float acc = 13 - this.field_70170_p.func_175659_aa().func_151525_a() * 4;
        EntityTippedArrow entityarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        EntityTippedArrow entityarrow2 = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        EntityTippedArrow entityarrow3 = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        double d0 = nttlb.field_70165_t - this.field_70165_t;
        double d1 = nttlb.field_70163_u + (double)(nttlb.func_70047_e() / 3.0f) - entityarrow.field_70163_u;
        double d2 = nttlb.field_70161_v - this.field_70161_v;
        float range = (float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        EntityLivingBase nL = nttlb;
        List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(2.0, 0.0, 2.0));
        Iterator it = moblist.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof EntityStoneGolem)) continue;
            it.remove();
        }
        if (this.shiftAttackTimer <= 0 && moblist.size() > 3 && this.getAttackStatus() != 3) {
            this.whirl(moblist);
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
            this.animationTimer = 20;
            this.shiftAttackTimer = 240;
            this.field_70180_af.func_187227_b(ATTACK_STATUS, (Object)5);
            this.resetAttackTimers();
        }
        if (this.shiftAttackTimer <= 0 && !this.lowHealth() && range > 10.0f) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)32);
            this.field_70180_af.func_187227_b(ATTACK_STATUS, (Object)4);
            this.shiftAttackTimer = 240;
            this.tremorTimer = this.tremorTimer < 80 ? 80 : this.tremorTimer;
            this.resetAttackTimers();
            this.animationTimer = 40;
            this.effectTimer = 60;
        } else if (this.rangedTimer <= 0 && range >= 5.0f) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)34);
            this.field_70180_af.func_187227_b(ATTACK_STATUS, (Object)1);
            double d = (double)(rangeMod * 7.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11;
            float rads = 57.29578f;
            float x = (float)(-Math.cos(this.field_70761_aq / rads));
            float z = (float)(-Math.sin(this.field_70761_aq / rads));
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            entityarrow.func_70239_b(d * 1.52);
            entityarrow.func_70107_b(this.field_70165_t + (double)x * 1.5, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v + (double)z * 1.5);
            entityarrow.func_70186_c(d0 - (double)(x * 3.0f), d1 + d3 * 0.2, d2 - (double)(z * 3.0f), 1.6f, acc);
            entityarrow2.func_70239_b(d * 1.52);
            entityarrow2.func_70107_b(this.field_70165_t + (double)x, this.field_70163_u + (double)this.func_70047_e() - 0.5, this.field_70161_v + (double)z);
            entityarrow2.func_70186_c(d0 - (double)(x * 1.0f), d1 + d3 * 0.2, d2 - (double)(z * 1.0f), 1.6f, acc);
            entityarrow3.func_70239_b(d * 1.52);
            entityarrow3.func_70107_b(this.field_70165_t + (double)x * 0.75, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v + (double)z * 0.75);
            entityarrow3.func_70186_c(d0 - (double)x * 0.2, d1 + d3 * 0.2, d2 - (double)z * 0.2, 1.6f, acc);
            this.func_184185_a(SoundEvents.field_187715_dR, 0.6f, 0.6f);
            this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.resetAttackTimers();
            this.field_70170_p.func_72838_d((Entity)entityarrow);
            this.field_70170_p.func_72838_d((Entity)entityarrow2);
            this.field_70170_p.func_72838_d((Entity)entityarrow3);
        }
    }

    public void tremble(List list, int d) {
        this.field_70702_br = 0.0f;
        this.field_70701_bs = 0.0f;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLivingBase) || entity instanceof EntityStoneGolem) continue;
            float d2 = (float)d + this.dm * 1.5f - 0.5f;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), d2);
        }
    }

    public void pullIn(List list) {
        this.field_70702_br = 0.0f;
        this.field_70701_bs = 0.0f;
        int j = list.size();
        for (int l = 0; l < j; ++l) {
            Entity entity = (Entity)list.get(l);
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || !(entity instanceof EntityLivingBase) || entity instanceof EntityStoneGolem || !(this.func_70032_d(entity) > 4.0f)) continue;
            double d0 = this.field_70165_t - entity.field_70165_t;
            double d1 = this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 3.0f) - this.field_70163_u;
            double d2 = this.field_70161_v - entity.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            if (d3 >= 1.0E-7) {
                float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
                float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
                double d4 = d0 / d3;
                double d5 = d2 / d3;
                double d6 = Math.cos((double)this.effectTimer * 1.5) * d3 * 0.1;
                if (this.field_70170_p.func_180495_p(new BlockPos(entity.field_70165_t + d4, this.field_70163_u + 0.51 + d6, entity.field_70161_v + d5)).func_185904_a() == Material.field_151579_a) {
                    entity.func_70012_b(entity.field_70165_t + d4, this.field_70163_u + 0.51 + d6, entity.field_70161_v + d5, f2, f3);
                }
            }
            if (this.effectTimer % 15 != 0) continue;
            entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this), this.dm);
            this.func_184185_a(SoundEvents.field_187571_bR, 0.8f, 0.5f);
        }
    }

    public void whirl(List list) {
        double d0 = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLivingBase)) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 2.0, (double)0.2f, d3 / d4 * 2.0);
            this.func_184185_a(SoundEvents.field_187596_cD, 10.0f, -10000.0f);
            float dm2 = this.dm / 2.0f * this.dm / 2.0f + this.dm + 3.0f;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), dm2);
        }
    }

    private void smashEffect() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - this.func_70033_W()));
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        int a = 4;
        for (int x = -a; x < a; ++x) {
            for (int z = -a; z < a; ++z) {
                if (x * x + z * z >= 16) continue;
                BlockPos blockpos = new BlockPos(i + x, j, k + z);
                IBlockState iblock = this.field_70170_p.func_180495_p(blockpos);
                Block block = iblock.func_177230_c();
                if (iblock.func_185904_a() == Material.field_151579_a) continue;
                double px = this.field_70165_t + (double)x + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N;
                double pz = this.field_70161_v + (double)z + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, px, (double)(j + 1) + 0.1, pz, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblock)});
            }
        }
    }

    public void resetAttackTimers() {
        this.smashTimer = 60;
        this.rangedTimer = 60;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        Entity entity;
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (p_70097_1_ == DamageSource.field_76369_e) {
            return false;
        }
        if (this.lowHealth() && ((entity = p_70097_1_.func_76364_f()) instanceof EntityArrow || entity instanceof EntityThrowable)) {
            return false;
        }
        entity = p_70097_1_.func_76346_g();
        if (entity instanceof EntityPlayer && this.func_70032_d(entity) > 18.0f) {
            return false;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ % (this.field_70146_Z.nextInt(7) + 5) == 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.func_184185_a(SoundEvents.field_187619_bk, 0.5f, 1.0f);
            this.func_184185_a(SoundEvents.field_187605_cG, 10.0f, -0.1f);
        } else if (this.field_70725_aQ % (this.field_70146_Z.nextInt(3) + 10) == 0) {
            this.func_184185_a(SoundEvents.field_187835_fT, 6.0f, 0.2f);
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(4) < 3) {
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)f, this.field_70163_u + (double)f1 + 1.0, this.field_70161_v + (double)f2, new ItemStack(Blocks.field_150341_Y, 1)));
            }
        }
        if (this.field_70725_aQ >= 80 && this.field_70725_aQ % 5 == 0 && !this.field_70170_p.field_72995_K && (this.field_70718_bc > 0 || this.func_70684_aJ()) && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            int j;
            for (int i = this.func_70693_a(this.field_70717_bb) / 3; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
        if (this.field_70725_aQ == 120) {
            this.func_184185_a(SoundEvents.field_187594_A, 4.0f, 0.01f);
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int j;
                for (int i = this.func_70693_a(this.field_70717_bb); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
                    float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
                    float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t + (double)f, this.field_70163_u + (double)f1 + 2.0, this.field_70161_v + (double)f2, j));
                }
                if (this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v)).func_185904_a().func_76220_a()) {
                    this.field_70170_p.func_175656_a(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), JungleBlocks.wallSkull.func_176223_P());
                } else {
                    this.func_70099_a(new ItemStack(JungleBlocks.wallSkull, 1), 0.0f);
                }
            }
            for (int i = 0; i < 20; ++i) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(30.0, 30.0, 30.0))) {
                entityplayer.func_71029_a((StatBase)JungleAchievements.slainWall);
            }
            new bookScale(Items.field_151164_bB);
            ItemStack stack = bookScale.northScale;
            this.func_70099_a(stack, 0.0f);
            if (this.getWallSpawnType() == 1) {
                JungleSaveWorld.get(this.field_70170_p).wallSpawnCount(0);
            }
        }
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        for (int i = 0; i < 3; ++i) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)f, this.field_70163_u + (double)f1 + 2.5, this.field_70161_v + (double)f2, new ItemStack(Blocks.field_150341_Y, 1)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        switch (par1) {
            case 30: {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                this.animationTimer = 20;
                break;
            }
            case 32: {
                this.animationTimer = 40;
                this.effectTimer = 60;
                break;
            }
            case 31: {
                this.animationTimer = 20;
                break;
            }
            case 33: {
                this.animationTimer = 60;
                this.effectTimer = 60;
                break;
            }
            case 34: {
                this.animationTimer = 10;
            }
            default: {
                super.func_70103_a(par1);
            }
        }
    }

    private void calculateHealth() {
        float priorHealth = this.func_110138_aP();
        List lt2 = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(30.0, 30.0, 30.0));
        int additional = lt2.size() == 0 ? 0 : (lt2.size() - 1) * 150;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(200 + additional));
        this.func_70606_j(this.func_110143_aJ() / priorHealth * this.func_110138_aP());
        if (this.field_70173_aa % 40 == 0) {
            float h = lt2.size() > 0 ? (float)lt2.size() : 1.0f;
            this.func_70691_i(h);
        }
    }

    public int getAttackStatus() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_STATUS);
    }

    public void setAttackStatus() {
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.animationTimer == 0) {
            this.field_70180_af.func_187227_b(ATTACK_STATUS, (Object)0);
        }
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187835_fT;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 10.0f, -10.0f);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public BlockPos getAttackerPosX() {
        return (BlockPos)this.field_70180_af.func_187225_a(ATTACKER_POS);
    }

    @SideOnly(value=Side.CLIENT)
    public int getAnimationTimer() {
        return this.animationTimer;
    }

    public int getWallSpawnType() {
        return ((Byte)this.field_70180_af.func_187225_a(WALL_SPAWN_TYPE)).byteValue();
    }

    public void setWallSpawnType(int p_82201_1_) {
        this.field_70180_af.func_187227_b(WALL_SPAWN_TYPE, (Object)((byte)p_82201_1_));
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("WallSpawnType", 99)) {
            byte b0 = p_70037_1_.func_74771_c("WallSpawnType");
            this.setWallSpawnType(b0);
        }
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
        p_70014_1_.func_74774_a("WallSpawnType", (byte)this.getWallSpawnType());
    }
}

