/*
 * Decompiled with CFR 0.152.
 */
package com.salvestrom.w2theJungle.mobs.entity;

import com.salvestrom.w2theJungle.init.JungleAchievements;
import com.salvestrom.w2theJungle.init.JungleBlocks;
import com.salvestrom.w2theJungle.init.JungleItems;
import com.salvestrom.w2theJungle.items.bookScale;
import com.salvestrom.w2theJungle.mobs.entity.EntityLizardmanBase;
import com.salvestrom.w2theJungle.mobs.entity.EntityMistSpider;
import com.salvestrom.w2theJungle.mobs.entity.EntitySacrificialSkeleton;
import com.salvestrom.w2theJungle.mobs.entity.EntityStoneGolem;
import com.salvestrom.w2theJungle.mobs.entity.ai.EntityAISecondaryAttack;
import com.salvestrom.w2theJungle.w2theJungle;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLenny
extends EntityMob
implements IEntityMultiPart,
IRangedAttackMob {
    private static final DataParameter<Byte> LENNY_SPAWN_TYPE = EntityDataManager.func_187226_a(EntityLenny.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<BlockPos> ATTACKER_POS = EntityDataManager.func_187226_a(EntityLenny.class, (DataSerializer)DataSerializers.field_187200_j);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    public Class[] classlist = new Class[]{EntityLizardmanBase.class, EntityStoneGolem.class, EntityWitch.class, EntityVillager.class, EntityIronGolem.class, EntityEnderman.class, EntityMistSpider.class};
    public int animationTimer;
    private int effectTimer;
    public int tremorTimer;
    public int roarAnimationTimer;
    public int attackTimer;
    public int smashTimer;
    public int field_70757_a;
    public int breakingtime;
    private EntityDragonPart[] lennyNaughtyParts;
    public EntityDragonPart lennyNeck;
    public EntityDragonPart lennyTail4;
    public EntityDragonPart lennyTail5;
    public boolean slowed;
    public float minRange = 6.0f;
    public boolean isRoaring;
    public int roarTimer;
    public int attacktype;
    public int add;
    public Entity attacker;

    public EntityLenny(World p_i1745_1_) {
        super(p_i1745_1_);
        this.func_70105_a(2.5f, 4.0f);
        this.field_70138_W = 1.5f;
        this.field_70178_ae = true;
        this.field_70728_aV = 150;
        this.field_70158_ak = true;
        this.field_70144_Y = 0.95f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.lennyNeck = new EntityDragonPart((IEntityMultiPart)this, "neck", 2.5f, 1.5f);
        this.lennyTail4 = new EntityDragonPart((IEntityMultiPart)this, "tailSeg4", 2.0f, 1.0f);
        this.lennyTail5 = new EntityDragonPart((IEntityMultiPart)this, "tailSeg5", 2.0f, 1.0f);
        this.lennyNaughtyParts = new EntityDragonPart[]{this.lennyNeck, this.lennyTail4, this.lennyTail5};
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LENNY_SPAWN_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(ATTACKER_POS, (Object)new BlockPos((Entity)this));
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISecondaryAttack(this, 0.3, 40, 40.0f, this.minRange));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.33, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.3));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.4, 30.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, IMob.field_82192_a));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityBat.class, 0, true, false, IMob.field_82192_a));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLizardmanBase.class, 0, true, false, IMob.field_82192_a));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityStoneGolem.class, 0, true, false, IMob.field_82192_a));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWitch.class, 2, true, false, IMob.field_82192_a));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 2, true, false, IMob.field_82192_a));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, 2, true, false, IMob.field_82192_a));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityEnderman.class, 2, true, false, IMob.field_82192_a));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMistSpider.class, 1, true, false, IMob.field_82192_a));
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
    }

    public int func_70658_aO() {
        return this.lowHealth() ? 6 : 9;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && super.func_70601_bi() && this.field_70170_p.field_73011_w.getDimension() == w2theJungle.dimensionIdLost;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getLennySpawnType() == 1) {
            this.func_175449_a(new BlockPos(34, 40, 0), 15);
        } else {
            this.func_175449_a(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), 30);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.walkEffect(1);
        this.destroyBlocksInAABB(this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0), -1);
        if (this.field_70757_a > 200 + this.field_70146_Z.nextInt(100)) {
            this.func_184185_a(SoundEvents.field_187594_A, 0.8f, 0.01f);
            this.field_70757_a = 0;
        } else {
            ++this.field_70757_a;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.roarTimer < 0 && this.func_70638_az() == null && !this.field_70171_ac && this.field_70725_aQ == 0) {
                this.func_184185_a(SoundEvents.field_187600_C, 8.0f, 0.05f);
                this.func_184185_a(SoundEvents.field_187532_aV, 8.0f, 0.05f);
                this.func_184185_a(SoundEvents.field_187525_aO, 8.75f, 0.001f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)11);
                this.roarTimer = 1200 + this.field_70146_Z.nextInt(600);
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
                for (int i = 0; i < 2; ++i) {
                    List lt = this.field_70170_p.func_72872_a(EntitySacrificialSkeleton.class, this.func_174813_aQ().func_72314_b(10.0, 0.0, 10.0));
                    if (lt.size() >= 8) continue;
                    this.wakeTheDamned();
                }
            } else {
                --this.roarTimer;
            }
        }
        if (this.effectTimer > 0) {
            this.field_70702_br = 0.0f;
            this.field_70701_bs = 0.0f;
            this.smashEffect();
            if (this.attacktype == 4) {
                List mobs;
                if (this.effectTimer % 8 == 0) {
                    int d = 8 - this.effectTimer / 8;
                    this.tremble(this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(4.0, 0.0, 4.0)), d);
                    this.func_184185_a(SoundEvents.field_187605_cG, 16.0f, 0.1f);
                }
                if (this.effectTimer % 50 == 0 && (mobs = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(12.0, 3.0, 12.0))) != null) {
                    for (int i = 0; i < mobs.size(); ++i) {
                        Entity mob = (Entity)mobs.get(i);
                        if (!(mob instanceof EntityPlayer) || ((EntityPlayer)mob).field_71075_bZ.field_75098_d) continue;
                        this.wakeTheDamned();
                    }
                }
            }
            --this.effectTimer;
        }
        if (this.smashTimer > 0) {
            --this.smashTimer;
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.tremorTimer > 0) {
            --this.tremorTimer;
        }
        if (this.animationTimer > 0) {
            --this.animationTimer;
        }
        if (this.roarAnimationTimer > 0) {
            --this.roarAnimationTimer;
        }
        if (this.slowed) {
            this.field_70159_w *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.isSwimming()) {
            this.field_70159_w *= 1.1480000001192092;
            this.field_70179_y *= 1.140000001192093;
        } else {
            this.field_70159_w *= 1.0;
            this.field_70179_y *= 1.0;
        }
        double mo = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        float rads = 57.29578f;
        float x = (float)(Math.sin(this.field_70761_aq / rads) * 2.5);
        float z = (float)(Math.cos(this.field_70761_aq / rads) * 2.5);
        this.lennyTail5.func_70071_h_();
        this.lennyTail5.func_70012_b(this.field_70165_t + (double)x, this.field_70163_u + 2.0 + mo * 20.0 + (this.roarAnimationTimer > 0 ? 1.25 : 0.0), this.field_70161_v - (double)z, 0.0f, 0.0f);
        x = (float)(Math.sin(this.field_70761_aq / rads) * 5.075);
        z = (float)(Math.cos(this.field_70761_aq / rads) * 5.075);
        this.lennyTail4.func_70071_h_();
        this.lennyTail4.func_70012_b(this.field_70165_t + (double)x, this.field_70163_u + 1.5 + mo * 20.0 + (this.roarAnimationTimer > 0 ? 2.0 : 0.0), this.field_70161_v - (double)z, 0.0f, 0.0f);
        x = (float)(Math.sin(this.field_70761_aq / rads) * 3.5);
        z = (float)(Math.cos(this.field_70761_aq / rads) * 3.5);
        this.lennyNeck.func_70071_h_();
        this.lennyNeck.func_70012_b(this.field_70165_t - (double)x, this.field_70163_u + 4.0 + (double)(this.roarAnimationTimer > 0 ? -1 : 0), this.field_70161_v + (double)z, 0.0f, 0.0f);
        AxisAlignedBB[] len = new AxisAlignedBB[]{this.lennyTail4.func_174813_aQ(), this.lennyTail5.func_174813_aQ()};
        for (int l = 0; l < len.length; ++l) {
            if (this.field_70170_p.field_72995_K) continue;
            this.tailWhip(this.field_70170_p.func_72839_b((Entity)this, len[l]), len[l]);
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean bl = this.slowed = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_177230_c() == JungleBlocks.mudBlock;
            if (this.lowHealth() && this.field_70173_aa % 140 == 0 && this.field_70725_aQ == 0) {
                float additional;
                List lt = this.field_70170_p.func_72872_a(EntitySacrificialSkeleton.class, this.func_174813_aQ().func_72314_b(10.0, 0.0, 10.0));
                List lt2 = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(30.0, 30.0, 30.0));
                float f = additional = lt2.size() == 0 ? 1.0f : (float)lt2.size() * 0.75f;
                if (lt.size() > 0) {
                    int j = this.field_70146_Z.nextInt(lt.size());
                    EntitySacrificialSkeleton nttss = (EntitySacrificialSkeleton)((Object)lt.get(j));
                    float hmod = nttss.func_110143_aJ();
                    if (lt.get(j) != null) {
                        this.func_70606_j(this.func_110143_aJ() + hmod * additional);
                        this.func_70604_c((EntityLivingBase)nttss);
                        this.func_184185_a(SoundEvents.field_187856_fd, 1.0f, 1.0f);
                        nttss.func_70606_j(0.0f);
                    }
                }
            }
        }
        if (this.field_70173_aa % 20 != 0 || this.field_70170_p.field_72995_K || this.func_70638_az() != null) {
            // empty if block
        }
        this.calculateHealth();
    }

    public void walkEffect(int l) {
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.5000002779052E-7 && this.field_70146_Z.nextInt(l) == 0) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - this.func_70033_W()));
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            Block block = this.field_70170_p.func_180495_p(new BlockPos(i, j, k)).func_177230_c();
            IBlockState iblock = this.field_70170_p.func_180495_p(new BlockPos(i, j, k));
            if (block.func_176223_P().func_185904_a() != Material.field_151579_a) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblock)});
            }
        }
    }

    public void wakeTheDamned() {
        if (!this.field_70170_p.field_72995_K) {
            EntitySacrificialSkeleton aid = new EntitySacrificialSkeleton(this.field_70170_p);
            aid.func_70012_b(this.field_70165_t - 5.0 + (double)this.field_70146_Z.nextInt(10), this.field_70163_u + 1.0, this.field_70161_v - 5.0 + (double)this.field_70146_Z.nextInt(10), 0.0f, 0.0f);
            aid.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            this.field_70170_p.func_72838_d((Entity)aid);
            this.func_184185_a(SoundEvents.field_187864_fh, 0.5f, 1.0f);
            aid.func_70656_aK();
        }
    }

    public void func_70653_a(Entity p_70653_1_, float p_70653_2_, double p_70653_3_, double p_70653_5_) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70701_bs = 0.0f;
            this.field_70702_br = 0.0f;
        }
    }

    public boolean func_70652_k(Entity ntt) {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0));
        this.attacker = ntt;
        this.field_70180_af.func_187227_b(ATTACKER_POS, (Object)new BlockPos(this.attacker));
        float dm = this.field_70170_p.func_175659_aa().func_151525_a();
        if ((double)this.func_70032_d(ntt) < 6.5) {
            float dmg;
            if (this.tremorTimer <= 0 && list != null) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)32);
                this.attacktype = 4;
                this.attackTimer = 60;
                this.tremorTimer = 300;
                this.effectTimer = 60;
                this.smashTimer += 100;
                float dmg2 = 1.0f;
                return false;
            }
            if (this.smashTimer == 0) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)33);
                dmg = 15.0f;
                this.attacktype = 1;
            } else if (this.attackTimer == 0) {
                this.attacktype = 2;
                dmg = 5.0f;
                this.field_70170_p.func_72960_a((Entity)this, (byte)34);
            } else {
                float dmg3 = 1.0f;
                return false;
            }
            dmg = dmg + 10.0f + (float)this.field_70146_Z.nextInt((int)dmg / 3) + dm * 0.11f + (float)this.field_70146_Z.nextGaussian() * 0.5f;
            boolean flag = ntt.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), dmg * 0.9f);
            if (flag) {
                ntt.field_70172_ad = 0;
                ntt.func_70097_a(DamageSource.field_76377_j, dmg * 0.1f);
                if (this.attacktype == 1) {
                    ntt.field_70181_x += (double)0.4f;
                    ntt.field_70179_y = -0.3000000059604645;
                    ntt.field_70159_w = -0.3000000059604645;
                    this.func_184185_a(SoundEvents.field_187600_C, 1.0f, 0.25f);
                    this.func_184185_a(SoundEvents.field_187532_aV, 1.0f, 0.25f);
                    this.smashTimer = (int)(100.0 + (double)dmg * 2.5);
                } else if (this.attacktype == 2) {
                    this.attackTimer = 30;
                    this.func_184185_a(SoundEvents.field_187899_gZ, 1.7f, 0.5f);
                }
            } else {
                flag = false;
            }
            return flag;
        }
        return false;
    }

    public void func_82196_d(EntityLivingBase nttlb, float rangeMod) {
        float f3 = this.func_70032_d((Entity)nttlb);
        List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0));
        Iterator it = moblist.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof EntitySacrificialSkeleton)) continue;
            it.remove();
        }
        if (this.tremorTimer <= 0 && moblist.size() > 3) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)32);
            this.attacktype = 4;
            this.attackTimer = 60;
            this.tremorTimer = 300;
            this.effectTimer = 60;
            this.smashTimer += 100;
        }
        if (f3 >= this.minRange && !this.lowHealth()) {
            this.attacktype = 3;
            this.field_70170_p.func_72960_a((Entity)this, (byte)35);
            float a = 0.75f + (1.0f - rangeMod) + ((float)(this.field_70146_Z.nextGaussian() * 0.25) + (float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f) + (float)(nttlb instanceof EntityBat ? 15 : 0);
            nttlb.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), a);
            nttlb.field_70172_ad = 0;
            nttlb.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this), a);
            this.func_184185_a(SoundEvents.field_187646_bt, 5.0f, 0.21f);
            this.attacker = nttlb;
            this.field_70180_af.func_187227_b(ATTACKER_POS, (Object)new BlockPos(this.attacker));
        } else {
            this.func_70652_k((Entity)nttlb);
        }
    }

    public void tremble(List<?> list, int d) {
        this.field_70702_br = 0.0f;
        this.field_70701_bs = 0.0f;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLivingBase)) continue;
            float dm = this.field_70170_p.func_175659_aa().func_151525_a();
            float d2 = (float)(2 * d) + dm * 1.5f + 0.5f;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), d2 * 0.9f);
            entity.field_70172_ad = 0;
            entity.func_70097_a(DamageSource.field_76377_j, d2 * 0.1f);
        }
    }

    private void tailWhip(List<?> p_70970_1_, AxisAlignedBB len) {
        double d0 = (len.field_72340_a + len.field_72336_d) / 2.0;
        double d1 = (len.field_72339_c + len.field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (entity instanceof EntityPlayerMP && !((EntityPlayerMP)entity).field_71075_bZ.field_75098_d) {
                return;
            }
            if (!(entity instanceof EntityLivingBase)) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 1.2, (double)0.2f, d3 / d4 * 1.2);
            this.func_184185_a(SoundEvents.field_187605_cG, 10.0f, 0.1f);
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.field_70170_p.func_175659_aa().func_151525_a() * 1.5f);
            entity.field_70172_ad = 0;
            entity.func_70097_a(DamageSource.field_76377_j, (float)this.field_70170_p.func_175659_aa().func_151525_a() * 1.5f);
        }
    }

    private void smashEffect() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - this.func_70033_W()));
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(i, j, k);
        int a = 5;
        for (int x = -a; x < a; ++x) {
            for (int z = -a; z < a; ++z) {
                if (x * x + z * z >= 25) continue;
                Block block = this.field_70170_p.func_180495_p(pos.func_177982_a(x, 0, z)).func_177230_c();
                IBlockState iblock = this.field_70170_p.func_180495_p(pos.func_177982_a(x, 0, z));
                if (block.func_176223_P().func_185904_a() == Material.field_151579_a) continue;
                double px = this.field_70165_t + (double)x + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N;
                double pz = this.field_70161_v + (double)z + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N;
                EnumParticleTypes st = EnumParticleTypes.BLOCK_CRACK;
                this.field_70170_p.func_175688_a(st, px, (double)(j + 1) + 0.1, pz, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblock)});
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        switch (par1) {
            case 11: {
                this.roarAnimationTimer = 80;
                break;
            }
            case 32: {
                this.attacktype = 4;
                this.animationTimer = 40;
                this.effectTimer = 60;
                break;
            }
            case 33: {
                this.attacktype = 1;
                this.animationTimer = 20;
                break;
            }
            case 34: {
                this.attacktype = 2;
                this.animationTimer = 20;
                break;
            }
            case 35: {
                this.attacktype = 3;
                this.animationTimer = 20;
                break;
            }
            default: {
                super.func_70103_a(par1);
            }
        }
    }

    public int func_70641_bl() {
        return 1;
    }

    private void destroyBlocksInAABB(AxisAlignedBB abba, int imod) {
        int waymaker = (int)((float)this.breakingtime / 5.0f * 10.0f);
        int minX = MathHelper.func_76128_c((double)abba.field_72340_a);
        int minY = MathHelper.func_76128_c((double)abba.field_72338_b);
        int minZ = MathHelper.func_76128_c((double)abba.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)abba.field_72336_d);
        int maxY = MathHelper.func_76128_c((double)abba.field_72337_e) + imod;
        int maxZ = MathHelper.func_76128_c((double)abba.field_72334_f);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState iblock = this.field_70170_p.func_180495_p(pos);
                    Block block = iblock.func_177230_c();
                    if (block != Blocks.field_150362_t && block != Blocks.field_150321_G && block != Blocks.field_150347_e && !(block.func_149638_a((Entity)this) < 6.0f) || block == Blocks.field_150350_a || block == Blocks.field_150346_d) continue;
                    this.field_70170_p.func_175715_c(this.func_145782_y(), pos, waymaker);
                    if (this.breakingtime > 5) {
                        this.breakingtime = 0;
                        SoundEvent se = block == Blocks.field_150362_t ? SoundEvents.field_187571_bR : (block instanceof BlockStone ? SoundEvents.field_187835_fT : SoundEvents.field_187881_gQ);
                        this.func_184185_a(se, 1.0f, 0.7f);
                        for (int i = 0; i < 20; ++i) {
                            EnumParticleTypes part = EnumParticleTypes.BLOCK_DUST;
                            this.field_70170_p.func_175688_a(part, (double)x + (double)(this.field_70146_Z.nextFloat() * 2.0f) - 1.0, (double)y + (double)this.field_70146_Z.nextFloat(), (double)z + (double)(this.field_70146_Z.nextFloat() * 2.0f) - 1.0, 0.2502 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.25, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.2502, new int[]{Block.func_176210_f((IBlockState)iblock)});
                        }
                        this.field_70170_p.func_175698_g(new BlockPos(x, y, z));
                        continue;
                    }
                    ++this.breakingtime;
                }
            }
        }
    }

    public boolean canEntityDestroy(World worldObj, Block block, EntityLenny entityLenny) {
        return block == Blocks.field_150417_aV;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(EntityDragonPart dpart, DamageSource dsource, float ddmg) {
        if (dpart == this.lennyNeck) {
            ddmg = (float)((double)ddmg * 1.2);
        }
        if (dpart == this.lennyTail4) {
            ddmg = (float)((double)ddmg * 0.7);
        }
        if (dpart == this.lennyTail5) {
            ddmg = (float)((double)ddmg * 0.85);
        }
        this.func_82195_e(dsource, ddmg);
        return true;
    }

    protected boolean func_82195_e(DamageSource p_82195_1_, float p_82195_2_) {
        return this.func_70097_a(p_82195_1_, p_82195_2_);
    }

    public Entity[] func_70021_al() {
        return this.lennyNaughtyParts;
    }

    public void calculateHealth() {
        float priorHealth = this.func_110138_aP();
        List lt2 = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(30.0, 30.0, 30.0));
        int additional = lt2.size() == 0 ? 0 : (lt2.size() - 1) * 175;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(350 + additional));
        this.func_70606_j(this.func_110143_aJ() / priorHealth * this.func_110138_aP());
        if (this.field_70173_aa % 40 == 0) {
            this.func_70691_i(lt2.size() > 0 ? (float)lt2.size() : 1.0f);
        }
    }

    public boolean func_70687_e(PotionEffect p_70687_1_) {
        return p_70687_1_.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(p_70687_1_);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        Entity ntt;
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (p_70097_1_ == DamageSource.field_76369_e) {
            return false;
        }
        if (this.lowHealth() && ((ntt = p_70097_1_.func_76364_f()) instanceof EntityArrow || ntt instanceof EntityThrowable)) {
            return false;
        }
        ntt = p_70097_1_.func_76346_g();
        if (ntt instanceof EntityPlayer && this.func_70032_d(ntt) > 20.0f || ntt instanceof EntitySacrificialSkeleton) {
            return false;
        }
        List mobs = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(12.0, 3.0, 12.0));
        if (mobs != null) {
            for (int i = 0; i < mobs.size(); ++i) {
                EntitySacrificialSkeleton ss;
                Entity mob = (Entity)mobs.get(i);
                ntt = p_70097_1_.func_76346_g();
                if (!(mob instanceof EntitySacrificialSkeleton) || (ss = (EntitySacrificialSkeleton)mob).func_70638_az() != null || this.func_70638_az() instanceof EntitySacrificialSkeleton || !(ntt instanceof EntityLivingBase)) continue;
                ss.func_70604_c((EntityLivingBase)ntt);
            }
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    private boolean lowHealth() {
        return this.func_110143_aJ() < this.func_110138_aP() / 2.0f;
    }

    protected void func_70609_aI() {
        int j;
        ++this.field_70725_aQ;
        if (this.field_70725_aQ > 10 && this.field_70725_aQ < 20) {
            this.func_184185_a(SoundEvents.field_187600_C, 5.0f, 0.05f);
            this.func_184185_a(SoundEvents.field_187532_aV, 5.0f, 0.05f);
            this.func_184185_a(SoundEvents.field_187525_aO, 5.75f, 0.001f);
            double t0 = this.field_70146_Z.nextGaussian() * 0.02;
            double t1 = this.field_70146_Z.nextGaussian() * 0.02;
            double t2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.5f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.5f) - (double)this.field_70130_N, t0, t1, t2, new int[0]);
            this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
        }
        if (this.field_70725_aQ >= 80 && this.field_70725_aQ % 5 == 0 && !this.field_70170_p.field_72995_K && (this.field_70718_bc > 0 || this.func_70684_aJ()) && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            for (int i = this.func_70693_a(this.field_70717_bb) / 3; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t + (double)f, this.field_70163_u + (double)f1 + 2.0, this.field_70161_v + (double)f2, j));
            }
        }
        if (this.field_70725_aQ == 110) {
            this.func_184185_a(SoundEvents.field_187594_A, 4.0f, 0.01f);
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                if (this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v)).func_185904_a().func_76220_a() && this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)) == Blocks.field_150350_a) {
                    this.field_70170_p.func_175656_a(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), JungleBlocks.tyrantSkull.func_176223_P());
                } else {
                    this.func_70099_a(new ItemStack(JungleBlocks.tyrantSkull, 1), 0.0f);
                }
                for (int i = this.func_70693_a(this.field_70717_bb); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            for (int i = 0; i < 20; ++i) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 50.0, 50.0))) {
                entityplayer.func_71029_a((StatBase)JungleAchievements.slainTyrant);
            }
            this.func_70099_a(new ItemStack((Item)JungleItems.eyeT, 1), 0.0f);
        }
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        float f2;
        float f1;
        float f;
        int i;
        new bookScale(Items.field_151164_bB);
        ItemStack stack = bookScale.southScale;
        this.func_70099_a(stack, 0.0f);
        for (i = 0; i < 9; ++i) {
            f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)f, this.field_70163_u + (double)f1 + 1.5, this.field_70161_v + (double)f2, new ItemStack(Items.field_151078_bh, 1)));
        }
        for (i = 0; i < 7; ++i) {
            f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)f, this.field_70163_u + (double)f1 + 1.5, this.field_70161_v + (double)f2, new ItemStack(JungleItems.carvedBone, 1)));
        }
    }

    public BlockPos getAttacker() {
        return (BlockPos)this.field_70180_af.func_187225_a(ATTACKER_POS);
    }

    @SideOnly(value=Side.CLIENT)
    public int getAnimationTimer() {
        return this.animationTimer;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRoarAnimationTimer() {
        return this.roarAnimationTimer;
    }

    public int getAttType() {
        return this.attacktype;
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v)).func_177230_c() == Blocks.field_150355_j;
    }

    public boolean isSwimming() {
        return this.field_70171_ac && (this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v)).func_177230_c() == Blocks.field_150355_j || this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v)).func_177230_c() == Blocks.field_150358_i);
    }

    public int getLivingSoundTime() {
        return this.field_70757_a;
    }

    public boolean isMovementCeased() {
        return this.roarAnimationTimer > 0 || this.animationTimer > 0;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (!this.isSwimming()) {
            this.func_184185_a(SoundEvents.field_187605_cG, 10.0f, 0.001f);
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public int getLennySpawnType() {
        return ((Byte)this.field_70180_af.func_187225_a(LENNY_SPAWN_TYPE)).byteValue();
    }

    public void setLennySpawnType(int p_82201_1_) {
        this.field_70180_af.func_187227_b(LENNY_SPAWN_TYPE, (Object)((byte)p_82201_1_));
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("LennySpawnType", 99)) {
            byte b0 = p_70037_1_.func_74771_c("LennySpawnType");
            this.setLennySpawnType(b0);
        }
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
        p_70014_1_.func_74774_a("LennySpawnType", (byte)this.getLennySpawnType());
    }
}

