/*
 * Decompiled with CFR 0.152.
 */
package com.salvestrom.w2theJungle;

import com.salvestrom.w2theJungle.init.JungleBlocks;
import com.salvestrom.w2theJungle.w2theJungle;
import com.salvestrom.w2theJungle.worldGen.JungleSaveWorld;
import com.salvestrom.w2theJungle.worldGen.biome.JungleBiomeRegistry;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.biome.BiomeMesa;
import net.minecraft.world.biome.BiomeRiver;
import net.minecraft.world.biome.BiomeSwamp;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class JungleFogEvent {
    public int checkdim;
    public World world;
    public Minecraft mc;
    public EntityPlayer player;
    public float old = 0.5f;
    public float oldc = 45.0f;
    public float oldr = 120.0f;
    public float oldred;
    public float oldgreen;
    public float oldblue;

    @SubscribeEvent
    public void setWorld(WorldEvent.Load wel) {
        this.world = wel.getWorld();
        this.old = JungleSaveWorld.get((World)this.world).fogvar1;
        this.oldc = JungleSaveWorld.get((World)this.world).fogvar2;
        this.oldr = JungleSaveWorld.get((World)this.world).fogvar3;
    }

    @SubscribeEvent
    public void setPlayer(PlayerEvent pe) {
        this.player = pe.getEntityPlayer();
    }

    @SubscribeEvent
    public void loadWorldFog(WorldEvent.Load wel) {
    }

    @SubscribeEvent
    public void unloadWorldFog(WorldEvent.Unload weu) {
        float[] f = new float[]{this.old, this.oldc, this.oldr};
        JungleSaveWorld.get(this.world).fogValues(f);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void JungleFog(EntityViewRenderEvent.FogDensity e) {
        e.setCanceled(true);
        int x = (int)e.getEntity().field_70165_t;
        e.getEntity();
        int z = (int)e.getEntity().field_70161_v;
        Biome bio = this.world.func_180494_b(new BlockPos(x, 0, z));
        this.checkdim = this.world.field_73011_w.getDimension();
        int fir = 400;
        int sec = 401;
        this.mc = Minecraft.func_71410_x();
        int seer = this.mc.field_71474_y.field_151451_c * 16;
        float eden = this.old;
        float cannon = this.oldc;
        float far = this.oldr;
        float yen = (float)Math.abs(Math.pow((e.getEntity().field_70163_u - 53.0) / 202.0, 3.0));
        if (e.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase elb = (EntityLivingBase)e.getEntity();
            if (elb.func_70644_a(MobEffects.field_76440_q)) {
                GL11.glFogi((int)2917, (int)9729);
                eden = 0.0f;
                cannon = 0.0f;
                far = 5.0f;
                int j = elb.func_70660_b(MobEffects.field_76440_q).func_76459_b();
                if (j < 20) {
                    far = 5.0f + ((float)seer - 5.0f) * (1.0f - (float)j / 20.0f);
                }
            } else if (e.getState().func_177230_c() == JungleBlocks.mudBlock) {
                GL11.glFogi((int)2917, (int)2048);
                cannon = this.oldc;
                far = this.oldr;
                eden = elb.func_70644_a(MobEffects.field_76427_o) ? 0.6f : 1.2f - (float)EnchantmentHelper.func_185292_c((EntityLivingBase)elb) * 0.12f;
            } else if (e.getState().func_185904_a() == Material.field_151586_h) {
                GL11.glFogi((int)2917, (int)2048);
                cannon = this.oldc;
                far = this.oldr;
                eden = elb.func_70644_a(MobEffects.field_76427_o) ? 0.05f : 0.1f - (float)EnchantmentHelper.func_185292_c((EntityLivingBase)elb) * 0.03f;
            } else if (e.getState().func_185904_a() == Material.field_151587_i) {
                GL11.glFogi((int)2917, (int)2048);
                cannon = this.oldc;
                far = this.oldr;
                eden = 2.0f;
            } else if (bio != null) {
                if (bio instanceof BiomeRiver) {
                    GL11.glFogi((int)2917, (int)9729);
                    eden = this.old;
                    cannon = this.oldc;
                    far = this.oldr;
                } else if (bio == JungleBiomeRegistry.biomeJungleMountain) {
                    GL11.glFogi((int)2917, (int)9729);
                    float near = 0.09f;
                    float farr = 0.35f;
                    if ((double)this.world.func_72971_b(1.0f) < 0.45) {
                        near = 0.45f;
                        farr = 0.7f;
                    }
                    eden = (float)Math.abs(Math.pow((elb.field_70163_u - 63.0) / 192.0, 4.0));
                    cannon = (this.oldc * (float)fir + (float)seer * near) / (float)sec - eden;
                    far = (this.oldr * (float)fir + (float)seer * farr) / (float)sec - eden;
                } else if (bio == JungleBiomeRegistry.biomeJungleSwamp || bio instanceof BiomeSwamp) {
                    GL11.glFogi((int)2917, (int)9729);
                    float near = 0.0f;
                    float farr = 30.0f;
                    if ((double)this.world.func_72971_b(1.0f) < 0.45) {
                        near = 0.0f;
                        farr = 60.0f;
                    }
                    eden = 0.01f;
                    cannon = (this.oldc * (float)fir + near) / (float)sec + yen;
                    far = (float)(((double)(this.oldr * (float)fir) + ((double)farr + elb.field_70163_u - 63.0)) / (double)sec) + yen;
                    if (far < 15.0f) {
                        far = 15.0f;
                    }
                } else if (this.world.func_72896_J()) {
                    float wi = this.world.func_72867_j(1.0f);
                    GL11.glFogi((int)2917, (int)9729);
                    eden = 0.25f;
                    cannon = (this.oldc * (float)fir + 0.0f) / (float)sec;
                    far = (this.oldr * (float)fir + (float)seer / 1.25f / wi) / (float)sec;
                    if (this.world.func_72911_I()) {
                        far = (this.oldr * (float)fir + (float)(seer / 2) / wi) / (float)sec;
                    }
                    WorldClient wc = this.mc.field_71441_e;
                    int temp = wc.func_175725_q(new BlockPos(elb.field_70165_t, 0.0, elb.field_70161_v)).func_177956_o();
                    float f9 = bio.func_180626_a(new BlockPos(elb.field_70165_t, elb.field_70163_u, elb.field_70161_v));
                    if (wc.func_72959_q().func_76939_a(f9, temp) <= 0.15f) {
                        far = (this.oldr * (float)fir + (float)(seer / 3) / wi) / (float)sec;
                    }
                    if (bio instanceof BiomeDesert || bio instanceof BiomeMesa) {
                        eden = (this.old * (float)fir + 0.005f) / (float)sec;
                        cannon = (this.oldc * (float)fir + 1.0f) / (float)sec;
                        far = (this.oldr * (float)fir + 25.0f / wi) / (float)sec;
                    }
                } else if (this.checkdim == w2theJungle.dimensionIdLost) {
                    GL11.glFogi((int)2917, (int)9729);
                    eden = 0.01f;
                    cannon = (this.oldc * (float)fir + 0.0f) / (float)sec + yen * 2.0f;
                    far = (float)((double)(this.oldr * (float)fir + 20.0f) + elb.field_70163_u) / (float)sec + yen * 10.0f;
                    if (far < 15.0f) {
                        // empty if block
                    }
                } else if (this.checkdim < 0) {
                    GL11.glFogi((int)2917, (int)9729);
                    eden = (this.old * (float)fir + 0.001f) / (float)sec;
                    cannon = (this.oldc * (float)fir + 0.0f) / (float)sec;
                    far = (this.oldr * (float)fir + (float)seer * 0.8f) / (float)sec;
                } else if (this.checkdim > 0) {
                    GL11.glFogi((int)2917, (int)9729);
                    eden = (this.old * (float)fir + 0.001f) / (float)sec;
                    cannon = (this.oldc * (float)fir + (float)seer * 0.75f) / (float)sec;
                    far = (this.oldr * (float)fir + (float)seer) / (float)sec;
                } else if (this.checkdim == 0) {
                    GL11.glFogi((int)2917, (int)9729);
                    eden = (this.old * (float)fir + 0.001f) / (float)sec;
                    cannon = (this.oldc * (float)fir + (float)seer * 0.75f) / (float)sec;
                    far = (this.oldr * (float)fir + (float)seer) / (float)sec;
                } else {
                    eden = this.old;
                    cannon = this.oldc;
                    far = this.oldr;
                }
            } else {
                eden = this.old;
                cannon = this.oldc;
                far = this.oldr;
            }
        }
        if (GLContext.getCapabilities().GL_NV_fog_distance) {
            GL11.glFogi((int)34138, (int)34139);
        }
        GL11.glFogf((int)2915, (float)cannon);
        GL11.glFogf((int)2916, (float)far);
        GL11.glEnable((int)2903);
        GL11.glColorMaterial((int)1028, (int)4608);
        e.setDensity(eden);
        this.old = eden;
        this.oldc = cannon;
        this.oldr = far;
        if (this.oldr > (float)seer) {
            this.oldr = seer;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void fogColourEvent(EntityViewRenderEvent.FogColors e) {
        boolean light = (double)this.world.func_72971_b(1.0f) > 0.475;
        float potdur = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)this.player) * 0.2f;
        float scaler = 250.0f;
        float scales = 251.0f;
        if (this.player != null) {
            float bc2;
            float gc2;
            float rc2;
            float bc;
            float gc;
            float rc;
            Biome bio = this.world.func_180494_b(new BlockPos(this.player.field_70165_t, 0.0, this.player.field_70161_v));
            if ((bio instanceof BiomeDesert || bio instanceof BiomeMesa) && light) {
                rc = this.calcFogColour(this.oldred, 0.71f);
                gc = (this.oldgreen * scaler + 0.8f) / scales;
                bc = (this.oldblue * scaler + 0.8f) / scales;
            } else if (this.checkdim == -1) {
                rc = this.calcFogColour(this.oldred, 0.1f);
                gc = this.calcFogColour(this.oldgreen, 0.01f);
                bc = this.calcFogColour(this.oldblue, 0.01f);
            } else if (this.checkdim == 1) {
                rc = this.calcFogColour(this.oldred, 0.0752f);
                gc = this.calcFogColour(this.oldgreen, 0.0521067f);
                bc = this.calcFogColour(this.oldblue, 0.07525f);
            } else if (!(!light || this.checkdim != 0 || this.world.func_72896_J() && this.world.func_72911_I())) {
                rc = (this.oldred * scaler + 0.68f) / scales;
                gc = (this.oldgreen * scaler + 0.8f) / scales;
                bc = (this.oldblue * scaler + 1.0f) / scales;
                if (this.player.field_70163_u < 53.0) {
                    rc = (float)(((double)(this.oldred * scaler) + 0.7 - (1.0 - this.player.field_70163_u / 80.0)) / (double)scales);
                    gc = (float)(((double)(this.oldgreen * scaler) + 0.7 - (1.0 - this.player.field_70163_u / 80.0)) / (double)scales);
                    bc = (float)(((double)(this.oldblue * scaler) + 0.7 - (1.0 - this.player.field_70163_u / 80.0)) / (double)scales);
                }
            } else if (!light) {
                rc = this.calcFogColour(this.oldred, 0.04016818f);
                gc = this.calcFogColour(this.oldgreen, 0.045189206f);
                bc = this.calcFogColour(this.oldblue, 0.08002f);
            } else {
                rc = (this.oldred * scaler + e.getRed()) / scales;
                gc = (this.oldgreen * scaler + e.getGreen()) / scales;
                bc = (this.oldblue * scaler + e.getBlue()) / scales;
                if (this.player.field_70163_u < 53.0) {
                    rc = (float)(((double)(this.oldred * scaler) + 0.7 - (1.0 - this.player.field_70163_u / 80.0)) / (double)scales);
                    gc = (float)(((double)(this.oldgreen * scaler) + 0.7 - (1.0 - this.player.field_70163_u / 80.0)) / (double)scales);
                    bc = (float)(((double)(this.oldblue * scaler) + 0.7 - (1.0 - this.player.field_70163_u / 80.0)) / (double)scales);
                }
            }
            e.setRed(rc);
            e.setGreen(gc);
            e.setBlue(bc);
            if (e.getState().func_177230_c() == JungleBlocks.mudBlock) {
                rc2 = 0.62f + potdur;
                gc2 = 0.47f + potdur;
                bc2 = 0.3f + potdur;
            } else if (e.getState().func_185904_a() == Material.field_151587_i) {
                rc2 = 0.6f;
                gc2 = 0.1f;
                bc2 = 0.0f;
            } else if (e.getState().func_185904_a() == Material.field_151586_h) {
                rc2 = 0.02f + potdur;
                gc2 = 0.02f + potdur;
                bc2 = 0.2f + potdur;
                if (bio == JungleBiomeRegistry.biomeJungleSwamp || bio == JungleBiomeRegistry.lostJungle) {
                    rc2 = 0.1f + potdur;
                    gc2 = 0.34f + potdur;
                    bc2 = 0.12f + potdur;
                }
            } else {
                rc2 = this.oldred;
                gc2 = this.oldgreen;
                bc2 = this.oldblue;
            }
            e.setRed(rc2);
            e.setGreen(gc2);
            e.setBlue(bc2);
            this.oldred = rc;
            this.oldgreen = gc;
            this.oldblue = bc;
        }
    }

    public float calcFogColour(float old, float goal) {
        int scaler = 250;
        int scales = 251;
        return (old * (float)scaler + goal) / (float)scales;
    }
}

