/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.tile;

import com.teamwizardry.librarianlib.common.base.block.TileMod;
import com.teamwizardry.librarianlib.common.util.autoregister.TileRegister;
import com.teamwizardry.librarianlib.common.util.saving.Save;
import com.teamwizardry.refraction.api.Utils;
import com.teamwizardry.refraction.api.beam.Beam;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import org.jetbrains.annotations.NotNull;

@TileRegister(value="spectrometer")
public class TileSpectrometer
extends TileMod
implements ITickable {
    @Save
    public Color maxColor = new Color(0, 0, 0, 0);
    public Color currentColor = new Color(0, 0, 0, 0);
    @NotNull
    private List<Beam> lastTickBeams = new ArrayList<Beam>();
    @NotNull
    private List<Beam> beams = new ArrayList<Beam>();

    public void readCustomNBT(NBTTagCompound compound) {
        this.currentColor = new Color(compound.func_74762_e("current_color"), true);
    }

    public void writeCustomNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("current_color", this.currentColor.getRGB());
    }

    public void handle(Beam beam) {
        for (Beam beam2 : this.beams) {
            if (!beam2.doBeamsMatch(beam)) continue;
            return;
        }
        this.beams.add(beam);
        this.func_70296_d();
    }

    public boolean noChangeInBeams() {
        if (this.beams.size() != this.lastTickBeams.size()) {
            return false;
        }
        for (Beam beam : this.lastTickBeams) {
            boolean flag = false;
            for (Beam beam2 : this.beams) {
                if (!beam.doBeamsMatch(beam2)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.currentColor.getRGB() != this.maxColor.getRGB()) {
            this.currentColor = Utils.mixColors(this.currentColor, this.maxColor, 0.9);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            this.func_70296_d();
        }
        if (this.beams.isEmpty()) {
            this.maxColor = new Color(0, 0, 0, 0);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            this.func_70296_d();
        } else if (!this.noChangeInBeams()) {
            int red = 0;
            int green = 0;
            int blue = 0;
            int alpha = 0;
            for (Beam beam : this.beams) {
                Color color = beam.color;
                red = (int)((float)red + (float)color.getRed() * ((float)color.getAlpha() / 255.0f));
                green = (int)((float)green + (float)color.getGreen() * ((float)color.getAlpha() / 255.0f));
                blue = (int)((float)blue + (float)color.getBlue() * ((float)color.getAlpha() / 255.0f));
                alpha += color.getAlpha();
            }
            red = Math.min(red / this.beams.size(), 255);
            green = Math.min(green / this.beams.size(), 255);
            blue = Math.min(blue / this.beams.size(), 255);
            float[] hsbvals = Color.RGBtoHSB(red, green, blue, null);
            Color color = new Color(Color.HSBtoRGB(hsbvals[0], hsbvals[1], 1.0f));
            if ((color = new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.min(alpha, 255))).getRGB() == this.maxColor.getRGB()) {
                return;
            }
            this.maxColor = color;
        }
        this.lastTickBeams.clear();
        this.lastTickBeams.addAll(this.beams);
        this.beams.clear();
        this.func_70296_d();
    }
}

