/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.tile;

import com.teamwizardry.librarianlib.common.util.EnumBiFacing;
import com.teamwizardry.librarianlib.common.util.autoregister.TileRegister;
import com.teamwizardry.refraction.api.MultipleBeamTile;
import com.teamwizardry.refraction.api.PosUtils;
import com.teamwizardry.refraction.api.RotationHelper;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.modes.BeamMode;
import com.teamwizardry.refraction.common.block.BlockOpticFiber;
import com.teamwizardry.refraction.init.ModBlocks;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@TileRegister(value="reflection_chamber")
public class TileReflectionChamber
extends MultipleBeamTile
implements ITickable {
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K || this.beams.isEmpty()) {
            return;
        }
        for (BeamMode mode : this.beamData.keySet()) {
            Set beamSet = this.beamData.get((Object)mode);
            ArrayList<Vec3d> angles = new ArrayList<Vec3d>();
            angles.addAll(beamSet.stream().map(beam -> beam.slope).collect(Collectors.toList()));
            Vec3d outputDir = RotationHelper.averageDirection(angles);
            Color color = this.mergeColors(mode);
            Beam beam2 = new Beam(this.field_145850_b, new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), outputDir, color).setMode(mode);
            EnumFacing facing = EnumFacing.func_176737_a((float)((float)beam2.slope.field_72450_a), (float)((float)beam2.slope.field_72448_b), (float)((float)beam2.slope.field_72449_c));
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing));
            if (state.func_177230_c() == ModBlocks.OPTIC_FIBER && ((EnumBiFacing)state.func_177229_b(BlockOpticFiber.FACING)).contains(facing)) {
                beam2.setSlope(PosUtils.getVecFromFacing(facing)).spawn();
                continue;
            }
            beam2.spawn();
        }
        this.purge();
    }
}

