/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.tile;

import com.teamwizardry.librarianlib.common.base.block.TileMod;
import com.teamwizardry.librarianlib.common.util.autoregister.TileRegister;
import com.teamwizardry.librarianlib.common.util.math.Matrix4;
import com.teamwizardry.librarianlib.common.util.saving.Save;
import com.teamwizardry.refraction.api.beam.Beam;
import java.awt.Color;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@TileRegister(value="mirror")
public class TileMirror
extends TileMod
implements ITickable {
    @Save
    public float rotXUnpowered;
    @Save
    public float rotYUnpowered;
    @Save
    public float rotXPowered = Float.NaN;
    @Save
    public float rotYPowered = Float.NaN;
    @Save
    public float rotDestX;
    @Save
    public float rotPrevX;
    @Save
    public float rotDestY;
    @Save
    public float rotPrevY;
    @Save
    public boolean transitionX = false;
    @Save
    public boolean transitionY = false;
    @Save
    public boolean powered = false;
    @Save
    public long worldTime = 0L;
    public Beam[] beams;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public float getRotX() {
        return this.rotDestX;
    }

    public void setRotX(float rotX) {
        if (this.transitionX) {
            return;
        }
        if (rotX == this.rotDestX) {
            return;
        }
        this.rotPrevX = this.rotDestX;
        this.rotDestX = rotX;
        this.transitionX = true;
        this.worldTime = this.field_145850_b.func_82737_E();
        this.func_70296_d();
    }

    public float getRotY() {
        return this.rotDestY;
    }

    public void setRotY(float rotY) {
        if (this.transitionY) {
            return;
        }
        if (rotY == this.rotDestY) {
            return;
        }
        this.rotPrevY = this.rotDestY;
        this.rotDestY = rotY;
        this.transitionY = true;
        this.worldTime = this.field_145850_b.func_82737_E();
        this.func_70296_d();
    }

    public void handle(Beam ... beams) {
        this.beams = beams;
        if (beams.length == 0) {
            return;
        }
        if (this.transitionX || this.transitionY) {
            return;
        }
        Matrix4 matrix = new Matrix4();
        matrix.rotate(Math.toRadians(this.getRotY()), new Vec3d(0.0, 1.0, 0.0));
        matrix.rotate(Math.toRadians(this.getRotX()), new Vec3d(1.0, 0.0, 0.0));
        Vec3d normal = matrix.apply(new Vec3d(0.0, 1.0, 0.0));
        for (Beam beam : beams) {
            Vec3d incomingDir = beam.finalLoc.func_178788_d(beam.initLoc).func_72432_b();
            if (incomingDir.func_72430_b(normal) > 0.0) continue;
            Vec3d outgoingDir = incomingDir.func_178788_d(normal.func_186678_a(incomingDir.func_72430_b(normal) * 2.0));
            Color c = new Color(beam.color.getRed(), beam.color.getGreen(), beam.color.getBlue(), (int)((double)beam.color.getAlpha() / 1.05));
            beam.createSimilarBeam(outgoingDir).setColor(c).enableParticleBeginning().spawn();
        }
    }

    public void func_73660_a() {
        double transitionTimeMaxX = Math.max(3.0, Math.min(Math.abs((double)(this.rotPrevX - this.rotDestX) / 2.0), 15.0));
        double transitionTimeMaxY = Math.max(3.0, Math.min(Math.abs((double)(this.rotPrevY - this.rotDestY) / 2.0), 15.0));
        double worldTimeTransition = this.field_145850_b.func_82737_E() - this.worldTime;
        float rotX = this.rotDestX;
        float rotY = this.rotDestY;
        if (this.transitionX) {
            if (worldTimeTransition < transitionTimeMaxX) {
                rotX = Math.round(this.rotDestX) > Math.round(this.rotPrevX) ? -((this.rotDestX - this.rotPrevX) / 2.0f) * MathHelper.func_76134_b((float)((float)(worldTimeTransition * Math.PI / transitionTimeMaxX))) + (this.rotDestX + this.rotPrevX) / 2.0f : (this.rotPrevX - this.rotDestX) / 2.0f * MathHelper.func_76134_b((float)((float)(worldTimeTransition * Math.PI / transitionTimeMaxX))) + (this.rotDestX + this.rotPrevX) / 2.0f;
            } else {
                rotX = this.rotDestX;
                if (this.powered) {
                    this.rotXPowered = rotX;
                } else {
                    this.rotXUnpowered = rotX;
                }
                this.transitionX = false;
                this.func_70296_d();
            }
        }
        if (this.transitionY) {
            if (worldTimeTransition < transitionTimeMaxY) {
                rotY = Math.round(this.rotDestY) > Math.round(this.rotPrevY) ? -((this.rotDestY - this.rotPrevY) / 2.0f) * MathHelper.func_76134_b((float)((float)(worldTimeTransition * Math.PI / transitionTimeMaxY))) + (this.rotDestY + this.rotPrevY) / 2.0f : (this.rotPrevY - this.rotDestY) / 2.0f * MathHelper.func_76134_b((float)((float)(worldTimeTransition * Math.PI / transitionTimeMaxY))) + (this.rotDestY + this.rotPrevY) / 2.0f;
            } else {
                rotY = this.rotDestY;
                if (this.powered) {
                    this.rotYPowered = rotY;
                } else {
                    this.rotYUnpowered = rotY;
                }
                this.transitionY = false;
                this.func_70296_d();
            }
        }
        if ((this.transitionX || this.transitionY) && this.beams != null) {
            if (this.beams.length != 0) {
                Matrix4 matrix = new Matrix4();
                matrix.rotate(Math.toRadians(rotY), new Vec3d(0.0, 1.0, 0.0));
                matrix.rotate(Math.toRadians(rotX), new Vec3d(1.0, 0.0, 0.0));
                Vec3d normal = matrix.apply(new Vec3d(0.0, 1.0, 0.0));
                for (Beam beam : this.beams) {
                    Vec3d incomingDir = beam.finalLoc.func_178788_d(beam.initLoc).func_72432_b();
                    if (incomingDir.func_72430_b(normal) > 0.0) continue;
                    Vec3d outgoingDir = incomingDir.func_178788_d(normal.func_186678_a(incomingDir.func_72430_b(normal) * 2.0));
                    Color c = new Color(beam.color.getRed(), beam.color.getGreen(), beam.color.getBlue(), (int)((double)beam.color.getAlpha() / 1.05));
                    beam.createSimilarBeam(outgoingDir).setColor(c).enableParticleBeginning().spawn();
                }
            }
        } else {
            this.beams = null;
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean powered) {
        if (!this.transitionX && !this.transitionY) {
            this.powered = powered;
            if (powered) {
                if (!Float.isNaN(this.rotXPowered) && this.rotDestX != this.rotXPowered) {
                    this.setRotX(this.rotXPowered);
                }
                if (!Float.isNaN(this.rotYPowered) && this.rotDestY != this.rotYPowered) {
                    this.setRotY(this.rotYPowered);
                }
            } else {
                if (!Float.isNaN(this.rotXUnpowered) && this.rotDestX != this.rotXUnpowered) {
                    this.setRotX(this.rotXUnpowered);
                }
                if (!Float.isNaN(this.rotYUnpowered) && this.rotDestY != this.rotYUnpowered) {
                    this.setRotY(this.rotYUnpowered);
                }
            }
        }
    }
}

