/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.tile;

import com.teamwizardry.librarianlib.common.base.block.TileMod;
import com.teamwizardry.librarianlib.common.util.autoregister.TileRegister;
import com.teamwizardry.refraction.api.ConfigValues;
import com.teamwizardry.refraction.api.PosUtils;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.modes.BeamModeRegistry;
import com.teamwizardry.refraction.common.caps.DualEnergyStorage;
import java.awt.Color;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import org.jetbrains.annotations.NotNull;

@TileRegister(value="electric_laser")
public class TileElectricLaser
extends TileMod
implements ITickable {
    public DualEnergyStorage energy = new DualEnergyStorage(ConfigValues.MAX_TESLA, ConfigValues.TESLA_PER_TICK * 2, ConfigValues.TESLA_PER_TICK);

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (this.canFire()) {
            Vec3d center = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            EnumFacing face = (EnumFacing)world.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockDirectional.field_176387_N);
            Vec3d vec = PosUtils.getVecFromFacing(face);
            Color color = new Color(255, 255, 255, ConfigValues.ELECTRIC_ALPHA);
            new Beam(world, center, vec, color).setMode(BeamModeRegistry.EFFECT).spawn();
            this.energy.extractEnergy(ConfigValues.TESLA_PER_TICK, false);
        }
    }

    public boolean canFire() {
        World world = this.func_145831_w();
        return !world.field_72995_K && !world.func_175640_z(this.field_174879_c) && world.func_175687_A(this.field_174879_c) == 0 && this.energy.extractEnergy(ConfigValues.TESLA_PER_TICK, true) == ConfigValues.TESLA_PER_TICK;
    }

    public void readCustomNBT(NBTTagCompound compound) {
        this.energy.deserializeNBT(compound.func_74775_l("energy"));
    }

    public void writeCustomNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74782_a("energy", (NBTBase)this.energy.serializeNBT());
    }

    public boolean getUseFastSync() {
        return false;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @NotNull EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == DualEnergyStorage.CAPABILITY_CONSUMER || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@NotNull Capability<T> capability, @NotNull EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY || capability == DualEnergyStorage.CAPABILITY_CONSUMER ? this.energy : super.getCapability(capability, facing));
    }
}

