/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.tile;

import com.teamwizardry.librarianlib.common.util.autoregister.TileRegister;
import com.teamwizardry.librarianlib.common.util.math.Matrix4;
import com.teamwizardry.refraction.api.ConfigValues;
import com.teamwizardry.refraction.api.MultipleBeamTile;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.common.block.BlockDiscoBall;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TileRegister(value="disco_ball")
public class TileDiscoBall
extends MultipleBeamTile
implements ITickable {
    @NotNull
    public Set<Color> colors = new HashSet<Color>();
    @NotNull
    private HashMap<Beam, Integer> beamlifes = new HashMap();
    @Nullable
    private Matrix4 matrix;

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.colors.clear();
        NBTTagList array = compound.func_150295_c("colors", 3);
        for (int i = 0; i < array.func_74745_c(); ++i) {
            this.colors.add(new Color(array.func_186858_c(i)));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound, boolean sync) {
        super.writeCustomNBT(compound, sync);
        if (!this.colors.isEmpty()) {
            NBTTagList array = new NBTTagList();
            for (Color color : this.colors) {
                array.func_74742_a((NBTBase)new NBTTagInt(color.getRGB()));
            }
            compound.func_74782_a("colors", (NBTBase)array);
        }
    }

    @Override
    public void handleBeam(Beam beam) {
        super.handleBeam(beam);
        if (this.field_145850_b.func_175687_A(this.field_174879_c) == 0 && !this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        if (beam.customName.equals("disco_ball_beam")) {
            return;
        }
        if (this.beamlifes.size() > 20) {
            return;
        }
        if (!this.colors.contains(beam.color)) {
            this.colors.add(beam.color);
        }
        double radius = 5.0;
        double rotX = ThreadLocalRandom.current().nextDouble(0.0, 360.0);
        double rotZ = ThreadLocalRandom.current().nextDouble(0.0, 360.0);
        int x = (int)(radius * (double)MathHelper.func_76134_b((float)((float)Math.toRadians(rotX))));
        int z = (int)(radius * (double)MathHelper.func_76126_a((float)((float)Math.toRadians(rotZ))));
        Vec3d dest = new Vec3d((double)x, (double)ThreadLocalRandom.current().nextInt(-5, 5), (double)z);
        Vec3d center = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d(((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockDiscoBall.FACING)).func_176730_m()).func_186678_a(0.2));
        Beam subBeam = beam.createSimilarBeam(center, dest).setColor(new Color(beam.color.getRed(), beam.color.getGreen(), beam.color.getBlue(), (int)((double)beam.color.getAlpha() / ThreadLocalRandom.current().nextDouble(2.0, 4.0)))).setAllowedBounceTimes(ConfigValues.DISCO_BALL_BEAM_BOUNCE_LIMIT).setName("disco_ball_beam");
        this.beamlifes.put(subBeam, 0);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_175687_A(this.field_174879_c) == 0 && !this.field_145850_b.func_175640_z(this.field_174879_c)) {
            this.purge();
            return;
        }
        if (this.matrix == null) {
            this.matrix = new Matrix4();
            this.matrix.rotate(Math.toRadians(5.0), new Vec3d(((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockDiscoBall.FACING)).func_176734_d().func_176730_m()));
        }
        ArrayList<Beam> modes = new ArrayList<Beam>(this.beamlifes.keySet());
        boolean match = false;
        Color colorMatched = null;
        block0: for (Beam beam : modes) {
            if (this.beamlifes.get(beam) >= 20) {
                this.beamlifes.remove(beam);
                continue;
            }
            this.beamlifes.put(beam, this.beamlifes.get(beam) + 1);
            beam.setSlope(this.matrix.apply(beam.slope));
            beam.spawn();
            for (Color color : this.colors) {
                if (color.getRed() == beam.color.getRed() && color.getGreen() == beam.color.getGreen() && color.getBlue() == beam.color.getBlue()) continue;
                colorMatched = color;
                match = true;
                continue block0;
            }
        }
        if (match) {
            this.colors.remove(colorMatched);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        this.purge();
    }
}

