/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.tile;

import com.teamwizardry.librarianlib.common.network.PacketHandler;
import com.teamwizardry.librarianlib.common.util.CommonUtilMethods;
import com.teamwizardry.librarianlib.common.util.autoregister.TileRegister;
import com.teamwizardry.librarianlib.common.util.saving.Save;
import com.teamwizardry.refraction.api.EventAssemblyTableCraft;
import com.teamwizardry.refraction.api.MultipleBeamTile;
import com.teamwizardry.refraction.api.beam.modes.BeamMode;
import com.teamwizardry.refraction.api.beam.modes.ModeEffect;
import com.teamwizardry.refraction.api.recipe.AssemblyBehaviors;
import com.teamwizardry.refraction.api.recipe.IAssemblyBehavior;
import com.teamwizardry.refraction.common.network.PacketAssemblyDoneParticles;
import com.teamwizardry.refraction.common.network.PacketAssemblyProgressParticles;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TileRegister(value="assembly_table")
public class TileAssemblyTable
extends MultipleBeamTile
implements ITickable {
    @Nullable
    public IAssemblyBehavior behavior;
    @NotNull
    public ItemStackHandler output = new ItemStackHandler(1){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TileAssemblyTable.this.behavior != null) {
                return null;
            }
            return super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileAssemblyTable.this.func_70296_d();
        }
    };
    @NotNull
    public ItemStackHandler inventory = new ItemStackHandler(54){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (TileAssemblyTable.this.output.getStackInSlot(0) != null && TileAssemblyTable.this.output.getStackInSlot((int)0).field_77994_a > 0) {
                return stack;
            }
            if (TileAssemblyTable.this.behavior != null) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TileAssemblyTable.this.output.getStackInSlot(0) != null && TileAssemblyTable.this.output.getStackInSlot((int)0).field_77994_a > 0) {
                return null;
            }
            if (TileAssemblyTable.this.behavior != null) {
                return null;
            }
            return super.extractItem(slot, amount, simulate);
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            TileAssemblyTable.this.func_70296_d();
        }
    };
    @Save
    public int craftingTime = 0;

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        this.behavior = (IAssemblyBehavior)AssemblyBehaviors.getBehaviors().get((Object)cmp.func_74779_i("behavior"));
        this.inventory.deserializeNBT(cmp.func_74775_l("items"));
        this.output.deserializeNBT(cmp.func_74775_l("output"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp, boolean sync) {
        if (this.behavior != null) {
            cmp.func_74778_a("behavior", (String)AssemblyBehaviors.getBehaviors().inverse().get((Object)this.behavior));
        }
        cmp.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        cmp.func_74782_a("output", (NBTBase)this.output.serializeNBT());
    }

    public void readCustomBytes(ByteBuf buf) {
        this.behavior = CommonUtilMethods.hasNullSignature((ByteBuf)buf) ? null : (IAssemblyBehavior)AssemblyBehaviors.getBehaviors().get((Object)CommonUtilMethods.readString((ByteBuf)buf));
        this.inventory.deserializeNBT(CommonUtilMethods.readTag((ByteBuf)buf));
        this.output.deserializeNBT(CommonUtilMethods.readTag((ByteBuf)buf));
    }

    public void writeCustomBytes(ByteBuf buf, boolean sync) {
        if (this.behavior == null) {
            CommonUtilMethods.writeNullSignature((ByteBuf)buf);
        } else {
            CommonUtilMethods.writeNonnullSignature((ByteBuf)buf);
            CommonUtilMethods.writeString((ByteBuf)buf, (String)((String)AssemblyBehaviors.getBehaviors().inverse().get((Object)this.behavior)));
        }
        CommonUtilMethods.writeTag((ByteBuf)buf, (NBTTagCompound)this.inventory.serializeNBT());
        CommonUtilMethods.writeTag((ByteBuf)buf, (NBTTagCompound)this.output.serializeNBT());
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @NotNull EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @NotNull
    public <T> T getCapability(@NotNull Capability<T> capability, @NotNull EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? (facing == EnumFacing.DOWN ? this.output : this.inventory) : super.getCapability(capability, facing));
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K || this.beams.isEmpty()) {
            return;
        }
        if (!this.field_145850_b.func_175640_z(this.func_174877_v()) && this.field_145850_b.func_175687_A(this.func_174877_v()) == 0) {
            return;
        }
        HashSet<Color> colors = new HashSet<Color>();
        for (BeamMode mode : this.beamData.keySet()) {
            if (!mode.getClass().isAssignableFrom(ModeEffect.class)) continue;
            colors.add(this.mergeColors(mode));
        }
        this.purge();
        Color color = this.mergeColors(colors);
        if (this.behavior != null) {
            if (this.behavior.tick(color, (IItemHandlerModifiable)this.inventory, (IItemHandlerModifiable)this.output, this.craftingTime++)) {
                PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketAssemblyProgressParticles(this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 30.0));
            } else {
                EventAssemblyTableCraft eventAssemblyTableCraft = new EventAssemblyTableCraft(this.field_145850_b, this.field_174879_c, this.output.getStackInSlot(0));
                MinecraftForge.EVENT_BUS.post((Event)eventAssemblyTableCraft);
                this.behavior = null;
                PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketAssemblyDoneParticles(this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 30.0));
            }
            this.func_70296_d();
            return;
        }
        for (IAssemblyBehavior recipe : AssemblyBehaviors.getBehaviors().values()) {
            if (!recipe.canAccept(color, (IItemHandler)this.inventory)) continue;
            this.craftingTime = 0;
            this.behavior = recipe;
            this.func_70296_d();
            break;
        }
    }
}

