/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.network;

import com.teamwizardry.librarianlib.client.fx.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.client.fx.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.client.fx.particle.functions.InterpFadeInOut;
import com.teamwizardry.librarianlib.common.network.PacketBase;
import com.teamwizardry.librarianlib.common.util.DimWithPos;
import com.teamwizardry.librarianlib.common.util.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.common.util.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.common.util.math.interpolate.position.InterpBezier3D;
import com.teamwizardry.refraction.Refraction;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Pair;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketAXYZMarks
extends PacketBase {
    public static final Map<DimWithPos, Pair<Vec3d, Vec3d>> controlPoints = new HashMap<DimWithPos, Pair<Vec3d, Vec3d>>();
    private BlockPos[] positions;
    private BlockPos[] originPositions;
    private int dimension;

    public PacketAXYZMarks() {
    }

    public PacketAXYZMarks(BlockPos[] positions, BlockPos[] origins, int dimension) {
        this.positions = positions;
        this.originPositions = origins;
        this.dimension = dimension;
    }

    public void handle(MessageContext ctx) {
        if (ctx.side.isServer()) {
            return;
        }
        World world = Refraction.proxy.getWorld();
        if (world.field_73011_w.getDimension() != this.dimension) {
            return;
        }
        for (int i = 0; i < this.positions.length; ++i) {
            BlockPos pos = this.positions[i];
            BlockPos origin = this.originPositions[i];
            double range = 5.0;
            controlPoints.putIfAbsent(new DimWithPos(world.field_73011_w.getDimension(), origin), (Pair<Vec3d, Vec3d>)new Pair((Object)new Vec3d(ThreadLocalRandom.current().nextDouble(-range, range), ThreadLocalRandom.current().nextDouble(-range, range), ThreadLocalRandom.current().nextDouble(-range, range)), (Object)new Vec3d(ThreadLocalRandom.current().nextDouble(-range, range), ThreadLocalRandom.current().nextDouble(-range, range), ThreadLocalRandom.current().nextDouble(-range, range))));
            boolean isAir = world.func_175623_d(pos);
            ParticleBuilder wormholeVoid = new ParticleBuilder(10);
            ParticleSpawner.spawn((ParticleBuilder)wormholeVoid, (World)world, (InterpFunction)new StaticInterp((Object)new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5)), (int)ThreadLocalRandom.current().nextInt(isAir ? 5 : 10, isAir ? 10 : 20), (int)0, (aFloat, particleBuilder) -> {
                wormholeVoid.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.2f, 0.2f));
                wormholeVoid.setRenderNormalLayer(new ResourceLocation("refraction", "particles/glow"));
                double radius = 0.4;
                double theta = (float)Math.PI * 2 * ThreadLocalRandom.current().nextFloat();
                double r = radius * (double)ThreadLocalRandom.current().nextFloat() + (isAir ? 0.0 : 0.5);
                double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                wormholeVoid.setPositionOffset(new Vec3d(x, 0.0, z));
                int rnd = ThreadLocalRandom.current().nextInt(0, 40);
                wormholeVoid.setColor(new Color(rnd, 0, rnd));
                wormholeVoid.setScale((float)ThreadLocalRandom.current().nextDouble(1.0, 2.0));
                wormholeVoid.setMotion(Vec3d.field_186680_a);
            });
            ParticleBuilder wormholeHalo = new ParticleBuilder(15);
            ParticleSpawner.spawn((ParticleBuilder)wormholeHalo, (World)world, (InterpFunction)new StaticInterp((Object)new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5)), (int)ThreadLocalRandom.current().nextInt(isAir ? 5 : 20, isAir ? 10 : 30), (int)0, (aFloat, particleBuilder) -> {
                wormholeHalo.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.2f, 0.2f));
                wormholeHalo.setRender(new ResourceLocation("refraction", "particles/glow"));
                double r = isAir ? 0.5 : 1.0;
                double theta = (float)Math.PI * 2 * ThreadLocalRandom.current().nextFloat();
                double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                wormholeHalo.setPositionOffset(new Vec3d(x, 0.0, z));
                wormholeHalo.setColor(new Color(72, 119, 122));
                wormholeHalo.setScale((float)ThreadLocalRandom.current().nextDouble(1.0, 2.0));
            });
            ParticleBuilder generatorHalo = new ParticleBuilder(10);
            ParticleSpawner.spawn((ParticleBuilder)generatorHalo, (World)world, (InterpFunction)new StaticInterp((Object)new Vec3d((Vec3i)origin).func_72441_c(0.5, 0.5, 0.5)), (int)ThreadLocalRandom.current().nextInt(5, 10), (int)0, (aFloat, particleBuilder) -> {
                generatorHalo.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.3f, 0.3f));
                generatorHalo.setRender(new ResourceLocation("refraction", "particles/glow"));
                double r = 0.5;
                double theta = (float)Math.PI * 2 * ThreadLocalRandom.current().nextFloat();
                double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                generatorHalo.setPositionOffset(new Vec3d(x, 0.0, z));
                generatorHalo.setColor(new Color(72, 119, 122));
                generatorHalo.setScale((float)ThreadLocalRandom.current().nextDouble(1.0, 2.0));
            });
            controlPoints.keySet().stream().filter(dimWithPos -> dimWithPos.getPos().func_177986_g() == origin.func_177986_g()).filter(dimWithPos -> ThreadLocalRandom.current().nextInt(5) == 0).forEachOrdered(dimWithPos -> {
                Pair<Vec3d, Vec3d> pair = controlPoints.get(dimWithPos);
                double shift = ThreadLocalRandom.current().nextDouble(0.1, 0.5);
                double p1r1 = ((Vec3d)pair.getFirst()).field_72450_a + ThreadLocalRandom.current().nextDouble(-shift, shift);
                double p1r2 = ((Vec3d)pair.getFirst()).field_72448_b + ThreadLocalRandom.current().nextDouble(-shift, shift);
                double p1r3 = ((Vec3d)pair.getFirst()).field_72449_c + ThreadLocalRandom.current().nextDouble(-shift, shift);
                Vec3d p1 = new Vec3d(p1r1 <= 2.0 ? p1r1 : ((Vec3d)pair.getFirst()).field_72450_a, p1r2 <= 2.0 ? p1r2 : ((Vec3d)pair.getFirst()).field_72448_b, p1r3 <= 2.0 ? p1r3 : ((Vec3d)pair.getFirst()).field_72449_c);
                double p2r1 = ((Vec3d)pair.getSecond()).field_72450_a + ThreadLocalRandom.current().nextDouble(-shift, shift);
                double p2r2 = ((Vec3d)pair.getSecond()).field_72448_b + ThreadLocalRandom.current().nextDouble(-shift, shift);
                double p2r3 = ((Vec3d)pair.getSecond()).field_72449_c + ThreadLocalRandom.current().nextDouble(-shift, shift);
                Vec3d p2 = new Vec3d(p2r1 <= 2.0 ? p2r1 : ((Vec3d)pair.getSecond()).field_72450_a, p2r2 <= 2.0 ? p2r2 : ((Vec3d)pair.getSecond()).field_72448_b, p2r3 <= 2.0 ? p2r3 : ((Vec3d)pair.getSecond()).field_72449_c);
                controlPoints.put((DimWithPos)dimWithPos, (Pair<Vec3d, Vec3d>)new Pair((Object)p1, (Object)p2));
                ParticleBuilder connection = new ParticleBuilder(30);
                ParticleSpawner.spawn((ParticleBuilder)connection, (World)world, (InterpFunction)new StaticInterp((Object)new Vec3d((Vec3i)origin).func_72441_c(0.5, 0.5, 0.5)), (int)ThreadLocalRandom.current().nextInt(1, 5), (int)0, (aFloat, particleBuilder) -> {
                    connection.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.2f, 0.2f));
                    connection.setRender(new ResourceLocation("refraction", "particles/glow"));
                    Vec3d sub = new Vec3d((Vec3i)pos.func_177973_b((Vec3i)origin));
                    connection.setPositionFunction((InterpFunction)new InterpBezier3D(Vec3d.field_186680_a, sub, (Vec3d)controlPoints.get(dimWithPos).getFirst(), (Vec3d)controlPoints.get(dimWithPos).getSecond()));
                    connection.setColor(new Color(72, 119, 122));
                    connection.setScale((float)ThreadLocalRandom.current().nextDouble(1.0, 2.0));
                });
            });
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.positions.length);
        for (int i = 0; i < this.positions.length; ++i) {
            buf.writeLong(this.positions[i].func_177986_g());
            buf.writeLong(this.originPositions[i].func_177986_g());
        }
        buf.writeInt(this.dimension);
    }

    public void fromBytes(ByteBuf buf) {
        int len = buf.readInt();
        this.positions = new BlockPos[len];
        this.originPositions = new BlockPos[len];
        for (int i = 0; i < len; ++i) {
            this.positions[i] = BlockPos.func_177969_a((long)buf.readLong());
            this.originPositions[i] = BlockPos.func_177969_a((long)buf.readLong());
        }
        this.dimension = buf.readInt();
    }
}

