/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.mt;

import com.teamwizardry.refraction.api.recipe.AssemblyBehaviors;
import com.teamwizardry.refraction.api.recipe.AssemblyRecipe;
import com.teamwizardry.refraction.api.recipe.IAssemblyBehavior;
import com.teamwizardry.refraction.common.mt.MTRefractionPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Pair;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.refraction.AssemblyTable")
public class AssemblyTable {
    protected static final String name = "Refraction Assembly Table";

    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient[] input, int minAlpha, int maxAlpha, int minRed, int maxRed, int minGreen, int maxGreen, int minBlue, int maxBlue) {
        if (minAlpha < 0 || maxAlpha < 0 || minRed < 0 || maxRed < 0 || minGreen < 0 || maxGreen < 0 || minBlue < 0 || maxBlue < 0) {
            return;
        }
        if (minAlpha > 255 || maxAlpha > 255 || minRed > 255 || maxRed > 255 || minGreen > 255 || maxGreen > 255 || minBlue > 255 || maxBlue > 255) {
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(name, new AssemblyRecipe(MTRefractionPlugin.toStack(output), minRed, minGreen, minBlue, minAlpha, maxRed, maxGreen, maxBlue, maxAlpha, MTRefractionPlugin.toObjects(input))));
    }

    @ZenMethod
    public static void remove(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MTRefractionPlugin.toStack(output)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<Pair<String, AssemblyRecipe>> toRemove = new ArrayList<Pair<String, AssemblyRecipe>>();

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.toRemove.clear();
            this.toRemove.addAll(AssemblyBehaviors.getBehaviors().values().stream().filter(recipe -> recipe instanceof AssemblyRecipe).filter(recipe -> OreDictionary.itemMatches((ItemStack)((AssemblyRecipe)recipe).getResult(), (ItemStack)this.output, (boolean)true)).map(recipe -> new Pair(AssemblyBehaviors.getBehaviors().inverse().get(recipe), (Object)((AssemblyRecipe)recipe))).collect(Collectors.toList()));
            this.toRemove.forEach(obj -> {
                IAssemblyBehavior cfr_ignored_0 = (IAssemblyBehavior)AssemblyBehaviors.getBehaviors().remove(obj.component1());
            });
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.output);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Removing Assembly Table recipes for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Re-adding Assembly Table recipes for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            this.toRemove.forEach(recipe -> {
                IAssemblyBehavior cfr_ignored_0 = (IAssemblyBehavior)AssemblyBehaviors.getBehaviors().put(recipe.component1(), recipe.component2());
            });
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.output);
        }
    }

    private static class Add
    implements IUndoableAction {
        private final AssemblyRecipe recipe;
        private String name;

        public Add(String name, AssemblyRecipe recipe) {
            this.name = name;
            this.recipe = recipe;
        }

        public void apply() {
            AssemblyBehaviors.getBehaviors().put((Object)("zen:" + this.name), (Object)this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Adding Assembly Table recipe for " + this.recipe.getResult().func_82833_r();
        }

        public String describeUndo() {
            return "Removing Assembly Table recipe for " + this.recipe.getResult().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            AssemblyBehaviors.getBehaviors().remove((Object)("zen:" + this.name));
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe);
        }
    }
}

