/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.item;

import com.teamwizardry.librarianlib.client.util.ColorUtils;
import com.teamwizardry.librarianlib.common.base.item.IItemColorProvider;
import com.teamwizardry.librarianlib.common.base.item.ItemMod;
import com.teamwizardry.librarianlib.common.util.ItemNBTHelper;
import com.teamwizardry.refraction.api.IAmmo;
import com.teamwizardry.refraction.api.IAmmoConsumer;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.modes.BeamModeRegistry;
import java.awt.Color;
import kotlin.jvm.functions.Function2;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPhotonCannon
extends ItemMod
implements IAmmoConsumer,
IItemColorProvider {
    public ItemPhotonCannon() {
        super("photon_cannon", new String[0]);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("refraction", "firing"), (stack, worldIn, entityIn) -> entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f);
    }

    @NotNull
    public EnumAction func_77661_b(ItemStack stack) {
        if (ItemNBTHelper.getInt((ItemStack)stack, (String)"color", (int)-1) == -1 || GuiScreen.func_175283_s()) {
            return EnumAction.NONE;
        }
        return EnumAction.BOW;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public int func_77626_a(ItemStack stack) {
        return 1000;
    }

    @Nullable
    public ItemStack func_77654_b(@NotNull ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase playerIn, int count) {
        if (!(playerIn instanceof EntityPlayer)) {
            return;
        }
        if (stack.func_77978_p() == null) {
            return;
        }
        if (!stack.func_77978_p().func_74764_b("color")) {
            return;
        }
        Color color = new Color(ItemNBTHelper.getInt((ItemStack)stack, (String)"color", (int)0xFFFFFF), true);
        ItemStack ammo = IAmmoConsumer.findAmmo((EntityPlayer)playerIn, color);
        if (ammo == null) {
            return;
        }
        IAmmo ammoItem = (IAmmo)ammo.func_77973_b();
        if (!ammoItem.drain(ammo, 1, true)) {
            return;
        }
        int ammoColor = ammoItem.getInternalColor(ammo);
        if (ammoColor != color.getRGB()) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"color", (int)ammoColor);
        }
        ammoItem.drain(ammo, 1, false);
        boolean handMod = playerIn.func_184614_ca() == stack ^ playerIn.func_184591_cq() == EnumHandSide.LEFT;
        Vec3d cross = playerIn.func_70676_i(1.0f).func_72431_c(new Vec3d(0.0, (double)playerIn.func_70047_e(), 0.0)).func_72432_b().func_186678_a((double)(playerIn.field_70130_N / 2.0f));
        if (!handMod) {
            cross = cross.func_186678_a(-1.0);
        }
        Vec3d playerVec = new Vec3d(playerIn.field_70165_t + cross.field_72450_a, playerIn.field_70163_u + (double)playerIn.func_70047_e() + cross.field_72448_b - 0.2, playerIn.field_70161_v + cross.field_72449_c);
        Beam beam = new Beam(playerIn.func_130014_f_(), playerVec, playerIn.func_70676_i(1.0f), color).setMode(BeamModeRegistry.GUN).setUUIDToSkip(playerIn.func_110124_au()).setCaster((Entity)playerIn).setRange(30.0).enableParticleEnd();
        beam.spawn();
    }

    @Nullable
    public Function2<ItemStack, Integer, Integer> getItemColorFunction() {
        return (stack, tintIndex) -> tintIndex == 1 ? this.getColor((ItemStack)stack).getRGB() : 0xFFFFFF;
    }

    private Color getColor(ItemStack stack) {
        Color c = new Color(ItemNBTHelper.getInt((ItemStack)stack, (String)"color", (int)0xFFFFFF));
        float[] comps = c.getRGBComponents(null);
        c = new Color((float)Math.max((double)comps[0] - 0.12, 0.0), (float)Math.max((double)comps[1] - 0.12, 0.0), (float)Math.max((double)comps[2] - 0.12, 0.0));
        return ColorUtils.pulseColor((Color)c);
    }
}

