/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.entity;

import com.google.common.collect.ImmutableList;
import com.teamwizardry.refraction.init.ModItems;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.jetbrains.annotations.NotNull;

public class EntityLaserPointer
extends EntityLivingBase
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Byte> AXIS_HIT = EntityDataManager.func_187226_a(EntityLaserPointer.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Boolean> HAND_HIT = EntityDataManager.func_187226_a(EntityLaserPointer.class, (DataSerializer)DataSerializers.field_187198_h);
    private WeakReference<EntityPlayer> player;

    public EntityLaserPointer(World worldIn, EntityPlayer player, boolean hit) {
        super(worldIn);
        this.player = new WeakReference<EntityPlayer>(player);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70180_af.func_187227_b(HAND_HIT, (Object)hit);
    }

    public EntityLaserPointer(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
    }

    public void func_70030_z() {
    }

    protected void func_70665_d(@NotNull DamageSource damageSrc, float damageAmount) {
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        this.updateRayPos();
    }

    public void updateRayPos() {
        if (this.player == null || this.player.get() == null) {
            this.func_70106_y();
        } else if (((EntityPlayer)this.player.get()).func_184607_cu() == null || ((EntityPlayer)this.player.get()).func_184607_cu().func_77973_b() != ModItems.LASER_PEN) {
            this.func_70106_y();
        } else {
            RayTraceResult res = this.rayTrace((EntityPlayer)this.player.get(), 32.0);
            Vec3d pos = null;
            if (res != null) {
                pos = res.field_72307_f;
                this.func_175136_bO();
                this.field_70180_af.func_187227_b(AXIS_HIT, (Object)((byte)res.field_178784_b.func_176740_k().ordinal()));
            } else {
                pos = ((EntityPlayer)this.player.get()).func_70676_i(1.0f).func_186678_a(32.0).func_178787_e(((EntityPlayer)this.player.get()).func_174824_e(1.0f));
                this.func_175136_bO();
                this.field_70180_af.func_187227_b(AXIS_HIT, (Object)-1);
            }
            this.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
    }

    public RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance) {
        Vec3d cross = player.func_70676_i(1.0f).func_72431_c(new Vec3d(0.0, (double)player.func_70047_e(), 0.0)).func_72432_b().func_186678_a((double)(player.field_70130_N / 2.0f));
        if (!((Boolean)this.field_70180_af.func_187225_a(HAND_HIT)).booleanValue()) {
            cross = cross.func_186678_a(-1.0);
        }
        Vec3d vec3d = new Vec3d(player.field_70165_t + cross.field_72450_a, player.field_70163_u + (double)player.func_70047_e() + cross.field_72448_b, player.field_70161_v + cross.field_72449_c);
        Vec3d vec3d1 = this.func_174806_f(player.field_70125_A, player.field_70759_as);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    @NotNull
    public EnumHandSide func_184591_cq() {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AXIS_HIT, (Object)0);
        this.field_70180_af.func_187214_a(HAND_HIT, (Object)false);
    }

    @NotNull
    public Iterable<ItemStack> func_184193_aE() {
        return ImmutableList.of();
    }

    @Nullable
    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return null;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, @Nullable ItemStack stack) {
    }

    public void func_70037_a(NBTTagCompound compound) {
    }

    public void func_70014_b(NBTTagCompound compound) {
    }

    public void writeSpawnData(ByteBuf buffer) {
        EntityPlayer p;
        boolean b = this.player == null || this.player.get() == null;
        buffer.writeBoolean(b);
        if (!b && (p = (EntityPlayer)this.player.get()) != null) {
            buffer.writeLong(p.getPersistentID().getMostSignificantBits());
            buffer.writeLong(p.getPersistentID().getLeastSignificantBits());
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        boolean b = buffer.readBoolean();
        if (!b) {
            UUID uuid = new UUID(buffer.readLong(), buffer.readLong());
            this.player = new WeakReference<EntityPlayer>(this.field_70170_p.func_152378_a(uuid));
        }
    }
}

