/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.entity;

import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.modes.BeamModeRegistry;
import com.teamwizardry.refraction.init.ModSounds;
import java.awt.Color;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityGrenade
extends EntityThrowable {
    public static final DataParameter<Integer> DATA_COLOR = EntityDataManager.func_187226_a(EntityGrenade.class, (DataSerializer)DataSerializers.field_187192_b);
    public int life = 100;
    public int explosionTimer = 50;
    private EntityLivingBase caster;

    public EntityGrenade(World worldIn) {
        super(worldIn);
        this.applyColor(Color.WHITE);
    }

    public EntityGrenade(World worldIn, Color color, EntityLivingBase caster) {
        super(worldIn);
        this.caster = caster;
        this.applyColor(color);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_COLOR, (Object)0);
    }

    private void applyColor(Color color) {
        this.func_184212_Q().func_187227_b(DATA_COLOR, (Object)color.getRGB());
        this.func_184212_Q().func_187217_b(DATA_COLOR);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        boolean spawnBeams = false;
        if (this.life > 0) {
            --this.life;
        } else if (this.explosionTimer > 0) {
            --this.explosionTimer;
            spawnBeams = true;
        } else {
            this.func_70106_y();
        }
        if (spawnBeams) {
            int i;
            Color color = new Color((Integer)this.func_184212_Q().func_187225_a(DATA_COLOR), true);
            Vec3d pos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            for (i = 0; i < 30; ++i) {
                double radius = 5.0;
                double theta = (float)Math.PI * 2 * ThreadLocalRandom.current().nextFloat();
                double r = radius * (double)ThreadLocalRandom.current().nextFloat();
                double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                Vec3d dest = new Vec3d(x, (double)ThreadLocalRandom.current().nextInt(-5, 5), z);
                Color c = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() / ThreadLocalRandom.current().nextDouble(1.0, 3.0)));
                new Beam(this.field_70170_p, pos, dest, c).setCaster((Entity)this.caster).setMode(BeamModeRegistry.EFFECT).spawn();
            }
            for (i = 0; i < 4; ++i) {
                this.func_184185_a(ModSounds.CRACKLE, 1.0f, ThreadLocalRandom.current().nextFloat());
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.applyColor(new Color(compound.func_74762_e("color")));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("color", ((Integer)this.func_184212_Q().func_187225_a(DATA_COLOR)).intValue());
    }
}

