/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.effect;

import com.teamwizardry.refraction.api.beam.BeamHitEvent;
import com.teamwizardry.refraction.api.beam.Effect;
import com.teamwizardry.refraction.api.beam.EffectTracker;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.api.beam.modes.BeamMode;
import com.teamwizardry.refraction.api.beam.modes.BeamModeRegistry;
import com.teamwizardry.refraction.api.beam.modes.ModeGravity;
import java.awt.Color;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EffectGravity
extends Effect {
    @Override
    public Effect.EffectType getType() {
        return Effect.EffectType.BEAM;
    }

    @Override
    public Color getColor() {
        return new Color(38655);
    }

    @Override
    public BeamMode getRequiredBeamMode() {
        return BeamModeRegistry.GRAVITY;
    }

    @Override
    public void runEntity(World world, Entity entity, int potency) {
        if (entity instanceof EntityFallingBlock) {
            return;
        }
        entity.func_189654_d(true);
        EffectTracker.gravityReset.put(entity, 30);
        entity.field_70143_R = 0.0f;
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_70133_I = true;
        }
    }

    @SubscribeEvent
    public void beamHit(BeamHitEvent event) {
        if (event.getBeam().mode instanceof ModeGravity) {
            BlockPos pos;
            World world = event.getWorld();
            if (world.func_175623_d(pos = event.getPos())) {
                return;
            }
            EffectTracker.gravityProtection.put(pos, 50);
            IBlockState state = world.func_180495_p(pos);
            if (world.func_175623_d(pos.func_177977_b()) && !(state.func_177230_c() instanceof IBeamHandler)) {
                int potency = event.getBeam().color.getAlpha();
                double hardness = state.func_177230_c().func_176195_g(state, world, event.getPos());
                if (hardness >= 0.0 && hardness * 64.0 < (double)potency && world.func_175625_s(pos) == null) {
                    EntityFallingBlock falling = new EntityFallingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, state);
                    falling.field_145812_b = 1;
                    world.func_175698_g(pos);
                    world.func_72838_d((Entity)falling);
                }
            }
        }
    }

    @SubscribeEvent
    public void interact1(PlayerInteractEvent.RightClickBlock event) {
        if (event.getPos() != null && EffectTracker.gravityProtection.containsKey(event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void interact2(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getPos() != null && EffectTracker.gravityProtection.containsKey(event.getPos())) {
            event.setCanceled(true);
        }
    }
}

