/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.effect;

import com.teamwizardry.refraction.api.CapsUtils;
import com.teamwizardry.refraction.api.beam.Effect;
import com.teamwizardry.refraction.api.beam.EffectTracker;
import com.teamwizardry.refraction.common.effect.EffectBurn;
import java.awt.Color;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EffectAttract
extends Effect {
    @Override
    public Effect.EffectType getType() {
        return Effect.EffectType.BEAM;
    }

    private void setEntityMotion(Entity entity, double potency) {
        if (this.beam.finalLoc != null) {
            Vec3d pullDir = this.beam.initLoc.func_178788_d(this.beam.finalLoc).func_72432_b();
            entity.func_189654_d(true);
            entity.field_70159_w = pullDir.field_72450_a * potency / 255.0;
            entity.field_70181_x = pullDir.field_72448_b * potency / 255.0;
            entity.field_70179_y = pullDir.field_72449_c * potency / 255.0;
            entity.field_70143_R = 0.0f;
        }
    }

    @Override
    public void runEntity(World world, Entity entity, int potency) {
        this.setEntityMotion(entity, potency);
        EffectTracker.gravityReset.put(entity, 30);
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_70133_I = true;
        }
    }

    @Override
    public void runBlock(World world, BlockPos pos, int potency) {
        if (this.beam.trace == null) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.beam.trace.func_178782_a());
        if (tile == null) {
            return;
        }
        if (!EffectBurn.burnedTileTracker.contains(this.beam.trace.func_178782_a())) {
            return;
        }
        EffectBurn.burnedTileTracker.remove(this.beam.trace.func_178782_a());
        if (ThreadLocalRandom.current().nextInt(potency > 0 ? 2550 / potency : 1) != 0) {
            return;
        }
        if (tile instanceof IInventory) {
            ItemStack slotStack;
            IInventory inv = (IInventory)tile;
            int lastSlot = 0;
            for (int i = inv.func_70302_i_() - 1; i > 0; --i) {
                if (inv.func_70301_a(i) == null) continue;
                lastSlot = i;
                break;
            }
            if ((slotStack = inv.func_70301_a(lastSlot)) == null) {
                return;
            }
            ItemStack stack = inv.func_70298_a(lastSlot, slotStack.field_77994_a < potency / 50 ? slotStack.field_77994_a : potency / 50);
            if (stack == null) {
                return;
            }
            EntityItem item = new EntityItem(world, this.beam.trace.field_72307_f.field_72450_a, this.beam.trace.field_72307_f.field_72448_b, this.beam.trace.field_72307_f.field_72449_c, stack);
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            world.func_72838_d((Entity)item);
        } else if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.beam.trace.field_178784_b)) {
            IItemHandler cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.beam.trace.field_178784_b);
            int lastSlot = CapsUtils.getLastOccupiedSlot(cap);
            if (CapsUtils.getOccupiedSlotCount(cap) > 0) {
                ItemStack stack = cap.extractItem(lastSlot, cap.getStackInSlot((int)lastSlot).field_77994_a < potency / 50 ? cap.getStackInSlot((int)lastSlot).field_77994_a : potency / 50, false);
                if (stack == null) {
                    return;
                }
                EntityItem item = new EntityItem(world, this.beam.trace.field_72307_f.field_72450_a, this.beam.trace.field_72307_f.field_72448_b, this.beam.trace.field_72307_f.field_72449_c, stack);
                item.field_70159_w = 0.0;
                item.field_70181_x = 0.0;
                item.field_70179_y = 0.0;
                world.func_72838_d((Entity)item);
            }
        }
    }

    @Override
    public Color getColor() {
        return Color.CYAN;
    }
}

