/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.core;

import com.teamwizardry.librarianlib.common.network.PacketHandler;
import com.teamwizardry.librarianlib.common.util.math.Matrix4;
import com.teamwizardry.refraction.api.ConfigValues;
import com.teamwizardry.refraction.api.EventAssemblyTableCraft;
import com.teamwizardry.refraction.api.Utils;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.BeamHitEvent;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.api.beam.modes.BeamModeRegistry;
import com.teamwizardry.refraction.api.raytrace.Tri;
import com.teamwizardry.refraction.common.block.BlockLens;
import com.teamwizardry.refraction.common.block.BlockPrism;
import com.teamwizardry.refraction.common.network.PacketAXYZMarks;
import com.teamwizardry.refraction.common.network.PacketLaserDisplayTick;
import com.teamwizardry.refraction.init.ModAchievements;
import com.teamwizardry.refraction.init.ModBlocks;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();

    private EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        PacketAXYZMarks.controlPoints.clear();
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        PacketAXYZMarks.controlPoints.clear();
    }

    @SubscribeEvent
    public void craft(EventAssemblyTableCraft event) {
        block4: {
            block5: {
                block3: {
                    if (event.getOutput().func_77973_b() != ModBlocks.TRANSLOCATOR.getItemForm()) break block3;
                    for (EntityPlayer player : this.getPlayersWithinRange(event.getWorld(), event.getPos(), 20.0)) {
                        player.func_71029_a((StatBase)ModAchievements.TRANSLOCATOR);
                    }
                    break block4;
                }
                if (event.getOutput().func_77973_b() != ModBlocks.PRISM.getItemForm()) break block5;
                for (EntityPlayer player : this.getPlayersWithinRange(event.getWorld(), event.getPos(), 20.0)) {
                    player.func_71029_a((StatBase)ModAchievements.PRISM);
                }
                break block4;
            }
            if (event.getOutput().func_77973_b() != ModBlocks.AXYZ.getItemForm()) break block4;
            for (EntityPlayer player : this.getPlayersWithinRange(event.getWorld(), event.getPos(), 20.0)) {
                player.func_71029_a((StatBase)ModAchievements.AXYZ);
            }
        }
    }

    @SubscribeEvent
    public void handleGlass(BeamHitEvent event) {
        Color dye;
        if (event.getState().func_177230_c() instanceof IBeamHandler) {
            return;
        }
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        Beam beam = event.getBeam();
        if (event.getState().func_177230_c() == Blocks.field_150399_cn || event.getState().func_177230_c() == Blocks.field_150397_co) {
            dye = Utils.getColorFromDyeEnum((EnumDyeColor)event.getState().func_177229_b((IProperty)BlockStainedGlass.field_176547_a));
        } else if (event.getState().func_177230_c() == Blocks.field_150410_aZ || event.getState().func_177230_c() == Blocks.field_150359_w) {
            dye = beam.color;
        } else {
            return;
        }
        Color color = new Color(dye.getRed(), dye.getGreen(), dye.getBlue(), (int)((double)beam.color.getAlpha() / 1.4));
        this.fireColor(event.getWorld(), event.getPos(), event.getState(), beam.finalLoc, beam.finalLoc.func_178788_d(beam.initLoc).func_72432_b(), ConfigValues.GLASS_IOR, color, beam);
        event.setResult(Event.Result.DENY);
    }

    private void fireColor(World world, BlockPos pos, IBlockState state, Vec3d hitPos, Vec3d ref, double IORMod, Color color, Beam beam) {
        BlockPrism.RayTraceResultData<Vec3d> r = this.collisionRayTraceLaser(state, world, pos, hitPos.func_178788_d(ref), hitPos.func_178787_e(ref));
        if (r != null && r.data != null) {
            Vec3d normal = (Vec3d)r.data;
            ref = BlockLens.refracted(ConfigValues.AIR_IOR + IORMod, ConfigValues.GLASS_IOR + IORMod, ref, normal).func_72432_b();
            hitPos = r.field_72307_f;
            for (int i = 0; i < 5; ++i) {
                r = this.collisionRayTraceLaser(state, world, pos, hitPos.func_178787_e(ref), hitPos);
                if (r == null || r.data == null) continue;
                normal = ((Vec3d)r.data).func_186678_a(-1.0);
                Vec3d oldRef = ref;
                ref = BlockLens.refracted(ConfigValues.GLASS_IOR + IORMod, ConfigValues.AIR_IOR + IORMod, ref, normal).func_72432_b();
                if (Double.isNaN(ref.field_72450_a) || Double.isNaN(ref.field_72448_b) || Double.isNaN(ref.field_72449_c)) {
                    ref = oldRef;
                    break;
                }
                BlockLens.showBeam(world, hitPos, r.field_72307_f, color);
                hitPos = r.field_72307_f;
            }
            beam.createSimilarBeam(hitPos, ref, color).setMode(BeamModeRegistry.NONE).enableParticleBeginning().spawn();
        }
    }

    private BlockPrism.RayTraceResultData<Vec3d> collisionRayTraceLaser(@NotNull IBlockState blockState, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Vec3d startRaw, @NotNull Vec3d endRaw) {
        EnumFacing facing = EnumFacing.UP;
        Matrix4 matrixA = new Matrix4();
        Matrix4 matrixB = new Matrix4();
        switch (facing) {
            case UP: 
            case DOWN: 
            case EAST: {
                break;
            }
            case NORTH: {
                matrixA.rotate(Math.toRadians(270.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(270.0), new Vec3d(0.0, 1.0, 0.0));
                break;
            }
            case SOUTH: {
                matrixA.rotate(Math.toRadians(90.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(90.0), new Vec3d(0.0, 1.0, 0.0));
                break;
            }
            case WEST: {
                matrixA.rotate(Math.toRadians(180.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(180.0), new Vec3d(0.0, 1.0, 0.0));
            }
        }
        Vec3d a = new Vec3d(0.001, 0.001, 0.0);
        Vec3d b = new Vec3d(1.0, 0.001, 0.5);
        Vec3d c = new Vec3d(0.001, 0.001, 1.0);
        Vec3d A = a.func_72441_c(0.0, 0.998, 0.0);
        Vec3d B = b.func_72441_c(0.0, 0.998, 0.0);
        Vec3d C = c.func_72441_c(0.0, 0.998, 0.0);
        Tri[] tris = new Tri[]{new Tri(a, b, c), new Tri(A, C, B), new Tri(a, c, C), new Tri(a, C, A), new Tri(a, A, B), new Tri(a, B, b), new Tri(b, B, C), new Tri(b, C, c)};
        Vec3d start = matrixA.apply(startRaw.func_178788_d(new Vec3d((Vec3i)pos)).func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5);
        Vec3d end = matrixA.apply(endRaw.func_178788_d(new Vec3d((Vec3i)pos)).func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5);
        Tri hitTri = null;
        Vec3d hit = null;
        double shortestSq = Double.POSITIVE_INFINITY;
        for (Tri tri : tris) {
            double distSq;
            Vec3d v = tri.trace(start, end);
            if (v == null || !((distSq = start.func_178788_d(v).func_189985_c()) < shortestSq)) continue;
            hit = v;
            shortestSq = distSq;
            hitTri = tri;
        }
        if (hit == null) {
            return null;
        }
        return new BlockPrism.RayTraceResultData<Vec3d>(matrixB.apply(hit.func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d((Vec3i)pos)), EnumFacing.UP, pos).data(matrixB.apply(hitTri.normal()));
    }

    public List<EntityPlayer> getPlayersWithinRange(World world, BlockPos pos, double range) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            if (!EntitySelectors.field_180132_d.apply((Object)entityplayer)) continue;
            double d0 = entityplayer.func_174818_b(pos);
            if (!(range < 0.0) && !(d0 < range * range)) continue;
            players.add(entityplayer);
        }
        return players;
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == ModBlocks.LIGHT_BRIDGE) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            PacketHandler.NETWORK.sendToAll((IMessage)new PacketLaserDisplayTick());
        }
    }
}

