/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.google.common.collect.Lists;
import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockMod;
import com.teamwizardry.librarianlib.common.util.DimWithPos;
import com.teamwizardry.librarianlib.common.util.EnumBiFacing;
import com.teamwizardry.refraction.api.IOpticConnectable;
import com.teamwizardry.refraction.api.PosUtils;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.Effect;
import com.teamwizardry.refraction.api.beam.EffectTracker;
import com.teamwizardry.refraction.common.block.BlockOpticFiber;
import com.teamwizardry.refraction.common.effect.EffectDisperse;
import com.teamwizardry.refraction.init.ModBlocks;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockTranslocator
extends BlockMod
implements IOpticConnectable {
    public static final PropertyDirection DIRECTION = PropertyDirection.func_177714_a((String)"side");
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.625, 0.9375);
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0625, 0.375, 0.0625, 0.9375, 1.0, 0.9375);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 0.625);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0625, 0.0625, 0.375, 0.9375, 0.9375, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0625, 0.0625, 0.625, 0.9375, 0.9375);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.375, 0.0625, 0.0625, 1.0, 0.9375, 0.9375);

    public BlockTranslocator() {
        super("translocator", Material.field_151592_s, new String[0]);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    @Override
    @Nonnull
    public List<EnumFacing> getAvailableFacings(@NotNull IBlockState state, @NotNull IBlockAccess source, @NotNull BlockPos pos, @NotNull EnumFacing facing) {
        if (facing != state.func_177229_b((IProperty)DIRECTION)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new EnumFacing[]{((EnumFacing)state.func_177229_b((IProperty)DIRECTION)).func_176734_d()});
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIRECTION, CONNECTED});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState fiber = worldIn.func_180495_p(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)DIRECTION)).func_176734_d()));
        return state.func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(fiber.func_177230_c() instanceof BlockOpticFiber && ((EnumBiFacing)fiber.func_177229_b(BlockOpticFiber.FACING)).contains((EnumFacing)state.func_177229_b((IProperty)DIRECTION))));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.field_82609_l[meta % EnumFacing.field_82609_l.length]);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
            case DOWN: {
                return DOWN_AABB;
            }
            case UP: {
                return UP_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
        }
        return field_185506_k;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)).func_176745_a();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)DIRECTION, (Comparable)facing.func_176734_d());
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public void handleFiberBeam(@NotNull World world, @NotNull BlockPos pos, @NotNull Beam beam) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)DIRECTION);
        if (!beam.slope.equals((Object)PosUtils.getVecFromFacing(dir))) {
            return;
        }
        Effect effect = EffectTracker.getEffect(beam);
        if (effect instanceof EffectDisperse) {
            IBlockState axyz = world.func_180495_p(pos.func_177972_a(dir));
            IBlockState check2 = world.func_180495_p(pos.func_177967_a(dir, 2));
            if (axyz.func_177230_c() == ModBlocks.AXYZ && check2.func_177230_c().isAir(check2, (IBlockAccess)world, pos.func_177967_a(dir, 2))) {
                DimWithPos key = new DimWithPos(world.field_73011_w.getDimension(), pos.func_177972_a(dir));
                if (ModBlocks.AXYZ.mappedPositions.containsKey(key)) {
                    DimWithPos mapped = ModBlocks.AXYZ.mappedPositions.get(key);
                    DimWithPos newKey = new DimWithPos(world.field_73011_w.getDimension(), pos.func_177967_a(dir, 2));
                    ModBlocks.AXYZ.mappedPositions.remove(key);
                    ModBlocks.AXYZ.mappedPositions.put(newKey, mapped);
                } else {
                    ModBlocks.AXYZ.mappedPositions.put(new DimWithPos(world.field_73011_w.getDimension(), pos.func_177967_a(dir, 2)), key);
                }
                world.func_184133_a(null, pos.func_177967_a(dir, 2), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_175656_a(pos.func_177972_a(dir), Blocks.field_150350_a.func_176223_P());
                world.func_175656_a(pos.func_177967_a(dir, 2), axyz);
                return;
            }
            if (check2.func_177230_c() == ModBlocks.AXYZ) {
                return;
            }
        }
        if (!world.func_175623_d(pos.func_177972_a(dir))) {
            Vec3d slope = beam.slope.func_72432_b().func_186678_a(0.9375);
            beam.createSimilarBeam(PosUtils.getSideCenter(pos, dir).func_178787_e(slope), PosUtils.getVecFromFacing(dir)).spawn();
        } else {
            beam.createSimilarBeam(PosUtils.getSideCenter(pos, dir), PosUtils.getVecFromFacing(dir)).spawn();
        }
    }

    public boolean isToolEffective(String type, @NotNull IBlockState state) {
        return Objects.equals(type, "pickaxe") || Objects.equals(type, "screwdriver");
    }

    @Nullable
    public String getHarvestTool(@NotNull IBlockState state) {
        return "pickaxe";
    }
}

