/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockModContainer;
import com.teamwizardry.librarianlib.common.util.math.Matrix4;
import com.teamwizardry.refraction.api.IPrecision;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.api.raytrace.ILaserTrace;
import com.teamwizardry.refraction.client.render.RenderSplitter;
import com.teamwizardry.refraction.common.tile.TileSplitter;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSplitter
extends BlockModContainer
implements ILaserTrace,
IPrecision,
IBeamHandler {
    public BlockSplitter() {
        super("splitter", Material.field_151573_f, new String[0]);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileSplitter.class, (TileEntitySpecialRenderer)new RenderSplitter());
    }

    private TileSplitter getTE(World world, BlockPos pos) {
        return (TileSplitter)world.func_175625_s(pos);
    }

    @Override
    public void handleBeams(@NotNull World world, @NotNull BlockPos pos, Beam ... beams) {
        this.getTE(world, pos).handle(beams);
    }

    @Override
    public float getRotX(World worldIn, BlockPos pos) {
        return this.getTE(worldIn, pos).getRotX();
    }

    @Override
    public void setRotX(World worldIn, BlockPos pos, float x) {
        this.getTE(worldIn, pos).setRotX(x);
    }

    @Override
    public float getRotY(World worldIn, BlockPos pos) {
        return this.getTE(worldIn, pos).getRotY();
    }

    @Override
    public void setRotY(World worldIn, BlockPos pos, float y) {
        this.getTE(worldIn, pos).setRotY(y);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileSplitter splitter = this.getTE(worldIn, pos);
        if (splitter == null) {
            return;
        }
        if (splitter.isPowered()) {
            if (!worldIn.func_175640_z(pos) || worldIn.func_175687_A(pos) == 0) {
                splitter.setPowered(false);
            }
        } else if (worldIn.func_175640_z(pos) || worldIn.func_175687_A(pos) > 0) {
            splitter.setPowered(true);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileSplitter splitter = this.getTE(worldIn, pos);
        if (splitter == null) {
            return;
        }
        if (splitter.isPowered() && !worldIn.func_175640_z(pos)) {
            splitter.setPowered(false);
        }
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Override
    public RayTraceResult collisionRayTraceLaser(@NotNull IBlockState blockState, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Vec3d startRaw, @NotNull Vec3d endRaw) {
        double pixels = 0.0625;
        AxisAlignedBB aabb = new AxisAlignedBB(pixels, 0.0, pixels, 1.0 - pixels, pixels, 1.0 - pixels).func_72317_d(-0.5, -pixels / 2.0, -0.5);
        RayTraceResult superResult = super.func_180636_a(blockState, worldIn, pos, startRaw, endRaw);
        TileSplitter tile = (TileSplitter)worldIn.func_175625_s(pos);
        if (tile == null) {
            return null;
        }
        Vec3d start = startRaw.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d end = endRaw.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        start = start.func_178786_a(0.5, 0.5, 0.5);
        end = end.func_178786_a(0.5, 0.5, 0.5);
        Matrix4 matrix = new Matrix4();
        matrix.rotate(-Math.toRadians(tile.getRotX()), new Vec3d(1.0, 0.0, 0.0));
        matrix.rotate(-Math.toRadians(tile.getRotY()), new Vec3d(0.0, 1.0, 0.0));
        Matrix4 inverse = new Matrix4();
        inverse.rotate(Math.toRadians(tile.getRotY()), new Vec3d(0.0, 1.0, 0.0));
        inverse.rotate(Math.toRadians(tile.getRotX()), new Vec3d(1.0, 0.0, 0.0));
        start = matrix.apply(start);
        end = matrix.apply(end);
        RayTraceResult result = aabb.func_72327_a(start, end);
        if (result == null) {
            return null;
        }
        Vec3d a = result.field_72307_f;
        a = inverse.apply(a);
        a = a.func_72441_c(0.5, 0.5, 0.5);
        return new RayTraceResult(a.func_178787_e(new Vec3d((Vec3i)pos)), superResult == null ? EnumFacing.UP : superResult.field_178784_b, pos);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState iBlockState) {
        return new TileSplitter();
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return super.isToolEffective(type, state) || Objects.equals(type, "screwdriver");
    }
}

