/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockModContainer;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.client.render.RenderSpectrometer;
import com.teamwizardry.refraction.common.tile.TileSpectrometer;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSpectrometer
extends BlockModContainer
implements IBeamHandler {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);

    public BlockSpectrometer() {
        super("spectrometer", Material.field_151573_f, new String[0]);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH));
    }

    @Override
    public boolean handleBeam(@NotNull World world, @NotNull BlockPos pos, @NotNull Beam beam) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            ((TileSpectrometer)te).handle(beam);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileSpectrometer.class, (TileEntitySpecialRenderer)new RenderSpectrometer());
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a(FACING, (Comparable)placer.func_184172_bi().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState iBlockState) {
        return new TileSpectrometer();
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return super.isToolEffective(type, state) || Objects.equals(type, "screwdriver");
    }
}

