/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockMod;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSensor
extends BlockMod
implements IBeamHandler {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    public static final PropertyBool ON = PropertyBool.func_177716_a((String)"on");
    private static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.6875, 0.6875, 0.625, 0.3125, 0.3125);
    private static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.375, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);
    private static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.3125, 0.3125, 0.375, 0.6875, 0.6875, 1.0);
    private static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB AABB_UP = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.625, 0.6875);
    private static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.3125, 0.375, 0.3125, 0.6875, 1.0, 0.6875);

    public BlockSensor() {
        super("sensor", Material.field_151592_s, new String[0]);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b(FACING);
        switch (enumfacing) {
            case UP: {
                return AABB_UP;
            }
            case DOWN: {
                return AABB_DOWN;
            }
            case NORTH: {
                return AABB_NORTH;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
        }
        return AABB_UP;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177976_e()).isSideSolid((IBlockAccess)worldIn, pos.func_177976_e(), EnumFacing.EAST) || worldIn.func_180495_p(pos.func_177974_f()).isSideSolid((IBlockAccess)worldIn, pos.func_177974_f(), EnumFacing.WEST) || worldIn.func_180495_p(pos.func_177978_c()).isSideSolid((IBlockAccess)worldIn, pos.func_177978_c(), EnumFacing.SOUTH) || worldIn.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.UP) || worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.DOWN) || worldIn.func_180495_p(pos.func_177968_d()).isSideSolid((IBlockAccess)worldIn, pos.func_177968_d(), EnumFacing.NORTH);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b(FACING);
        if (!this.canBlockStay(worldIn, pos, enumfacing)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        super.func_189540_a(state, worldIn, pos, blockIn);
    }

    private boolean canBlockStay(World worldIn, BlockPos pos, EnumFacing facing) {
        return worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).isSideSolid((IBlockAccess)worldIn, pos.func_177972_a(facing.func_176734_d()), facing);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)facing);
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)ON) != false ? 15 : 0;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)ON) != false ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a() | ((Boolean)state.func_177229_b((IProperty)ON) != false ? 8 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ON});
    }

    @Nullable
    public IProperty<?>[] getIgnoredProperties() {
        return new IProperty[]{ON};
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(false)));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            worldIn.func_175695_a(pos.func_177972_a(facing), (Block)this, facing.func_176734_d());
        }
    }

    @Override
    public boolean handleBeam(@NotNull World world, @NotNull BlockPos pos, @NotNull Beam beam) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(true)));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            world.func_175695_a(pos.func_177972_a(facing), (Block)this, facing.func_176734_d());
        }
        world.func_175684_a(pos, (Block)this, 20);
        return false;
    }

    public boolean isToolEffective(String type, @NotNull IBlockState state) {
        return Objects.equals(type, "pickaxe") || Objects.equals(type, "screwdriver");
    }

    @Nullable
    public String getHarvestTool(@NotNull IBlockState state) {
        return "pickaxe";
    }
}

