/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockMod;
import com.teamwizardry.refraction.api.Utils;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockReflectiveAlloyBlock
extends BlockMod
implements IBeamHandler {
    public BlockReflectiveAlloyBlock() {
        super("reflective_alloy_block", Material.field_151573_f, new String[0]);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    @Override
    public boolean handleBeam(@NotNull World world, @NotNull BlockPos pos, @NotNull Beam beam) {
        Vec3d outgoingDir;
        EnumFacing facing = Utils.getCollisionSide(beam.trace);
        if (facing == null) {
            return true;
        }
        Vec3d incomingDir = beam.slope;
        Vec3d outgoingLoc = beam.finalLoc;
        switch (facing) {
            case UP: {
                outgoingDir = new Vec3d(incomingDir.field_72450_a, Math.abs(incomingDir.field_72448_b), incomingDir.field_72449_c);
                outgoingLoc = outgoingLoc.func_178786_a(0.0, 0.001, 0.0);
                break;
            }
            case DOWN: {
                outgoingDir = new Vec3d(incomingDir.field_72450_a, -Math.abs(incomingDir.field_72448_b), incomingDir.field_72449_c);
                break;
            }
            case NORTH: {
                outgoingDir = new Vec3d(incomingDir.field_72450_a, incomingDir.field_72448_b, -Math.abs(incomingDir.field_72449_c));
                break;
            }
            case SOUTH: {
                outgoingDir = new Vec3d(incomingDir.field_72450_a, incomingDir.field_72448_b, Math.abs(incomingDir.field_72449_c));
                outgoingLoc = outgoingLoc.func_178786_a(0.0, 0.0, 0.001);
                break;
            }
            case EAST: {
                outgoingDir = new Vec3d(Math.abs(incomingDir.field_72450_a), incomingDir.field_72448_b, incomingDir.field_72449_c);
                outgoingLoc = outgoingLoc.func_178786_a(0.001, 0.0, 0.0);
                break;
            }
            case WEST: {
                outgoingDir = new Vec3d(-Math.abs(incomingDir.field_72450_a), incomingDir.field_72448_b, incomingDir.field_72449_c);
                break;
            }
            default: {
                outgoingDir = incomingDir;
            }
        }
        Color c = new Color(beam.color.getRed(), beam.color.getGreen(), beam.color.getBlue(), (int)((double)beam.color.getAlpha() / 1.05));
        beam.createSimilarBeam(outgoingLoc, outgoingDir, c).enableParticleBeginning().spawn();
        return true;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return super.isToolEffective(type, state) || Objects.equals(type, "screwdriver");
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return true;
    }
}

