/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockMod;
import com.teamwizardry.librarianlib.common.network.PacketHandler;
import com.teamwizardry.librarianlib.common.util.math.Matrix4;
import com.teamwizardry.refraction.api.ConfigValues;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.api.raytrace.ILaserTrace;
import com.teamwizardry.refraction.api.raytrace.Tri;
import com.teamwizardry.refraction.common.block.BlockLens;
import com.teamwizardry.refraction.common.network.PacketLaserFX;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class BlockPrism
extends BlockMod
implements ILaserTrace,
IBeamHandler {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);

    public BlockPrism() {
        super("prism", Material.field_151592_s, new String[0]);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    @Override
    public boolean handleBeam(@NotNull World world, @NotNull BlockPos pos, @NotNull Beam beam) {
        IBlockState state = world.func_180495_p(pos);
        int sum = beam.color.getRed() + beam.color.getBlue() + beam.color.getGreen();
        double red = beam.color.getAlpha() * beam.color.getRed() / sum;
        double green = beam.color.getAlpha() * beam.color.getGreen() / sum;
        double blue = beam.color.getAlpha() * beam.color.getBlue() / sum;
        Vec3d hitPos = beam.finalLoc;
        if (beam.color.getRed() != 0) {
            this.fireColor(world, pos, state, hitPos, beam.finalLoc.func_178788_d(beam.initLoc).func_72432_b(), ConfigValues.RED_IOR, new Color(beam.color.getRed(), 0, 0, (int)red), beam);
        }
        if (beam.color.getGreen() != 0) {
            this.fireColor(world, pos, state, hitPos, beam.finalLoc.func_178788_d(beam.initLoc).func_72432_b(), ConfigValues.GREEN_IOR, new Color(0, beam.color.getGreen(), 0, (int)green), beam);
        }
        if (beam.color.getBlue() != 0) {
            this.fireColor(world, pos, state, hitPos, beam.finalLoc.func_178788_d(beam.initLoc).func_72432_b(), ConfigValues.BLUE_IOR, new Color(0, 0, beam.color.getBlue(), (int)blue), beam);
        }
        return true;
    }

    private void fireColor(World world, BlockPos pos, IBlockState state, Vec3d hitPos, Vec3d ref, double IORMod, Color color, Beam beam) {
        RayTraceResult r = this.collisionRayTraceLaser(state, world, pos, hitPos.func_178788_d(ref), hitPos.func_178787_e(ref));
        if (r != null && r.data != null) {
            Vec3d normal = (Vec3d)r.data;
            ref = BlockLens.refracted(ConfigValues.AIR_IOR + IORMod, ConfigValues.GLASS_IOR + IORMod, ref, normal).func_72432_b();
            hitPos = r.field_72307_f;
            for (int i = 0; i < 5; ++i) {
                r = this.collisionRayTraceLaser(state, world, pos, hitPos.func_178787_e(ref), hitPos);
                if (r == null || r.data == null) continue;
                normal = ((Vec3d)r.data).func_186678_a(-1.0);
                Vec3d oldRef = ref;
                ref = BlockLens.refracted(ConfigValues.GLASS_IOR + IORMod, ConfigValues.AIR_IOR + IORMod, ref, normal).func_72432_b();
                if (Double.isNaN(ref.field_72450_a) || Double.isNaN(ref.field_72448_b) || Double.isNaN(ref.field_72449_c)) {
                    ref = oldRef;
                    break;
                }
                BlockLens.showBeam(world, hitPos, r.field_72307_f, color);
                hitPos = r.field_72307_f;
            }
            beam.createSimilarBeam(hitPos, ref, color).enableParticleBeginning().spawn();
        }
    }

    private Vec3d refracted(double from, double to, Vec3d vec, Vec3d normal) {
        double r = from / to;
        double c = -normal.func_72430_b(vec);
        return vec.func_186678_a(r).func_178787_e(normal.func_186678_a(r * c - Math.sqrt(1.0 - r * r * (1.0 - c * c))));
    }

    private void showBeam(World world, Vec3d start, Vec3d end, Color color) {
        if (!world.field_72995_K) {
            PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketLaserFX(start, end, color), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), start.field_72450_a, start.field_72448_b, start.field_72449_c, 256.0));
        }
    }

    @NotNull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a(FACING, (Comparable)placer.func_174811_aO());
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @NotNull
    public IBlockState func_185499_a(@NotNull IBlockState state, Rotation rot) {
        return state.func_177226_a(FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b(FACING)));
    }

    @NotNull
    public IBlockState func_185471_a(@NotNull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b(FACING)));
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_176212_b(IBlockAccess worldIn, @NotNull BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public RayTraceResultData<Vec3d> collisionRayTraceLaser(@NotNull IBlockState blockState, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Vec3d startRaw, @NotNull Vec3d endRaw) {
        EnumFacing facing = (EnumFacing)blockState.func_177229_b(FACING);
        Matrix4 matrixA = new Matrix4();
        Matrix4 matrixB = new Matrix4();
        switch (facing) {
            case UP: 
            case DOWN: 
            case EAST: {
                break;
            }
            case NORTH: {
                matrixA.rotate(Math.toRadians(270.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(270.0), new Vec3d(0.0, 1.0, 0.0));
                break;
            }
            case SOUTH: {
                matrixA.rotate(Math.toRadians(90.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(90.0), new Vec3d(0.0, 1.0, 0.0));
                break;
            }
            case WEST: {
                matrixA.rotate(Math.toRadians(180.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(180.0), new Vec3d(0.0, 1.0, 0.0));
            }
        }
        Vec3d a = new Vec3d(0.001, 0.001, 0.0);
        Vec3d b = new Vec3d(1.0, 0.001, 0.5);
        Vec3d c = new Vec3d(0.001, 0.001, 1.0);
        Vec3d A = a.func_72441_c(0.0, 0.998, 0.0);
        Vec3d B = b.func_72441_c(0.0, 0.998, 0.0);
        Vec3d C = c.func_72441_c(0.0, 0.998, 0.0);
        Tri[] tris = new Tri[]{new Tri(a, b, c), new Tri(A, C, B), new Tri(a, c, C), new Tri(a, C, A), new Tri(a, A, B), new Tri(a, B, b), new Tri(b, B, C), new Tri(b, C, c)};
        Vec3d start = matrixA.apply(startRaw.func_178788_d(new Vec3d((Vec3i)pos)).func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5);
        Vec3d end = matrixA.apply(endRaw.func_178788_d(new Vec3d((Vec3i)pos)).func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5);
        Tri hitTri = null;
        Vec3d hit = null;
        double shortestSq = Double.POSITIVE_INFINITY;
        for (Tri tri : tris) {
            double distSq;
            Vec3d v = tri.trace(start, end);
            if (v == null || !((distSq = start.func_178788_d(v).func_189985_c()) < shortestSq)) continue;
            hit = v;
            shortestSq = distSq;
            hitTri = tri;
        }
        if (hit == null) {
            return null;
        }
        return new RayTraceResultData<Vec3d>(matrixB.apply(hit.func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d((Vec3i)pos)), EnumFacing.UP, pos).data(matrixB.apply(hitTri.normal()));
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return super.isToolEffective(type, state) || Objects.equals(type, "screwdriver");
    }

    public static class RayTraceResultData<T>
    extends RayTraceResult {
        public T data;

        public RayTraceResultData(Vec3d hitVecIn, EnumFacing sideHitIn, BlockPos blockPosIn) {
            this(RayTraceResult.Type.BLOCK, hitVecIn, sideHitIn, blockPosIn);
        }

        public RayTraceResultData(Vec3d hitVecIn, EnumFacing sideHitIn) {
            this(RayTraceResult.Type.BLOCK, hitVecIn, sideHitIn, BlockPos.field_177992_a);
        }

        public RayTraceResultData(Entity entityIn) {
            this(entityIn, new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v));
        }

        public RayTraceResultData(RayTraceResult.Type typeIn, Vec3d hitVecIn, EnumFacing sideHitIn, BlockPos blockPosIn) {
            super(typeIn, hitVecIn, sideHitIn, blockPosIn);
        }

        public RayTraceResultData(Entity entityHitIn, Vec3d hitVecIn) {
            super(entityHitIn, hitVecIn);
        }

        public RayTraceResultData<T> data(T data) {
            this.data = data;
            return this;
        }
    }
}

