/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.google.common.collect.Lists;
import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockMod;
import com.teamwizardry.librarianlib.common.util.EnumBiFacing;
import com.teamwizardry.refraction.api.IOpticConnectable;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.init.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockOpticFiber
extends BlockMod
implements IOpticConnectable,
IBeamHandler {
    public static final PropertyEnum<EnumBiFacing> FACING = PropertyEnum.func_177709_a((String)"facings", EnumBiFacing.class);
    private static final AxisAlignedBB[] AABBS = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.375, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.375, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 0.625, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 0.625, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 0.625, 0.625), new AxisAlignedBB(0.0, 0.375, 0.0, 0.625, 0.625, 0.625), new AxisAlignedBB(0.0, 0.375, 0.375, 0.625, 0.625, 1.0), new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625), new AxisAlignedBB(0.375, 0.375, 0.0, 1.0, 0.625, 0.625), new AxisAlignedBB(0.375, 0.375, 0.375, 1.0, 0.625, 1.0), new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0)};
    private static final AxisAlignedBB CENTER = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625);
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.375);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.375, 0.375, 0.625, 0.625, 0.625, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 0.375, 0.625, 0.625);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.625, 0.375, 0.375, 1.0, 0.625, 0.625);

    public BlockOpticFiber() {
        super("optic_fiber", Material.field_151592_s, new String[0]);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    @Override
    public boolean handleBeam(@NotNull World world, @NotNull BlockPos pos, @NotNull Beam beam) {
        EnumBiFacing facing = this.getBiFacing(world, pos);
        if (facing == null) {
            return true;
        }
        EnumBiFacing primary = this.getBiFacing(world, pos.func_177972_a(facing.getPrimary()));
        EnumBiFacing secondary = this.getBiFacing(world, pos.func_177972_a(facing.getSecondary()));
        if (primary != null && secondary != null && primary.contains(facing.getPrimary().func_176734_d()) && secondary.contains(facing.getSecondary().func_176734_d())) {
            return false;
        }
        boolean primaryOpen = true;
        boolean secondaryOpen = true;
        if (primary != null && primary.contains(facing.getPrimary().func_176734_d())) {
            primaryOpen = false;
        }
        if (secondary != null && secondary.contains(facing.getSecondary().func_176734_d())) {
            secondaryOpen = false;
        }
        BlockPos curPos = null;
        EnumFacing curFacing = null;
        EnumBiFacing curBiFacing = null;
        if (!primaryOpen || !secondaryOpen) {
            if (primaryOpen) {
                curPos = pos.func_177972_a(facing.getSecondary());
                curFacing = secondary.getOther(facing.getSecondary().func_176734_d());
                curBiFacing = secondary;
            } else if (secondaryOpen) {
                curPos = pos.func_177972_a(facing.getPrimary());
                curFacing = primary.getOther(facing.getPrimary().func_176734_d());
                curBiFacing = primary;
            }
        }
        BlockPos nextPos = curPos;
        EnumBiFacing nextBiFacing = curBiFacing;
        while (nextBiFacing != null && (nextBiFacing = this.getBiFacing(world, nextPos = curPos.func_177972_a(curFacing))) != null && nextBiFacing.contains(curFacing.func_176734_d())) {
            curPos = nextPos;
            curFacing = nextBiFacing.getOther(curFacing.func_176734_d());
            curBiFacing = nextBiFacing;
        }
        IBlockState state = world.func_180495_p(pos);
        AxisAlignedBB axis = state.func_185900_c((IBlockAccess)world, pos);
        EnumFacing beamDir = EnumFacing.func_176737_a((float)((float)beam.slope.field_72450_a), (float)((float)beam.slope.field_72448_b), (float)((float)beam.slope.field_72449_c));
        if (primaryOpen && secondaryOpen && facing.contains(beamDir.func_176734_d()) && beamDir.func_176734_d() == this.getCollisionSide(axis, beam)) {
            EnumFacing opposite = beamDir.func_176734_d();
            EnumFacing other = facing.getOther(opposite);
            this.spawnBeam(world, beam, new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), other);
            return true;
        }
        if (primaryOpen && facing.getPrimary() == beamDir.func_176734_d() && beamDir.func_176734_d() == this.getCollisionSide(axis, beam)) {
            this.spawnBeam(world, beam, new Vec3d((double)curPos.func_177958_n() + 0.5, (double)curPos.func_177956_o() + 0.5, (double)curPos.func_177952_p() + 0.5), curFacing);
            return true;
        }
        if (secondaryOpen && facing.getSecondary() == beamDir.func_176734_d() && beamDir.func_176734_d() == this.getCollisionSide(axis, beam)) {
            this.spawnBeam(world, beam, new Vec3d((double)curPos.func_177958_n() + 0.5, (double)curPos.func_177956_o() + 0.5, (double)curPos.func_177952_p() + 0.5), curFacing);
            return true;
        }
        return false;
    }

    private EnumBiFacing getBiFacing(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != ModBlocks.OPTIC_FIBER) {
            return null;
        }
        return (EnumBiFacing)state.func_177229_b(FACING);
    }

    private void spawnBeam(World world, Beam beam, Vec3d loc, EnumFacing dir) {
        BlockPos newPos = new BlockPos(loc).func_177972_a(dir);
        IBlockState state = world.func_180495_p(newPos);
        Beam newBeam = beam.createSimilarBeam(loc, this.getFacingVector(dir));
        if (state.func_177230_c() instanceof IOpticConnectable) {
            ((IOpticConnectable)state.func_177230_c()).handleFiberBeam(world, newPos, newBeam);
        } else {
            newBeam.spawn();
        }
    }

    private Vec3d getFacingVector(EnumFacing facing) {
        switch (facing) {
            case UP: {
                return new Vec3d(0.0, 1.0, 0.0);
            }
            case DOWN: {
                return new Vec3d(0.0, -1.0, 0.0);
            }
            case NORTH: {
                return new Vec3d(0.0, 0.0, -1.0);
            }
            case SOUTH: {
                return new Vec3d(0.0, 0.0, 1.0);
            }
            case EAST: {
                return new Vec3d(1.0, 0.0, 0.0);
            }
            case WEST: {
                return new Vec3d(-1.0, 0.0, 0.0);
            }
        }
        return null;
    }

    private EnumFacing getCollisionSide(AxisAlignedBB axis, Beam beam) {
        if (beam.trace != null && beam.trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = beam.trace.func_178782_a();
            Vec3d hitPos = beam.trace.field_72307_f;
            Vec3d dir = hitPos.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (dir.field_72450_a == axis.field_72340_a && dir.field_72448_b > axis.field_72338_b && dir.field_72448_b < axis.field_72337_e && dir.field_72449_c > axis.field_72339_c && dir.field_72449_c < axis.field_72334_f) {
                return EnumFacing.WEST;
            }
            if (dir.field_72450_a == axis.field_72336_d && dir.field_72448_b > axis.field_72338_b && dir.field_72448_b < axis.field_72337_e && dir.field_72449_c > axis.field_72339_c && dir.field_72449_c < axis.field_72334_f) {
                return EnumFacing.EAST;
            }
            if (dir.field_72448_b == axis.field_72338_b && dir.field_72450_a > axis.field_72340_a && dir.field_72450_a < axis.field_72336_d && dir.field_72449_c > axis.field_72339_c && dir.field_72449_c < axis.field_72334_f) {
                return EnumFacing.DOWN;
            }
            if (dir.field_72448_b == axis.field_72337_e && dir.field_72450_a > axis.field_72340_a && dir.field_72450_a < axis.field_72336_d && dir.field_72449_c > axis.field_72339_c && dir.field_72449_c < axis.field_72334_f) {
                return EnumFacing.UP;
            }
            if (dir.field_72449_c == axis.field_72339_c && dir.field_72450_a > axis.field_72340_a && dir.field_72450_a < axis.field_72336_d && dir.field_72448_b > axis.field_72338_b && dir.field_72448_b < axis.field_72337_e) {
                return EnumFacing.NORTH;
            }
            if (dir.field_72449_c == axis.field_72334_f && dir.field_72448_b > axis.field_72338_b && dir.field_72448_b < axis.field_72337_e && dir.field_72448_b > axis.field_72338_b && dir.field_72448_b < axis.field_72337_e) {
                return EnumFacing.SOUTH;
            }
        }
        return null;
    }

    @Override
    public void handleFiberBeam(@NotNull World world, @NotNull BlockPos pos, @NotNull Beam beam) {
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    @NotNull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABBS[((EnumBiFacing)state.func_177229_b(FACING)).ordinal()];
    }

    @Override
    @Nonnull
    public List<EnumFacing> getAvailableFacings(@NotNull IBlockState state, @NotNull IBlockAccess source, @NotNull BlockPos pos, @NotNull EnumFacing original) {
        List<EnumFacing> offsetFacings;
        EnumBiFacing facings = (EnumBiFacing)state.func_177229_b(FACING);
        ArrayList ret = Lists.newArrayList();
        EnumFacing facing = facings.getPrimary();
        IBlockState offsetState = source.func_180495_p(pos.func_177972_a(facing));
        if (offsetState.func_177230_c() instanceof IOpticConnectable) {
            offsetFacings = ((IOpticConnectable)offsetState.func_177230_c()).getAllFacings(offsetState, source, pos.func_177972_a(facing), facing);
            if (!offsetFacings.contains(facing.func_176734_d())) {
                ret.add(facing);
            }
        } else {
            ret.add(facing);
        }
        facing = facings.getSecondary();
        offsetState = source.func_180495_p(pos.func_177972_a(facing));
        if (offsetState.func_177230_c() instanceof IOpticConnectable) {
            offsetFacings = ((IOpticConnectable)offsetState.func_177230_c()).getAllFacings(offsetState, source, pos.func_177972_a(facing), facing);
            if (!offsetFacings.contains(facing.func_176734_d())) {
                ret.add(facing);
            }
        } else {
            ret.add(facing);
        }
        return ret;
    }

    @Override
    @Nonnull
    public List<EnumFacing> getAllFacings(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
        EnumBiFacing facings = (EnumBiFacing)state.func_177229_b(FACING);
        return Lists.newArrayList((Object[])new EnumFacing[]{facings.getPrimary(), facings.getSecondary()});
    }

    @NotNull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int largestPriority = 0;
        int secondPriority = 0;
        EnumFacing primary = null;
        EnumFacing secondary = null;
        for (EnumFacing f : EnumFacing.field_82609_l) {
            int priority = 0;
            if (f == facing || f == facing.func_176734_d()) {
                ++priority;
            }
            if (this.hasConnectible((IBlockAccess)worldIn, pos, f)) {
                priority += 2;
            }
            if (secondPriority >= priority) continue;
            if (largestPriority < priority) {
                secondPriority = largestPriority;
                secondary = primary;
                largestPriority = priority;
                primary = f;
                continue;
            }
            secondPriority = priority;
            secondary = f;
        }
        if (primary == null) {
            primary = secondary == facing ? facing : facing.func_176734_d();
        }
        if (secondary == null) {
            secondary = primary == facing.func_176734_d() ? facing.func_176734_d() : facing;
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumBiFacing.getBiForFacings((EnumFacing)primary, (EnumFacing)secondary));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            EnumFacing a = ((EnumBiFacing)state.func_177229_b(FACING)).getPrimary();
            EnumFacing b = ((EnumBiFacing)state.func_177229_b(FACING)).getSecondary();
            this.updateBlockState(worldIn, pos, a);
            this.updateBlockState(worldIn, pos, b);
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @javax.annotation.Nullable Entity entityIn) {
        BlockOpticFiber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CENTER);
        EnumBiFacing biFacing = (EnumBiFacing)state.func_177229_b(FACING);
        if (biFacing.contains(EnumFacing.DOWN)) {
            BlockOpticFiber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)DOWN_AABB);
        }
        if (biFacing.contains(EnumFacing.UP)) {
            BlockOpticFiber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)UP_AABB);
        }
        if (biFacing.contains(EnumFacing.NORTH)) {
            BlockOpticFiber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
        if (biFacing.contains(EnumFacing.SOUTH)) {
            BlockOpticFiber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (biFacing.contains(EnumFacing.WEST)) {
            BlockOpticFiber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
        if (biFacing.contains(EnumFacing.EAST)) {
            BlockOpticFiber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
    }

    private void updateBlockState(World worldIn, BlockPos pos, EnumFacing f) {
        EnumFacing facing;
        IBlockState offset = worldIn.func_180495_p(pos.func_177972_a(f));
        if (offset.func_177230_c() instanceof BlockOpticFiber && (facing = this.getConnectible((IBlockAccess)worldIn, pos, f)) != null) {
            EnumFacing other = ((EnumBiFacing)offset.func_177229_b(FACING)).getOther(facing);
            if (f.func_176734_d() != other) {
                EnumBiFacing biFacing = EnumBiFacing.getBiForFacings((EnumFacing)other, (EnumFacing)f.func_176734_d());
                worldIn.func_175656_a(pos.func_177972_a(f), offset.func_177226_a(FACING, (Comparable)biFacing));
            }
        }
    }

    private boolean hasConnectible(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.getConnectible(world, pos, facing) != null;
    }

    private EnumFacing getConnectible(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos.func_177972_a(facing));
        if (state.func_177230_c() instanceof IOpticConnectable) {
            List<EnumFacing> facings = ((IOpticConnectable)state.func_177230_c()).getAvailableFacings(state, world, pos.func_177972_a(facing), facing);
            if (facings.contains(facing.func_176734_d())) {
                return facing.func_176734_d();
            }
            for (EnumFacing cross : EnumFacing.field_82609_l) {
                if (cross == facing.func_176734_d() || !facings.contains(cross)) continue;
                return cross;
            }
        }
        return null;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBiFacing)state.func_177229_b(FACING)).ordinal();
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumBiFacing.values()[meta % EnumBiFacing.values().length]);
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean isToolEffective(String type, @NotNull IBlockState state) {
        return Objects.equals(type, "pickaxe") || Objects.equals(type, "screwdriver");
    }

    @Nullable
    public String getHarvestTool(@NotNull IBlockState state) {
        return "pickaxe";
    }
}

