/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.teamwizardry.librarianlib.common.base.block.BlockMod;
import com.teamwizardry.librarianlib.common.network.PacketHandler;
import com.teamwizardry.librarianlib.common.util.math.Matrix4;
import com.teamwizardry.refraction.api.ConfigValues;
import com.teamwizardry.refraction.api.PosUtils;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.Effect;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.api.raytrace.ILaserTrace;
import com.teamwizardry.refraction.api.raytrace.Tri;
import com.teamwizardry.refraction.api.soundmanager.ISoundEmitter;
import com.teamwizardry.refraction.api.soundmanager.SoundManager;
import com.teamwizardry.refraction.common.block.BlockElectronExciter;
import com.teamwizardry.refraction.common.block.BlockPrism;
import com.teamwizardry.refraction.common.network.PacketLaserFX;
import com.teamwizardry.refraction.common.tile.TileElectronExciter;
import com.teamwizardry.refraction.init.ModAchievements;
import com.teamwizardry.refraction.init.ModBlocks;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLightBridge
extends BlockMod
implements IBeamHandler,
ISoundEmitter,
ILaserTrace {
    public static final PropertyEnum<EnumFacing.Axis> FACING = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    public static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");
    private static final EnumFacing[][] SPINS = new EnumFacing[][]{{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, {EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}};
    private static final AxisAlignedBB AABB_X = new AxisAlignedBB(0.0, 0.46875, 0.46875, 1.0, 0.53125, 0.53125);
    private static final AxisAlignedBB AABB_Y = new AxisAlignedBB(0.46875, 0.0, 0.46875, 0.53125, 1.0, 0.53125);
    private static final AxisAlignedBB AABB_Z = new AxisAlignedBB(0.46875, 0.46875, 0.0, 0.53125, 0.53125, 1.0);
    private static final AxisAlignedBB AABB_X_UP = new AxisAlignedBB(0.0, 0.53125, 0.46875, 1.0, 1.0, 0.53125);
    private static final AxisAlignedBB AABB_X_DOWN = new AxisAlignedBB(0.0, 0.0, 0.46875, 1.0, 0.46875, 0.53125);
    private static final AxisAlignedBB AABB_X_LEFT = new AxisAlignedBB(0.0, 0.46875, 0.0, 1.0, 0.53125, 0.46875);
    private static final AxisAlignedBB AABB_X_RIGHT = new AxisAlignedBB(0.0, 0.46875, 0.53125, 1.0, 0.53125, 1.0);
    private static final AxisAlignedBB AABB_Y_UP = new AxisAlignedBB(0.46875, 0.0, 0.0, 0.53125, 1.0, 0.46875);
    private static final AxisAlignedBB AABB_Y_DOWN = new AxisAlignedBB(0.46875, 0.0, 0.53125, 0.53125, 1.0, 1.0);
    private static final AxisAlignedBB AABB_Y_LEFT = new AxisAlignedBB(0.53125, 0.0, 0.46875, 1.0, 1.0, 0.53125);
    private static final AxisAlignedBB AABB_Y_RIGHT = new AxisAlignedBB(0.0, 0.0, 0.46875, 0.46875, 1.0, 0.53125);
    private static final AxisAlignedBB AABB_Z_UP = new AxisAlignedBB(0.46875, 0.53125, 0.0, 0.53125, 1.0, 1.0);
    private static final AxisAlignedBB AABB_Z_DOWN = new AxisAlignedBB(0.46875, 0.0, 0.0, 0.53125, 0.46875, 1.0);
    private static final AxisAlignedBB AABB_Z_LEFT = new AxisAlignedBB(0.53125, 0.46875, 0.0, 1.0, 0.53125, 1.0);
    private static final AxisAlignedBB AABB_Z_RIGHT = new AxisAlignedBB(0.0, 0.46875, 0.0, 0.46875, 0.53125, 1.0);

    public BlockLightBridge() {
        super("light_bridge", Material.field_151592_s, new String[0]);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149675_a(true);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(FACING);
        EnumFacing[] facings = SPINS[axis.ordinal()];
        IBlockState upState = worldIn.func_180495_p(pos.func_177972_a(facings[0]));
        boolean up = upState.func_177230_c() == this && upState.func_177229_b(FACING) == axis;
        IBlockState downState = worldIn.func_180495_p(pos.func_177972_a(facings[1]));
        boolean down = downState.func_177230_c() == this && downState.func_177229_b(FACING) == axis;
        IBlockState leftState = worldIn.func_180495_p(pos.func_177972_a(facings[2]));
        boolean left = leftState.func_177230_c() == this && leftState.func_177229_b(FACING) == axis;
        IBlockState rightState = worldIn.func_180495_p(pos.func_177972_a(facings[3]));
        boolean right = rightState.func_177230_c() == this && rightState.func_177229_b(FACING) == axis;
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(up && (!down || left || right))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(down && (!up || left || right))).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(left && (up || down || !right))).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(right && (up || down || !left)));
    }

    @Nullable
    public ItemBlock createItemForm() {
        return null;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityPlayer) {
            ((EntityPlayer)entityIn).func_71064_a((StatBase)ModAchievements.LIGHT_BRIDGE, 1);
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        EnumFacing.Axis enumfacing = (EnumFacing.Axis)state.func_177229_b(FACING);
        EnumFacing[] facings = SPINS[enumfacing.ordinal()];
        IBlockState upState = worldIn.func_180495_p(pos.func_177972_a(facings[0]));
        boolean up = upState.func_177230_c() == this && upState.func_177229_b(FACING) == enumfacing;
        IBlockState downState = worldIn.func_180495_p(pos.func_177972_a(facings[1]));
        boolean down = downState.func_177230_c() == this && downState.func_177229_b(FACING) == enumfacing;
        IBlockState leftState = worldIn.func_180495_p(pos.func_177972_a(facings[2]));
        boolean left = leftState.func_177230_c() == this && leftState.func_177229_b(FACING) == enumfacing;
        IBlockState rightState = worldIn.func_180495_p(pos.func_177972_a(facings[3]));
        boolean right = rightState.func_177230_c() == this && rightState.func_177229_b(FACING) == enumfacing;
        switch (enumfacing) {
            case X: {
                BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_X);
                if (up) {
                    BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_X_UP);
                }
                if (down) {
                    BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_X_DOWN);
                }
                if (left) {
                    BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_X_LEFT);
                }
                if (!right) break;
                BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_X_RIGHT);
                break;
            }
            case Y: {
                BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_Y);
                if (up) {
                    BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_Y_UP);
                }
                if (down) {
                    BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_Y_DOWN);
                }
                if (left) {
                    BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_Y_LEFT);
                }
                if (!right) break;
                BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_Y_RIGHT);
                break;
            }
            case Z: {
                BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_Z);
                if (up) {
                    BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_Z_UP);
                }
                if (down) {
                    BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_Z_DOWN);
                }
                if (left) {
                    BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_Z_LEFT);
                }
                if (!right) break;
                BlockLightBridge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_Z_RIGHT);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB box;
        EnumFacing.Axis enumfacing = (EnumFacing.Axis)state.func_177229_b(FACING);
        EnumFacing[] facings = SPINS[enumfacing.ordinal()];
        IBlockState upState = source.func_180495_p(pos.func_177972_a(facings[0]));
        boolean up = upState.func_177230_c() == this && upState.func_177229_b(FACING) == enumfacing;
        IBlockState downState = source.func_180495_p(pos.func_177972_a(facings[1]));
        boolean down = downState.func_177230_c() == this && downState.func_177229_b(FACING) == enumfacing;
        IBlockState leftState = source.func_180495_p(pos.func_177972_a(facings[2]));
        boolean left = leftState.func_177230_c() == this && leftState.func_177229_b(FACING) == enumfacing;
        IBlockState rightState = source.func_180495_p(pos.func_177972_a(facings[3]));
        boolean right = rightState.func_177230_c() == this && rightState.func_177229_b(FACING) == enumfacing;
        switch (enumfacing) {
            case X: {
                box = AABB_X;
                if (up) {
                    box = box.func_111270_a(AABB_X_UP);
                }
                if (down) {
                    box = box.func_111270_a(AABB_X_DOWN);
                }
                if (left) {
                    box = box.func_111270_a(AABB_X_LEFT);
                }
                if (!right) break;
                box = box.func_111270_a(AABB_X_RIGHT);
                break;
            }
            case Y: {
                box = AABB_Y;
                if (up) {
                    box = box.func_111270_a(AABB_Y_UP);
                }
                if (down) {
                    box = box.func_111270_a(AABB_Y_DOWN);
                }
                if (left) {
                    box = box.func_111270_a(AABB_Y_LEFT);
                }
                if (!right) break;
                box = box.func_111270_a(AABB_Y_RIGHT);
                break;
            }
            case Z: {
                box = AABB_Z;
                if (up) {
                    box = box.func_111270_a(AABB_Z_UP);
                }
                if (down) {
                    box = box.func_111270_a(AABB_Z_DOWN);
                }
                if (left) {
                    box = box.func_111270_a(AABB_Z_LEFT);
                }
                if (!right) break;
                box = box.func_111270_a(AABB_Z_RIGHT);
                break;
            }
            default: {
                box = field_185506_k;
            }
        }
        return box;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.Axis.values()[meta %= 3]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing.Axis)state.func_177229_b(FACING)).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, UP, DOWN, LEFT, RIGHT});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        SoundManager.INSTANCE.addSpeakerNode(worldIn, pos, (Block)this);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        this.func_180650_b(worldIn, pos, state, random);
        EnumFacing.Axis block = (EnumFacing.Axis)worldIn.func_180495_p(pos).func_177229_b(FACING);
        EnumFacing positive = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)block);
        EnumFacing negative = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)block);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing != positive && facing != negative) continue;
        }
    }

    @Override
    public boolean handleBeam(@NotNull World world, @NotNull BlockPos pos, @NotNull Beam beam) {
        IBlockState state;
        block11: {
            EnumFacing facing;
            block12: {
                state = world.func_180495_p(pos);
                EnumFacing.Axis block = (EnumFacing.Axis)world.func_180495_p(pos).func_177229_b(FACING);
                Effect effect = beam.effect;
                if (effect == null) {
                    return true;
                }
                if (beam.color.getRGB() != Color.CYAN.getRGB()) break block11;
                EnumFacing positive = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)block);
                EnumFacing negative = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)block);
                Vec3d slope = beam.slope.func_72432_b();
                if (slope.func_72430_b(new Vec3d(positive.func_176730_m())) > 0.999) break block12;
                Vec3d vec3d = new Vec3d(negative.func_176730_m());
                if (!(slope.func_72430_b(vec3d) > 0.999)) break block11;
            }
            if ((facing = PosUtils.getFacing(beam.initLoc, beam.finalLoc)) == null) {
                return true;
            }
            for (int i = 1; i < ConfigValues.BEAM_RANGE; ++i) {
                BlockPos backwards = pos.func_177967_a(facing, i);
                if (world.func_180495_p(backwards).func_177230_c() == ModBlocks.ELECTRON_EXCITER) {
                    IBlockState baseExciterState = world.func_180495_p(backwards);
                    EnumFacing baseExciterFacing = (EnumFacing)baseExciterState.func_177229_b((IProperty)BlockElectronExciter.FACING);
                    TileElectronExciter exciter = (TileElectronExciter)world.func_175625_s(backwards);
                    if (exciter != null) {
                        boolean pass = false;
                        for (EnumFacing facing2 : EnumFacing.field_82609_l) {
                            TileElectronExciter neighbor;
                            if (facing2 == baseExciterFacing && facing2 == baseExciterFacing.func_176734_d() || (neighbor = (TileElectronExciter)world.func_175625_s(backwards.func_177972_a(facing2))) == null || !neighbor.hasCardinalBeam) continue;
                            pass = true;
                            break;
                        }
                        if (pass) {
                            exciter.expire = 20;
                            if (world.func_175623_d(pos.func_177972_a(baseExciterFacing))) {
                                world.func_180501_a(pos.func_177972_a(baseExciterFacing), ModBlocks.LIGHT_BRIDGE.func_176223_P().func_177226_a(FACING, (Comparable)baseExciterFacing.func_176740_k()), 3);
                            }
                            return true;
                        }
                        world.func_175698_g(pos);
                        continue;
                    }
                    world.func_175698_g(pos);
                    continue;
                }
                if (world.func_180495_p(backwards).func_177230_c() != Blocks.field_150350_a) continue;
                world.func_175698_g(pos);
                return true;
            }
        }
        this.fireColor(world, pos, state, beam.finalLoc, beam.finalLoc.func_178788_d(beam.initLoc).func_72432_b(), ConfigValues.GLASS_IOR, beam);
        return true;
    }

    @Override
    public boolean shouldEmit(@NotNull World world, @NotNull BlockPos pos) {
        return true;
    }

    private void fireColor(World world, BlockPos pos, IBlockState state, Vec3d hitPos, Vec3d ref, double IORMod, Beam beam) {
        RayTraceResult r = this.collisionRayTraceLaser(state, world, pos, hitPos.func_178788_d(ref), hitPos.func_178787_e(ref));
        assert (r != null);
        Vec3d normal = (Vec3d)r.data;
        ref = this.refracted(ConfigValues.AIR_IOR + IORMod, ConfigValues.GLASS_IOR + IORMod, ref, normal).func_72432_b();
        hitPos = r.field_72307_f;
        for (int i = 0; i < 5; ++i) {
            r = this.collisionRayTraceLaser(state, world, pos, hitPos.func_178787_e(ref), hitPos);
            assert (r != null);
            normal = ((Vec3d)r.data).func_186678_a(-1.0);
            Vec3d oldRef = ref;
            ref = this.refracted(ConfigValues.GLASS_IOR + IORMod, ConfigValues.AIR_IOR + IORMod, ref, normal).func_72432_b();
            if (Double.isNaN(ref.field_72450_a) || Double.isNaN(ref.field_72448_b) || Double.isNaN(ref.field_72449_c)) {
                ref = oldRef;
                break;
            }
            this.showBeam(world, hitPos, r.field_72307_f, beam.color);
            hitPos = r.field_72307_f;
        }
        beam.createSimilarBeam(hitPos, ref).enableParticleBeginning().spawn();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }

    private Vec3d refracted(double from, double to, Vec3d vec, Vec3d normal) {
        double r = from / to;
        double c = -normal.func_72430_b(vec);
        return vec.func_186678_a(r).func_178787_e(normal.func_186678_a(r * c - Math.sqrt(1.0 - r * r * (1.0 - c * c))));
    }

    private void showBeam(World world, Vec3d start, Vec3d end, Color color) {
        if (!world.field_72995_K) {
            PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketLaserFX(start, end, color), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), start.field_72450_a, start.field_72448_b, start.field_72449_c, 256.0));
        }
    }

    @Override
    public BlockPrism.RayTraceResultData<Vec3d> collisionRayTraceLaser(@NotNull IBlockState blockState, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Vec3d startRaw, @NotNull Vec3d endRaw) {
        EnumFacing facing = EnumFacing.UP;
        Matrix4 matrixA = new Matrix4();
        Matrix4 matrixB = new Matrix4();
        switch (facing) {
            case UP: 
            case DOWN: 
            case EAST: {
                break;
            }
            case NORTH: {
                matrixA.rotate(Math.toRadians(270.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(270.0), new Vec3d(0.0, 1.0, 0.0));
                break;
            }
            case SOUTH: {
                matrixA.rotate(Math.toRadians(90.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(90.0), new Vec3d(0.0, 1.0, 0.0));
                break;
            }
            case WEST: {
                matrixA.rotate(Math.toRadians(180.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(180.0), new Vec3d(0.0, 1.0, 0.0));
            }
        }
        Vec3d a = new Vec3d(0.001, 0.001, 0.0);
        Vec3d b = new Vec3d(1.0, 0.001, 0.5);
        Vec3d c = new Vec3d(0.001, 0.001, 1.0);
        Vec3d A = a.func_72441_c(0.0, 0.998, 0.0);
        Vec3d B = b.func_72441_c(0.0, 0.998, 0.0);
        Vec3d C = c.func_72441_c(0.0, 0.998, 0.0);
        Tri[] tris = new Tri[]{new Tri(a, b, c), new Tri(A, C, B), new Tri(a, c, C), new Tri(a, C, A), new Tri(a, A, B), new Tri(a, B, b), new Tri(b, B, C), new Tri(b, C, c)};
        Vec3d start = matrixA.apply(startRaw.func_178788_d(new Vec3d((Vec3i)pos)).func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5);
        Vec3d end = matrixA.apply(endRaw.func_178788_d(new Vec3d((Vec3i)pos)).func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5);
        Tri hitTri = null;
        Vec3d hit = null;
        double shortestSq = Double.POSITIVE_INFINITY;
        for (Tri tri : tris) {
            double distSq;
            Vec3d v = tri.trace(start, end);
            if (v == null || !((distSq = start.func_178788_d(v).func_189985_c()) < shortestSq)) continue;
            hit = v;
            shortestSq = distSq;
            hitTri = tri;
        }
        if (hit == null) {
            return null;
        }
        return new BlockPrism.RayTraceResultData<Vec3d>(matrixB.apply(hit.func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d((Vec3i)pos)), EnumFacing.UP, pos).data(matrixB.apply(hitTri.normal()));
    }
}

