/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockMod;
import com.teamwizardry.librarianlib.common.network.PacketHandler;
import com.teamwizardry.librarianlib.common.util.math.Matrix4;
import com.teamwizardry.refraction.api.ConfigValues;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.api.raytrace.ILaserTrace;
import com.teamwizardry.refraction.api.raytrace.Tri;
import com.teamwizardry.refraction.common.block.BlockPrism;
import com.teamwizardry.refraction.common.network.PacketLaserFX;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class BlockLens
extends BlockMod
implements ILaserTrace,
IBeamHandler {
    public BlockLens() {
        super("lens", Material.field_151592_s, new String[0]);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public static Vec3d refracted(double from, double to, Vec3d vec, Vec3d normal) {
        double r = from / to;
        double c = -normal.func_72430_b(vec);
        return vec.func_186678_a(r).func_178787_e(normal.func_186678_a(r * c - Math.sqrt(1.0 - r * r * (1.0 - c * c))));
    }

    public static void showBeam(World world, Vec3d start, Vec3d end, Color color) {
        if (!world.field_72995_K) {
            PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketLaserFX(start, end, color), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), start.field_72450_a, start.field_72448_b, start.field_72449_c, 256.0));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        return blockState != iblockstate || block != this && block != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Override
    public boolean handleBeam(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Beam beam) {
        IBlockState state = world.func_180495_p(pos);
        this.fireColor(world, pos, state, beam.finalLoc, beam.finalLoc.func_178788_d(beam.initLoc).func_72432_b(), ConfigValues.GLASS_IOR, beam);
        return true;
    }

    private void fireColor(World world, BlockPos pos, IBlockState state, Vec3d hitPos, Vec3d ref, double IORMod, Beam beam) {
        RayTraceResult r = this.collisionRayTraceLaser(state, world, pos, hitPos.func_178788_d(ref), hitPos.func_178787_e(ref));
        if (r != null && r.data != null) {
            Vec3d normal = (Vec3d)r.data;
            ref = BlockLens.refracted(ConfigValues.AIR_IOR + IORMod, ConfigValues.GLASS_IOR + IORMod, ref, normal).func_72432_b();
            hitPos = r.field_72307_f;
            for (int i = 0; i < 5; ++i) {
                r = this.collisionRayTraceLaser(state, world, pos, hitPos.func_178787_e(ref), hitPos);
                if (r == null || r.data == null) continue;
                normal = ((Vec3d)r.data).func_186678_a(-1.0);
                Vec3d oldRef = ref;
                ref = BlockLens.refracted(ConfigValues.GLASS_IOR + IORMod, ConfigValues.AIR_IOR + IORMod, ref, normal).func_72432_b();
                if (Double.isNaN(ref.field_72450_a) || Double.isNaN(ref.field_72448_b) || Double.isNaN(ref.field_72449_c)) {
                    ref = oldRef;
                    break;
                }
                BlockLens.showBeam(world, hitPos, r.field_72307_f, beam.color);
                hitPos = r.field_72307_f;
            }
            beam.createSimilarBeam(hitPos, ref).enableParticleBeginning().spawn();
        }
    }

    @Override
    public BlockPrism.RayTraceResultData<Vec3d> collisionRayTraceLaser(@NotNull IBlockState blockState, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Vec3d startRaw, @NotNull Vec3d endRaw) {
        EnumFacing facing = EnumFacing.UP;
        Matrix4 matrixA = new Matrix4();
        Matrix4 matrixB = new Matrix4();
        switch (facing) {
            case UP: 
            case DOWN: 
            case EAST: {
                break;
            }
            case NORTH: {
                matrixA.rotate(Math.toRadians(270.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(270.0), new Vec3d(0.0, 1.0, 0.0));
                break;
            }
            case SOUTH: {
                matrixA.rotate(Math.toRadians(90.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(90.0), new Vec3d(0.0, 1.0, 0.0));
                break;
            }
            case WEST: {
                matrixA.rotate(Math.toRadians(180.0), new Vec3d(0.0, -1.0, 0.0));
                matrixB.rotate(Math.toRadians(180.0), new Vec3d(0.0, 1.0, 0.0));
            }
        }
        Vec3d a = new Vec3d(0.001, 0.001, 0.0);
        Vec3d b = new Vec3d(1.0, 0.001, 0.5);
        Vec3d c = new Vec3d(0.001, 0.001, 1.0);
        Vec3d A = a.func_72441_c(0.0, 0.998, 0.0);
        Vec3d B = b.func_72441_c(0.0, 0.998, 0.0);
        Vec3d C = c.func_72441_c(0.0, 0.998, 0.0);
        Tri[] tris = new Tri[]{new Tri(a, b, c), new Tri(A, C, B), new Tri(a, c, C), new Tri(a, C, A), new Tri(a, A, B), new Tri(a, B, b), new Tri(b, B, C), new Tri(b, C, c)};
        Vec3d start = matrixA.apply(startRaw.func_178788_d(new Vec3d((Vec3i)pos)).func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5);
        Vec3d end = matrixA.apply(endRaw.func_178788_d(new Vec3d((Vec3i)pos)).func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5);
        Tri hitTri = null;
        Vec3d hit = null;
        double shortestSq = Double.POSITIVE_INFINITY;
        for (Tri tri : tris) {
            double distSq;
            Vec3d v = tri.trace(start, end);
            if (v == null || !((distSq = start.func_178788_d(v).func_189985_c()) < shortestSq)) continue;
            hit = v;
            shortestSq = distSq;
            hitTri = tri;
        }
        if (hit == null) {
            return null;
        }
        return new BlockPrism.RayTraceResultData<Vec3d>(matrixB.apply(hit.func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d((Vec3i)pos)), EnumFacing.UP, pos).data(matrixB.apply(hitTri.normal()));
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return super.isToolEffective(type, state) || Objects.equals(type, "screwdriver");
    }
}

