/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockModContainer;
import com.teamwizardry.refraction.api.CapsUtils;
import com.teamwizardry.refraction.api.beam.IBeamImmune;
import com.teamwizardry.refraction.api.soundmanager.ISoundEmitter;
import com.teamwizardry.refraction.common.tile.TileLaser;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLaser
extends BlockModContainer
implements IBeamImmune,
ISoundEmitter {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);

    public BlockLaser() {
        super("laser", Material.field_151573_f, new String[0]);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH));
    }

    private TileLaser getTE(World world, BlockPos pos) {
        return (TileLaser)world.func_175625_s(pos);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return (int)((double)this.getTE((World)worldIn, (BlockPos)pos).inventory.getStackInSlot((int)0).field_77994_a / 64.0 * 15.0);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null) {
            if (heldItem.func_77973_b() != Items.field_151114_aO) {
                return false;
            }
            TileLaser laser = this.getTE(worldIn, pos);
            if (laser == null) {
                return false;
            }
            ItemStack stack = heldItem.func_77946_l();
            stack.field_77994_a = 1;
            ItemStack left = laser.inventory.insertItem(0, stack, false);
            if (left == null) {
                --heldItem.field_77994_a;
            }
            laser.func_70296_d();
        }
        return true;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (placer.field_70125_A > 45.0f) {
            return this.func_176203_a(meta).func_177226_a(FACING, (Comparable)EnumFacing.UP);
        }
        if (placer.field_70125_A < -45.0f) {
            return this.func_176203_a(meta).func_177226_a(FACING, (Comparable)EnumFacing.DOWN);
        }
        return this.func_176203_a(meta).func_177226_a(FACING, (Comparable)placer.func_184172_bi().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState iBlockState) {
        return new TileLaser();
    }

    @Override
    public boolean shouldEmit(@NotNull World world, @NotNull BlockPos pos) {
        TileLaser laser = (TileLaser)world.func_175625_s(pos);
        return !world.func_175640_z(pos) && world.func_175687_A(pos) <= 0 && laser != null && laser.inventory.getStackInSlot(0) != null && laser.inventory.getStackInSlot((int)0).field_77994_a > 0;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return super.isToolEffective(type, state) || Objects.equals(type, "screwdriver");
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileLaser laser = (TileLaser)worldIn.func_175625_s(pos);
        if (laser != null) {
            for (ItemStack stack : CapsUtils.getListOfItems((IItemHandler)laser.inventory)) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean isImmune(@NotNull World world, @NotNull BlockPos pos) {
        return true;
    }
}

